/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator.tile;

import java.util.HashMap;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.AcceleratorLogic;
import lach_01298.qmd.accelerator.LinearAcceleratorLogic;
import lach_01298.qmd.accelerator.tile.TileAcceleratorBeamPort;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import lach_01298.qmd.particle.ParticleStack;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.recipe.BasicRecipe;
import nc.recipe.ingredient.IFluidIngredient;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileAcceleratorComputerPort
extends TileAcceleratorPart
implements SimpleComponent {
    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "qmd_accelerator";
    }

    public TileAcceleratorComputerPort() {
        super(CuboidalPartPositionType.EXTERIOR);
    }

    @Override
    public void onMachineAssembled(Accelerator controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Callback(doc="--function():bool Is Acclelerator complete")
    @Optional.Method(modid="opencomputers")
    public Object[] isComplete(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled()};
    }

    @Callback(doc="--function():bool")
    @Optional.Method(modid="opencomputers")
    public Object[] isAcceleratorOn(Context context, Arguments args) {
        return new Object[]{((AcceleratorLogic)this.getLogic()).isAcceleratorOn()};
    }

    @Callback(doc="--function():int")
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfRfCavity(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).RFCavityNumber : 0};
    }

    @Callback(doc="--function():int")
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfDipole(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).dipoleNumber : 0};
    }

    @Callback(doc="--function():int")
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfQuadrupole(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).quadrupoleNumber : 0};
    }

    @Callback(doc="--function():int Returns accelerators temperature.")
    @Optional.Method(modid="opencomputers")
    public Object[] getTemperature(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).getTemperature() : 0};
    }

    @Callback(doc="--function():int Returns maximum operating temperature.")
    @Optional.Method(modid="opencomputers")
    public Object[] getMaxTemperature(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).maxOperatingTemp : 0};
    }

    @Callback(doc="--function():table Returns infomation about the heat buffer of the accelerator. (stored_heat, heat_capacity)")
    @Optional.Method(modid="opencomputers")
    public Object[] getHeatBufferInfo(Context context, Arguments args) {
        HashMap<String, Long> statsData = new HashMap<String, Long>();
        statsData.put("heat_stored", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).heatBuffer.getHeatStored() : 0L);
        statsData.put("heat_capacity", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).heatBuffer.getHeatCapacity() : 0L);
        return new Object[]{statsData};
    }

    @Callback(doc="--function():table Returns infomation about the cooling of the accelerator. (cooling_fluid, cooling, max_coolant_in, max_coolant_out)")
    @Optional.Method(modid="opencomputers")
    public Object[] getCoolingInfo(Context context, Arguments args) {
        HashMap<String, Object> statsData = new HashMap<String, Object>();
        statsData.put("cooling_fluid", this.isMultiblockAssembled() ? ((FluidStack)((IFluidIngredient)((BasicRecipe)((Accelerator)this.getMultiblock()).coolingRecipeInfo.getRecipe()).getFluidIngredients().get(0)).getStack()).getLocalizedName() : "");
        statsData.put("cooling", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).cooling : 0L);
        statsData.put("maxCoolantIn", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).maxCoolantIn : 0);
        statsData.put("maxCoolantOut", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).maxCoolantOut : 0);
        return new Object[]{statsData};
    }

    @Callback(doc="--function():table Returns infomation about the cooling of the accelerator. (internal_heating, external_heating, max_external_heating, ambient_temperature)")
    @Optional.Method(modid="opencomputers")
    public Object[] getHeatingInfo(Context context, Arguments args) {
        HashMap<String, Number> statsData = new HashMap<String, Number>();
        statsData.put("internal_heating", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).rawHeating : 0L);
        statsData.put("external_heating", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).getExternalHeating() : 0L);
        statsData.put("max_external_heating", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).getMaxExternalHeating() : 0L);
        statsData.put("ambient_temperature", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).ambientTemp : 290);
        return new Object[]{statsData};
    }

    @Callback(doc="--function():table Returns infomation about the size of the accelerator. (x_length, y_length, z_length, volume, surface_area)")
    @Optional.Method(modid="opencomputers")
    public Object[] getSizeInfo(Context context, Arguments args) {
        HashMap<String, Integer> statsData = new HashMap<String, Integer>();
        statsData.put("x_length", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).getExteriorLengthX() : 0);
        statsData.put("y_length", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).getExteriorLengthY() : 0);
        statsData.put("z_length", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).getExteriorLengthZ() : 0);
        statsData.put("volume", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).getExteriorVolume() : 0);
        statsData.put("surface_area", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).getExteriorSurfaceArea() : 0);
        return new Object[]{statsData};
    }

    @Callback(doc="--function():table Returns infomation about the beam of the accelerator. (beam_length, beam_radius)")
    @Optional.Method(modid="opencomputers")
    public Object[] getBeamInfo(Context context, Arguments args) {
        HashMap<String, Number> statsData = new HashMap<String, Number>();
        statsData.put("beam_length", this.isMultiblockAssembled() ? ((AcceleratorLogic)((Accelerator)this.getMultiblock()).controller.getLogic()).getBeamLength() : 0);
        statsData.put("beam_radius", this.isMultiblockAssembled() ? ((AcceleratorLogic)((Accelerator)this.getMultiblock()).controller.getLogic()).getBeamRadius() : 0.0);
        return new Object[]{statsData};
    }

    @Callback(doc="--function():table Returns infomation about the energy and energy usage of the accelerator. (energy_required, energy_stored, energy_capacity, energy_efficiency)")
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyInfo(Context context, Arguments args) {
        HashMap<String, Number> statsData = new HashMap<String, Number>();
        statsData.put("energy_required", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).requiredEnergy : 0);
        statsData.put("energy_stored", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).energyStorage.getEnergyStored() : 0);
        statsData.put("energy_capacity", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).energyStorage.getMaxEnergyStored() : 0);
        statsData.put("energy_efficiency", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).efficiency : 0.0);
        return new Object[]{statsData};
    }

    @Callback(doc="--function():table Returns general accelerator statistics. (accelerating_voltage, dipole_strength, quadrupole_strength, input_particle_min_energy)")
    @Optional.Method(modid="opencomputers")
    public Object[] getStats(Context context, Arguments args) {
        HashMap<String, Number> statsData = new HashMap<String, Number>();
        statsData.put("accelerating_voltage", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).acceleratingVoltage : 0);
        statsData.put("dipole_strength", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).dipoleStrength : 0.0);
        statsData.put("quadrupole_strength", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).quadrupoleStrength : 0.0);
        statsData.put("input_particle_min_energy", this.isMultiblockAssembled() ? ((Accelerator)this.getMultiblock()).beams.get(0).getMinEnergy() : 0L);
        return new Object[]{statsData};
    }

    @Callback(doc="--function():bool Returns if the accelerator has a particle stack")
    @Optional.Method(modid="opencomputers")
    public Object[] hasParticle(Context context, Arguments args) {
        return new Object[]{((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack() != null};
    }

    @Callback(doc="--function():table Returns input particle stack parameters.(type, amount, energy, focus)")
    @Optional.Method(modid="opencomputers")
    public Object[] getInputParticleInfo(Context context, Arguments args) {
        HashMap<String, Object> infoData = new HashMap<String, Object>();
        if (((Accelerator)this.getMultiblock()).beams.get(0).getParticleStack() != null) {
            infoData.put("type", ((Accelerator)this.getMultiblock()).beams.get(0).getParticleStack().getParticle().getName());
            infoData.put("amount", ((Accelerator)this.getMultiblock()).beams.get(0).getParticleStack().getAmount());
            infoData.put("energy", ((Accelerator)this.getMultiblock()).beams.get(0).getParticleStack().getMeanEnergy());
            infoData.put("focus", ((Accelerator)this.getMultiblock()).beams.get(0).getParticleStack().getFocus());
        }
        return new Object[]{infoData};
    }

    @Callback(doc="--function():table Returns output particle stack parameters.(type, amount, energy, focus)")
    @Optional.Method(modid="opencomputers")
    public Object[] getOutputParticleInfo(Context context, Arguments args) {
        HashMap<String, Object> infoData = new HashMap<String, Object>();
        if (((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack() != null) {
            infoData.put("type", ((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack().getParticle().getName());
            infoData.put("amount", ((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack().getAmount());
            infoData.put("energy", ((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack().getMeanEnergy());
            infoData.put("focus", ((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack().getFocus());
        }
        return new Object[]{infoData};
    }

    @Callback(doc="--function():table Returns synchrotron port particle stack parameters.(type, amount, energy, focus)")
    @Optional.Method(modid="opencomputers")
    public Object[] getSynchrotronParticleInfo(Context context, Arguments args) {
        HashMap<String, Object> infoData = new HashMap<String, Object>();
        if (((Accelerator)this.getMultiblock()).beams.size() >= 3 && ((Accelerator)this.getMultiblock()).beams.get(2).getParticleStack() != null) {
            infoData.put("type", ((Accelerator)this.getMultiblock()).beams.get(2).getParticleStack().getParticle().getName());
            infoData.put("amount", ((Accelerator)this.getMultiblock()).beams.get(2).getParticleStack().getAmount());
            infoData.put("energy", ((Accelerator)this.getMultiblock()).beams.get(2).getParticleStack().getMeanEnergy());
            infoData.put("focus", ((Accelerator)this.getMultiblock()).beams.get(2).getParticleStack().getFocus());
        }
        return new Object[]{infoData};
    }

    @Callback(doc="--function():table Returns infomation about the particle type.(type, mass, energy, charge, spin, interacts_with_em, interacts_with_weak, interacts_with_strong)")
    @Optional.Method(modid="opencomputers")
    public Object[] getParticleInfo(Context context, Arguments args) {
        HashMap<String, Object> infoData = new HashMap<String, Object>();
        if (((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack() != null) {
            infoData.put("type", ((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack().getParticle().getName());
            infoData.put("mass", ((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack().getParticle().getMass());
            infoData.put("charge", ((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack().getParticle().getCharge());
            infoData.put("spin", ((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack().getParticle().getSpin());
            infoData.put("interacts_with_em", ((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack().getParticle().interactsWithEM());
            infoData.put("interacts_with_weak", ((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack().getParticle().interactsWithWeak());
            infoData.put("interacts_with_strong", ((Accelerator)this.getMultiblock()).beams.get(1).getParticleStack().getParticle().interactsWithStrong());
        }
        return new Object[]{infoData};
    }

    @Callback(doc="--function():bool Returns if the accelerator has an ion source")
    @Optional.Method(modid="opencomputers")
    public Object[] hasIonSource(Context context, Arguments args) {
        LinearAcceleratorLogic logic;
        boolean hasSource = false;
        if (((Accelerator)this.getMultiblock()).controller.getLogicID() == "linear_accelerator" && (logic = (LinearAcceleratorLogic)((Accelerator)this.getMultiblock()).controller.getLogic()).getSource() != null) {
            hasSource = true;
        }
        return new Object[]{hasSource};
    }

    @Callback(doc="--function():table Returns infomation about the ion source. (source_item, particle_type, amount, energy, focus)")
    @Optional.Method(modid="opencomputers")
    public Object[] getIonSourceInfo(Context context, Arguments args) {
        LinearAcceleratorLogic logic;
        HashMap<String, Object> infoData = new HashMap<String, Object>();
        if (((Accelerator)this.getMultiblock()).controller.getLogicID() == "linear_accelerator" && (logic = (LinearAcceleratorLogic)((Accelerator)this.getMultiblock()).controller.getLogic()).getSource() != null) {
            infoData.put("source_item", logic.getSource() != null ? ((ItemStack)logic.getSource().getInventoryStacks().get(0)).func_82833_r() : "");
            if (logic.recipeInfo.getRecipe() != null) {
                ParticleStack particle = (ParticleStack)logic.recipeInfo.getRecipe().getParticleProducts().get(0).getStack();
                infoData.put("particle_type", logic.recipeInfo != null ? particle.getParticle().getName() : "");
                infoData.put("amount", particle.getAmount());
                infoData.put("energy", particle.getMeanEnergy());
                infoData.put("focus", particle.getFocus());
            } else {
                infoData.put("particle_type", "");
                infoData.put("amount", 0);
                infoData.put("energy", 0L);
                infoData.put("focus", 0.0);
            }
        }
        return new Object[]{infoData};
    }

    @Callback(doc="--function(int energy_percentage):int changes output particle energy to this percentage of the max energy (For decelerators it outputs the opposite percentage e.g. 15% -> 85% output energy). Can only be between 5 and 100 inclusive or 0 to turn of accelerator entirely. For beam diverters this only turns it on/off. Returns what it was set to")
    @Optional.Method(modid="opencomputers")
    public Object[] setEnergyPercentage(Context context, Arguments args) {
        if (!this.isMultiblockAssembled()) {
            return new Object[]{false};
        }
        ((Accelerator)this.getMultiblock()).computerControlled = true;
        int percentage = args.checkInteger(0);
        if (percentage < 5) {
            percentage = 0;
        }
        if (percentage > 100) {
            percentage = 100;
        }
        ((Accelerator)this.getMultiblock()).energyPercentage = percentage;
        return new Object[]{percentage};
    }

    @Callback(doc="--function(bool computer_controlled):bool turns computer controlled mode on/off. With this on accelerator controller ignores redstone. Returns what it was set to")
    @Optional.Method(modid="opencomputers")
    public Object[] setComputerControlled(Context context, Arguments args) {
        boolean computerCotrolled;
        if (!this.isMultiblockAssembled()) {
            return new Object[]{false};
        }
        ((Accelerator)this.getMultiblock()).computerControlled = computerCotrolled = args.checkBoolean(0);
        return new Object[]{computerCotrolled};
    }

    @Callback(doc="--function():int Returns the energyPercentage set.")
    @Optional.Method(modid="opencomputers")
    public Object[] getEnergyPercentage(Context context, Arguments args) {
        if (!this.isMultiblockAssembled()) {
            return new Object[]{false};
        }
        return new Object[]{((Accelerator)this.getMultiblock()).energyPercentage};
    }

    @Callback(doc="--function():bool Returns if accelerator is in computer controlled mode")
    @Optional.Method(modid="opencomputers")
    public Object[] isComputerControlled(Context context, Arguments args) {
        if (!this.isMultiblockAssembled()) {
            return new Object[]{false};
        }
        return new Object[]{((Accelerator)this.getMultiblock()).computerControlled};
    }

    @Callback(doc="--function(x,y,z):bool Returns if position (x,y,z) is a beam port")
    @Optional.Method(modid="opencomputers")
    public Object[] isBeamPort(Context context, Arguments args) {
        if (!this.isMultiblockAssembled()) {
            return new Object[]{false};
        }
        BlockPos pos = new BlockPos(args.checkInteger(0), args.checkInteger(1), args.checkInteger(2));
        for (TileAcceleratorBeamPort port : ((Accelerator)this.getMultiblock()).getPartMap(TileAcceleratorBeamPort.class).values()) {
            if (!port.getTilePos().equals((Object)pos)) continue;
            return new Object[]{true};
        }
        return new Object[]{false};
    }

    @Callback(doc="--function(x,y,z):bool Returns if beam port mode was switched")
    @Optional.Method(modid="opencomputers")
    public Object[] switchBeamPort(Context context, Arguments args) {
        if (!this.isMultiblockAssembled()) {
            return new Object[]{false};
        }
        BlockPos pos = new BlockPos(args.checkInteger(0), args.checkInteger(1), args.checkInteger(2));
        for (TileAcceleratorBeamPort port : ((Accelerator)this.getMultiblock()).getPartMap(TileAcceleratorBeamPort.class).values()) {
            if (!port.getTilePos().equals((Object)pos)) continue;
            port.setTrigger();
            ((Accelerator)port.getMultiblock()).switchIO();
            return new Object[]{true};
        }
        return new Object[]{false};
    }

    @Callback(doc="--function(x,y,z):string Returns beam port's mode. Returns invalid if invalid beam port otherwise either input, output or disabled")
    @Optional.Method(modid="opencomputers")
    public Object[] getBeamPortMode(Context context, Arguments args) {
        if (!this.isMultiblockAssembled()) {
            return new Object[]{"invalid"};
        }
        BlockPos pos = new BlockPos(args.checkInteger(0), args.checkInteger(1), args.checkInteger(2));
        for (TileAcceleratorBeamPort port : ((Accelerator)this.getMultiblock()).getPartMap(TileAcceleratorBeamPort.class).values()) {
            if (!port.getTilePos().equals((Object)pos)) continue;
            return new Object[]{port.getIOType().func_176610_l()};
        }
        return new Object[]{"invalid"};
    }

    @Callback(doc="--function(x,y,z):string Returns beam port's switch mode. Returns invalid if invalid beam port otherwise either input or output")
    @Optional.Method(modid="opencomputers")
    public Object[] getBeamPortSwitchMode(Context context, Arguments args) {
        if (!this.isMultiblockAssembled()) {
            return new Object[]{"invalid"};
        }
        BlockPos pos = new BlockPos(args.checkInteger(0), args.checkInteger(1), args.checkInteger(2));
        for (TileAcceleratorBeamPort port : ((Accelerator)this.getMultiblock()).getPartMap(TileAcceleratorBeamPort.class).values()) {
            if (!port.getTilePos().equals((Object)pos)) continue;
            return new Object[]{port.getSetting().func_176610_l()};
        }
        return new Object[]{"invalid"};
    }
}

