/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.accelerator.tile;

import ic2.api.energy.tile.IEnergyEmitter;
import javax.annotation.Nullable;
import lach_01298.qmd.accelerator.Accelerator;
import lach_01298.qmd.accelerator.tile.TileAcceleratorPart;
import nc.ModCheck;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.tile.energy.ITileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.energy.EnergyTileWrapper;
import nc.tile.internal.energy.EnergyTileWrapperGT;
import nc.util.EnergyHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

public class TileAcceleratorEnergyPort
extends TileAcceleratorPart
implements ITileEnergy {
    protected final EnergyStorage backupStorage = new EnergyStorage(1L);
    protected final EnergyConnection[] energyConnections = ITileEnergy.energyConnectionAll((EnergyConnection)EnergyConnection.IN);
    protected final EnergyTileWrapper[] energySides = ITileEnergy.getDefaultEnergySides((ITileEnergy)this);
    protected final EnergyTileWrapperGT[] energySidesGT = ITileEnergy.getDefaultEnergySidesGT((ITileEnergy)this);
    protected boolean ic2reg = false;

    public TileAcceleratorEnergyPort() {
        super(CuboidalPartPositionType.EXTERIOR);
    }

    @Override
    public void onMachineAssembled(Accelerator controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public void onLoad() {
        super.onLoad();
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    public EnergyStorage getEnergyStorage() {
        if (!this.isMultiblockAssembled()) {
            return this.backupStorage;
        }
        return ((Accelerator)this.getMultiblock()).energyStorage;
    }

    public EnergyConnection[] getEnergyConnections() {
        return this.energyConnections;
    }

    public EnergyTileWrapper[] getEnergySides() {
        return this.energySides;
    }

    public EnergyTileWrapperGT[] getEnergySidesGT() {
        return this.energySidesGT;
    }

    public boolean getIC2Reg() {
        return this.ic2reg;
    }

    public void setIC2Reg(boolean ic2reg) {
        this.ic2reg = ic2reg;
    }

    public int getSinkTier() {
        return 1;
    }

    public int getSourceTier() {
        if (!this.isMultiblockAssembled()) {
            return 1;
        }
        return EnergyHelper.getEUTier((double)((Accelerator)this.getMultiblock()).requiredEnergy);
    }

    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return super.acceptsEnergyFrom(emitter, side);
    }

    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return super.getDemandedEnergy();
    }

    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        return super.injectEnergy(directionFrom, amount, voltage);
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeEnergy(nbt);
        this.writeEnergyConnections(nbt);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readEnergy(nbt);
        this.readEnergyConnections(nbt);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.hasEnergySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.hasEnergySideCapability(side)) {
                return (T)this.getEnergySide(this.nonNullSide(side));
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }
}

