/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.block;

import java.util.Random;
import javax.annotation.Nullable;
import lach_01298.qmd.block.QMDBlocks;
import lach_01298.qmd.enums.MaterialTypes;
import lach_01298.qmd.item.QMDItems;
import nc.block.NCBlock;
import nc.block.property.BlockProperties;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockLuminousPaint
extends NCBlock {
    protected static final AxisAlignedBB[] PAINT_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.9375, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.9375, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.0625), new AxisAlignedBB(0.9375, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 0.0625, 1.0, 1.0)};

    public BlockLuminousPaint() {
        super(Material.field_151594_q);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)EnumFacing.UP));
        this.func_149715_a(0.8f);
        this.func_149711_c(0.1f);
        this.func_149752_b(0.1f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return PAINT_AABB[((EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_ALL)).func_176745_a()];
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_ALL)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockProperties.FACING_ALL});
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return QMDItems.luminousPaint;
    }

    public int func_180651_a(IBlockState state) {
        if (state.func_177230_c() == QMDBlocks.greenLuminousPaint) {
            return MaterialTypes.LuminousPaintType.GREEN.getID();
        }
        if (state.func_177230_c() == QMDBlocks.blueLuminousPaint) {
            return MaterialTypes.LuminousPaintType.BLUE.getID();
        }
        if (state.func_177230_c() == QMDBlocks.orangeLuminousPaint) {
            return MaterialTypes.LuminousPaintType.ORANGE.getID();
        }
        return 0;
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177230_c() == QMDBlocks.greenLuminousPaint) {
            return new ItemStack(QMDItems.luminousPaint, 1, MaterialTypes.LuminousPaintType.GREEN.getID());
        }
        if (state.func_177230_c() == QMDBlocks.blueLuminousPaint) {
            return new ItemStack(QMDItems.luminousPaint, 1, MaterialTypes.LuminousPaintType.BLUE.getID());
        }
        if (state.func_177230_c() == QMDBlocks.orangeLuminousPaint) {
            return new ItemStack(QMDItems.luminousPaint, 1, MaterialTypes.LuminousPaintType.ORANGE.getID());
        }
        return new ItemStack(QMDItems.luminousPaint);
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return BlockLuminousPaint.canPlaceBlock(worldIn, pos, side);
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            if (!BlockLuminousPaint.canPlaceBlock(worldIn, pos, enumfacing)) continue;
            return true;
        }
        return false;
    }

    protected static boolean canPlaceBlock(World world, BlockPos pos, EnumFacing direction) {
        BlockPos blockpos = pos.func_177972_a(direction.func_176734_d());
        IBlockState iblockstate = world.func_180495_p(blockpos);
        return iblockstate.func_193401_d((IBlockAccess)world, blockpos, direction) == BlockFaceShape.SOLID;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)facing);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (this.checkForDrop(worldIn, pos, state) && !BlockLuminousPaint.canPlaceBlock(worldIn, pos, (EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_ALL))) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
    }

    private boolean checkForDrop(World worldIn, BlockPos pos, IBlockState state) {
        if (this.func_176196_c(worldIn, pos)) {
            return true;
        }
        this.func_176226_b(worldIn, pos, state, 0);
        worldIn.func_175698_g(pos);
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }
}

