/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public interface IItemParticleAmount {
    public int getCapacity(ItemStack var1);

    default public ItemStack fill(ItemStack stack, int amount, String type) {
        if (this.getAmountStored(stack) + amount <= this.getCapacity(stack)) {
            this.setAmountStored(stack, this.getAmountStored(stack) + amount);
        }
        return stack;
    }

    default public ItemStack use(ItemStack stack, int amount) {
        if (this.getAmountStored(stack) > amount) {
            this.setAmountStored(stack, this.getAmountStored(stack) - amount);
        } else if (this.getAmountStored(stack) == amount) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static ItemStack cleanNBT(ItemStack stack) {
        ItemStack newStack = stack.func_77946_l();
        newStack.func_77982_d(null);
        return newStack;
    }

    public static ItemStack fullItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof IItemParticleAmount) {
            IItemParticleAmount item = (IItemParticleAmount)stack.func_77973_b();
            item.setAmountStored(stack, item.getCapacity(stack));
        }
        return stack;
    }

    default public int getAmountStored(ItemStack stack) {
        NBTTagCompound nbt = IItemParticleAmount.getStorageNBT(stack);
        if (nbt == null) {
            return 0;
        }
        return nbt.func_74762_e("particle_amount");
    }

    default public void setAmountStored(ItemStack stack, int amount) {
        if (stack.func_77973_b() instanceof IItemParticleAmount) {
            NBTTagCompound nbt = IItemParticleAmount.getStorageNBT(stack);
            if (nbt != null && nbt.func_74764_b("particle_amount")) {
                if (amount < this.getCapacity(stack)) {
                    nbt.func_74768_a("particle_amount", amount);
                } else {
                    nbt.func_74768_a("particle_amount", this.getCapacity(stack));
                }
            } else {
                nbt = new NBTTagCompound();
                NBTTagCompound storage = new NBTTagCompound();
                if (amount < this.getCapacity(stack)) {
                    storage.func_74768_a("particle_amount", amount);
                } else {
                    storage.func_74768_a("particle_amount", this.getCapacity(stack));
                }
                nbt.func_74782_a("particle_storage", (NBTBase)storage);
                stack.func_77982_d(nbt);
            }
        }
    }

    public static NBTTagCompound getStorageNBT(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_74764_b("particle_storage")) {
            return null;
        }
        return nbt.func_74775_l("particle_storage");
    }
}

