/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import java.util.List;
import javax.annotation.Nullable;
import lach_01298.qmd.enums.MaterialTypes;
import lach_01298.qmd.item.IItemParticleAmount;
import lach_01298.qmd.item.QMDItems;
import nc.item.NCItem;
import nc.util.InfoHelper;
import nc.util.Lang;
import nc.util.StackHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemCanister
extends NCItem
implements IItemParticleAmount {
    public ItemCanister() {
        super(new String[0]);
        this.func_77627_a(true);
        this.func_77625_d(16);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.add((Object)new ItemStack((Item)this, 1, 0));
            for (int i = 1; i < MaterialTypes.CanisterType.values().length; ++i) {
                ItemStack stack = new ItemStack((Item)this, 1, i);
                ItemCanister Canister = (ItemCanister)stack.func_77973_b();
                this.setAmountStored(stack, this.getCapacity(stack));
                items.add((Object)stack);
            }
        }
    }

    @Override
    public int getCapacity(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return MaterialTypes.CanisterType.EMPTY.getCapacity();
            }
            case 1: {
                return MaterialTypes.CanisterType.HYDROGEN.getCapacity();
            }
            case 2: {
                return MaterialTypes.CanisterType.DEUTERIUM.getCapacity();
            }
            case 3: {
                return MaterialTypes.CanisterType.TRITIUM.getCapacity();
            }
            case 4: {
                return MaterialTypes.CanisterType.HELIUM3.getCapacity();
            }
            case 5: {
                return MaterialTypes.CanisterType.HELIUM.getCapacity();
            }
            case 6: {
                return MaterialTypes.CanisterType.DIBORANE.getCapacity();
            }
        }
        return 0;
    }

    public String func_77667_c(ItemStack stack) {
        for (int i = 0; i < MaterialTypes.CanisterType.values().length; ++i) {
            if (StackHelper.getMetadata((ItemStack)stack) != i) continue;
            return this.func_77658_a() + "." + MaterialTypes.CanisterType.values()[i].func_176610_l();
        }
        return this.func_77658_a() + "." + MaterialTypes.CanisterType.values()[0].func_176610_l();
    }

    @Override
    public ItemStack fill(ItemStack stack, int amount, String type) {
        if (stack.func_77960_j() == MaterialTypes.CanisterType.EMPTY.getID()) {
            int meta = 0;
            for (MaterialTypes.CanisterType canisterType : MaterialTypes.CanisterType.values()) {
                if (!canisterType.func_176610_l().equals(type)) continue;
                meta = canisterType.getID();
            }
            ItemStack newStack = new ItemStack(QMDItems.canister, 1, meta);
            this.setAmountStored(newStack, amount);
            return newStack;
        }
        if (this.getAmountStored(stack) + amount <= this.getCapacity(stack)) {
            this.setAmountStored(stack, this.getAmountStored(stack) + amount);
        }
        return stack;
    }

    @Override
    public ItemStack use(ItemStack stack, int amount) {
        if (this.getAmountStored(stack) > amount) {
            this.setAmountStored(stack, this.getAmountStored(stack) - amount);
        } else if (this.getAmountStored(stack) == amount) {
            return new ItemStack(QMDItems.canister, 1, MaterialTypes.CanisterType.EMPTY.getID());
        }
        return stack;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - MathHelper.func_151237_a((double)((double)this.getAmountStored(stack) / (double)this.getCapacity(stack)), (double)0.0, (double)1.0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getAmountStored(stack) > 0;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        InfoHelper.infoLine(tooltip, (TextFormatting)TextFormatting.DARK_GREEN, (String)Lang.localise((String)"info.qmd.item.amount", (Object[])new Object[]{this.getAmountStored(stack), this.getCapacity(stack)}));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

