/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import ic2.api.item.IElectricItemManager;
import ic2.api.item.IHazmatLike;
import ic2.api.item.ISpecialElectricItem;
import java.awt.Color;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.config.QMDConfig;
import nc.ModCheck;
import nc.item.armor.NCItemArmor;
import nc.item.energy.ElectricItemManager;
import nc.item.energy.IChargableItem;
import nc.item.energy.ItemEnergyCapabilityProvider;
import nc.tile.internal.energy.EnergyConnection;
import nc.util.InfoHelper;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.item.IHazmatLike", modid="ic2"), @Optional.Interface(iface="ic2.api.item.ISpecialElectricItem", modid="ic2")})
public class ItemHEVSuit
extends NCItemArmor
implements ISpecialArmor,
IHazmatLike,
IChargableItem,
ISpecialElectricItem {
    public final double radiationProtection;
    private final long capacity;
    private final int maxTransfer;
    private final EnergyConnection energyConnection;
    private final int energyTier;

    public ItemHEVSuit(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn, double radiationProtection, TextFormatting infoColor, String ... tooltip) {
        super(materialIn, renderIndexIn, equipmentSlotIn, infoColor, tooltip);
        this.radiationProtection = radiationProtection;
        switch (equipmentSlotIn) {
            case FEET: {
                this.capacity = QMDConfig.hev_energy[0];
                break;
            }
            case LEGS: {
                this.capacity = QMDConfig.hev_energy[1];
                break;
            }
            case CHEST: {
                this.capacity = QMDConfig.hev_energy[2];
                break;
            }
            case HEAD: {
                this.capacity = QMDConfig.hev_energy[3];
                break;
            }
            default: {
                this.capacity = QMDConfig.hev_energy[0];
            }
        }
        this.maxTransfer = NCMath.toInt((long)this.capacity);
        this.energyConnection = EnergyConnection.BOTH;
        this.energyTier = 3;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        IEnergyStorage energy;
        if (source.field_76373_n.equals("radiation") || source.field_76373_n.equals("sulphuric_acid") || source.field_76373_n.equals("acid_burn") || source.field_76373_n.equals("corium_burn") || source.field_76373_n.equals("hot_coolant_burn")) {
            return new ISpecialArmor.ArmorProperties(0, this.radiationProtection, Integer.MAX_VALUE);
        }
        ISpecialArmor.ArmorProperties armourProp = new ISpecialArmor.ArmorProperties(0, 0.0, Integer.MAX_VALUE);
        if (armor.hasCapability(CapabilityEnergy.ENERGY, null) && (energy = (IEnergyStorage)armor.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() > 0) {
            armourProp.Toughness = QMDConfig.hev_toughness[0] - QMDConfig.hev_toughness[1];
            armourProp.Armor = QMDConfig.hev_armour[slot] - QMDConfig.hev_armour[slot + 4];
            energy.extractEnergy((int)((double)QMDConfig.hev_power[0] * damage), false);
        }
        return armourProp;
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        IEnergyStorage energy;
        if (armor.hasCapability(CapabilityEnergy.ENERGY, null) && (energy = (IEnergyStorage)armor.getCapability(CapabilityEnergy.ENERGY, null)).getEnergyStored() > 0) {
            return QMDConfig.hev_armour[slot] - QMDConfig.hev_armour[slot + 4];
        }
        return 0;
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack stack, DamageSource source, int damage, int slot) {
        Potion radiation;
        if (ModCheck.ic2Loaded() && (radiation = Potion.func_180142_b((String)"ic2:radiation")) != null && entity.func_70644_a(radiation)) {
            entity.func_184589_d(radiation);
        }
    }

    public boolean handleUnblockableDamage(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        return source.field_76373_n.equals("radiation") || source.field_76373_n.equals("sulphuric_acid") || source.field_76373_n.equals("acid_burn") || source.field_76373_n.equals("corium_burn") || source.field_76373_n.equals("hot_coolant_burn");
    }

    @Optional.Method(modid="ic2")
    public boolean addsProtection(EntityLivingBase entity, EntityEquipmentSlot slot, ItemStack stack) {
        return true;
    }

    @Optional.Method(modid="ic2")
    public IElectricItemManager getManager(ItemStack itemStack) {
        return ElectricItemManager.getElectricItemManager((IChargableItem)this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        InfoHelper.infoLine(tooltip, (TextFormatting)TextFormatting.LIGHT_PURPLE, (String)("Energy Stored: " + UnitHelper.prefix((long)this.getEnergyStored(stack), (long)this.getMaxEnergyStored(stack), (int)5, (String)"RF")));
        InfoHelper.infoLine(tooltip, (TextFormatting)TextFormatting.WHITE, (String)("EU Power Tier: " + this.getEnergyTier(stack)));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT((ItemStack)stack);
        if (nbt == null || !nbt.func_74764_b("energy")) {
            return false;
        }
        return nbt.func_74763_f("energy") > 0L;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - MathHelper.func_151237_a((double)((double)this.getEnergyStored(stack) / (double)this.capacity), (double)0.0, (double)1.0);
    }

    public long getMaxEnergyStored(ItemStack stack) {
        return this.capacity;
    }

    public int getMaxTransfer(ItemStack stack) {
        return this.maxTransfer;
    }

    public boolean canReceive(ItemStack stack) {
        return this.energyConnection.canReceive();
    }

    public boolean canExtract(ItemStack stack) {
        return this.energyConnection.canExtract();
    }

    public EnergyConnection getEnergyConnection(ItemStack stack) {
        return this.energyConnection;
    }

    public int getEnergyTier(ItemStack stack) {
        return this.energyTier;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new ItemEnergyCapabilityProvider(stack, this.capacity, this.maxTransfer, this.getEnergyStored(stack), this.energyConnection, this.energyTier);
    }

    public boolean func_82816_b_(ItemStack stack) {
        return true;
    }

    public int func_82814_b(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")) != null && nbttagcompound1.func_150297_b("color", 3)) {
            return nbttagcompound1.func_74762_e("color");
        }
        return Color.decode("0xFF8B2E").getRGB();
    }

    public void func_82815_c(ItemStack stack) {
        NBTTagCompound nbttagcompound1;
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && (nbttagcompound1 = nbttagcompound.func_74775_l("display")).func_74764_b("color")) {
            nbttagcompound1.func_82580_o("color");
        }
    }

    public void func_82813_b(ItemStack stack, int color) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound == null) {
            nbttagcompound = new NBTTagCompound();
            stack.func_77982_d(nbttagcompound);
        }
        NBTTagCompound nbttagcompound1 = nbttagcompound.func_74775_l("display");
        if (!nbttagcompound.func_150297_b("display", 10)) {
            nbttagcompound.func_74782_a("display", (NBTBase)nbttagcompound1);
        }
        nbttagcompound1.func_74768_a("color", color);
    }

    public boolean hasOverlay(ItemStack stack) {
        return true;
    }
}

