/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.item;

import java.util.List;
import javax.annotation.Nullable;
import lach_01298.qmd.enums.MaterialTypes;
import lach_01298.qmd.item.IItemParticleAmount;
import nc.item.NCItem;
import nc.util.InfoHelper;
import nc.util.Lang;
import nc.util.StackHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemSource
extends NCItem
implements IItemParticleAmount {
    public ItemSource() {
        super(new String[0]);
        this.func_77627_a(true);
        this.func_77625_d(16);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < MaterialTypes.SourceType.values().length; ++i) {
                ItemStack stack = new ItemStack((Item)this, 1, i);
                ItemSource cell = (ItemSource)stack.func_77973_b();
                this.setAmountStored(stack, this.getCapacity(stack));
                items.add((Object)stack);
            }
        }
    }

    @Override
    public int getCapacity(ItemStack stack) {
        switch (stack.func_77960_j()) {
            case 0: {
                return MaterialTypes.SourceType.TUNGSTEN_FILAMENT.getCapacity();
            }
            case 1: {
                return MaterialTypes.SourceType.SODIUM_22.getCapacity();
            }
            case 2: {
                return MaterialTypes.SourceType.COBALT_60.getCapacity();
            }
            case 3: {
                return MaterialTypes.SourceType.IRIDIUM_192.getCapacity();
            }
            case 4: {
                return MaterialTypes.SourceType.CALCIUM_48.getCapacity();
            }
        }
        return 0;
    }

    public String func_77667_c(ItemStack stack) {
        for (int i = 0; i < MaterialTypes.SourceType.values().length; ++i) {
            if (StackHelper.getMetadata((ItemStack)stack) != i) continue;
            return this.func_77658_a() + "." + MaterialTypes.SourceType.values()[i].func_176610_l();
        }
        return this.func_77658_a() + "." + MaterialTypes.SourceType.values()[0].func_176610_l();
    }

    @Override
    public ItemStack fill(ItemStack stack, int amount, String type) {
        if (this.getAmountStored(stack) + amount <= this.getCapacity(stack)) {
            this.setAmountStored(stack, this.getAmountStored(stack) + amount);
        }
        return stack;
    }

    @Override
    public ItemStack use(ItemStack stack, int amount) {
        if (this.getAmountStored(stack) > amount) {
            this.setAmountStored(stack, this.getAmountStored(stack) - amount);
        } else if (this.getAmountStored(stack) == amount) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - MathHelper.func_151237_a((double)((double)this.getAmountStored(stack) / (double)this.getCapacity(stack)), (double)0.0, (double)1.0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getAmountStored(stack) > 0;
    }

    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        InfoHelper.infoLine(tooltip, (TextFormatting)TextFormatting.DARK_GREEN, (String)Lang.localise((String)"info.qmd.item.amount", (Object[])new Object[]{this.getAmountStored(stack), this.getCapacity(stack)}));
        super.func_77624_a(stack, world, tooltip, flag);
    }
}

