/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.jei.category;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import nc.integration.jei.JEIBasicCategory;
import nc.integration.jei.JEIBasicRecipeWrapper;
import nc.integration.jei.NCJEI;
import nc.recipe.ingredient.ChanceFluidIngredient;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.util.Lang;
import nc.util.NCMath;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public abstract class JEIQMDMachineCategory<WRAPPER extends JEIBasicRecipeWrapper>
extends JEIBasicCategory<WRAPPER> {
    private final IDrawable background;
    protected String recipeTitle;
    protected final int backPosX;
    protected final int backPosY;

    public JEIQMDMachineCategory(IGuiHelper guiHelper, NCJEI.IJEIHandler handler, String title, int backX, int backY, int backWidth, int backHeight) {
        this(guiHelper, handler, title, "", backX, backY, backWidth, backHeight);
    }

    public JEIQMDMachineCategory(IGuiHelper guiHelper, NCJEI.IJEIHandler handler, String title, String guiExtra, int backX, int backY, int backWidth, int backHeight) {
        super(handler);
        ResourceLocation location = new ResourceLocation("qmd:textures/gui/" + handler.getTextureName() + guiExtra + ".png");
        this.background = guiHelper.createDrawable(location, backX, backY, backWidth, backHeight);
        this.recipeTitle = Lang.localise((String)("tile.qmd." + title + ".name"));
        this.backPosX = backX + 1;
        this.backPosY = backY + 1;
    }

    public void drawExtras(Minecraft minecraft) {
    }

    public String getModName() {
        return "Quantum Minecraft Dynamics";
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayout recipeLayout, WRAPPER recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            int outputIndex = slotIndex - recipeWrapper.recipeHandler.getItemInputSize();
            if (outputIndex >= 0 && outputIndex <= recipeWrapper.recipeHandler.getItemOutputSize() && recipeWrapper.recipe.getItemProducts().get(outputIndex) instanceof ChanceItemIngredient) {
                ChanceItemIngredient chanceIngredient = (ChanceItemIngredient)recipeWrapper.recipe.getItemProducts().get(outputIndex);
                tooltip.add(TextFormatting.WHITE + Lang.localise((String)"jei.nuclearcraft.chance_output", (Object[])new Object[]{chanceIngredient.minStackSize, chanceIngredient.getMaxStackSize(0), NCMath.decimalPlaces((double)chanceIngredient.meanStackSize, (int)2)}));
            }
        });
        recipeLayout.getFluidStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            int outputIndex = slotIndex - recipeWrapper.recipeHandler.getFluidInputSize();
            if (outputIndex >= 0 && outputIndex <= recipeWrapper.recipeHandler.getFluidOutputSize() && recipeWrapper.recipe.getFluidProducts().get(outputIndex) instanceof ChanceFluidIngredient) {
                ChanceFluidIngredient chanceIngredient = (ChanceFluidIngredient)recipeWrapper.recipe.getFluidProducts().get(outputIndex);
                tooltip.add(TextFormatting.WHITE + Lang.localise((String)"jei.nuclearcraft.chance_output", (Object[])new Object[]{chanceIngredient.minStackSize, chanceIngredient.getMaxStackSize(0), NCMath.decimalPlaces((double)chanceIngredient.meanStackSize, (int)2)}));
            }
        });
    }

    public String getTitle() {
        return this.recipeTitle;
    }
}

