/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.jei.recipe;

import java.awt.Color;
import java.util.List;
import lach_01298.qmd.jei.ingredient.ParticleType;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.util.Units;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import nc.util.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.fluids.FluidStack;

public class NucleosynthesisChamberRecipe
implements IRecipeWrapper {
    private final List<List<ParticleStack>> inputParticle;
    private final List<List<FluidStack>> inputFluids;
    private final List<List<FluidStack>> outputFluids;
    private final long heatReleased;
    private final long maxEnergy;

    public NucleosynthesisChamberRecipe(List<List<ParticleStack>> inputParticle, List<List<FluidStack>> inputFluids, List<List<FluidStack>> outputFluids, long heat, long maxEnergy) {
        this.inputParticle = inputParticle;
        this.inputFluids = inputFluids;
        this.outputFluids = outputFluids;
        this.heatReleased = heat;
        this.maxEnergy = maxEnergy;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ParticleType.Particle, this.inputParticle);
        ingredients.setInputLists(VanillaTypes.FLUID, this.inputFluids);
        ingredients.setOutputLists(VanillaTypes.FLUID, this.outputFluids);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FontRenderer fontRenderer = minecraft.field_71466_p;
        String heatString = Lang.localise((String)"gui.qmd.jei.reaction.heat_released", (Object[])new Object[]{Units.getSIFormat(this.heatReleased, 0, "H")});
        fontRenderer.func_78276_b(heatString, 0, 47, Color.gray.getRGB());
        if (this.maxEnergy != Long.MAX_VALUE) {
            String rangeString = Lang.localise((String)"gui.qmd.jei.reaction.range", (Object[])new Object[]{Units.getParticleEnergy(this.inputParticle.get(0).get(0).getMeanEnergy()) + "-" + Units.getParticleEnergy(this.maxEnergy)});
            fontRenderer.func_78276_b(rangeString, 0, 57, Color.gray.getRGB());
        }
    }
}

