/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.jei.recipe;

import java.awt.Color;
import java.text.DecimalFormat;
import java.util.List;
import lach_01298.qmd.jei.ingredient.ParticleType;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.util.Units;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import nc.util.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;

public class TargetChamberRecipe
implements IRecipeWrapper {
    private final List<List<ItemStack>> inputItems;
    private final List<List<ItemStack>> outputItems;
    private final List<List<ParticleStack>> inputParticles;
    private final List<List<ParticleStack>> outputParticles;
    private final long maxEnergy;
    private final double crossSection;
    private final long energyReleased;

    public TargetChamberRecipe(List<List<ItemStack>> inputItems, List<List<ParticleStack>> inputParticles, List<List<ItemStack>> outputItems, List<List<ParticleStack>> outputParticles, long maxEnergy, double crossSection, long energyReleased) {
        this.inputItems = inputItems;
        this.outputItems = outputItems;
        this.inputParticles = inputParticles;
        this.outputParticles = outputParticles;
        this.maxEnergy = maxEnergy;
        this.crossSection = crossSection;
        this.energyReleased = energyReleased;
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputItems);
        ingredients.setInputLists(ParticleType.Particle, this.inputParticles);
        ingredients.setOutputLists(VanillaTypes.ITEM, this.outputItems);
        ingredients.setOutputLists(ParticleType.Particle, this.outputParticles);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        FontRenderer fontRenderer = minecraft.field_71466_p;
        String rangeString = Lang.localise((String)"gui.qmd.jei.reaction.range", (Object[])new Object[]{Units.getSIFormat(this.inputParticles.get(0).get(0).getMeanEnergy(), 3, "eV") + "-" + Units.getSIFormat(this.maxEnergy, 3, "eV")});
        DecimalFormat df = new DecimalFormat("#.##");
        String crossSectionString = Lang.localise((String)"gui.qmd.jei.reaction.cross_section", (Object[])new Object[]{df.format(this.crossSection * 100.0)});
        String energyReleasedString = Lang.localise((String)"gui.qmd.jei.reaction.energy_released", (Object[])new Object[]{Units.getParticleEnergy(this.energyReleased)});
        fontRenderer.func_78276_b(rangeString, 0, 70, Color.gray.getRGB());
        fontRenderer.func_78276_b(crossSectionString, 0, 80, Color.gray.getRGB());
        fontRenderer.func_78276_b(energyReleasedString, 0, 90, Color.gray.getRGB());
    }
}

