/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.machine.gui;

import java.io.IOException;
import lach_01298.qmd.machine.container.ContainerIrradiator;
import lach_01298.qmd.machine.gui.GuiItemAmountFuelMachine;
import lach_01298.qmd.machine.network.QMDOpenSideConfigGuiPacket;
import lach_01298.qmd.machine.network.QMDOpenTileGuiPacket;
import lach_01298.qmd.machine.tile.TileItemAmountFuelProcessor;
import lach_01298.qmd.network.QMDPacketHandler;
import nc.container.ContainerTile;
import nc.container.processor.ContainerMachineConfig;
import nc.gui.NCGui;
import nc.gui.element.NCButton;
import nc.gui.element.NCToggleButton;
import nc.gui.processor.GuiItemSorptions;
import nc.network.PacketHandler;
import nc.network.gui.ToggleRedstoneControlPacket;
import nc.tile.ITile;
import nc.tile.ITileGui;
import nc.tile.inventory.ITileInventory;
import nc.util.Lang;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiIrradiator
extends GuiItemAmountFuelMachine {
    public GuiIrradiator(EntityPlayer player, TileItemAmountFuelProcessor tile) {
        this(player, tile, new ContainerIrradiator(player, tile));
    }

    private GuiIrradiator(EntityPlayer player, TileItemAmountFuelProcessor tile, ContainerTile container) {
        super("irradiator", player, tile, (Container)container);
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public void renderTooltips(int mouseX, int mouseY) {
        this.renderButtonTooltips(mouseX, mouseY);
    }

    public void renderButtonTooltips(int mouseX, int mouseY) {
        this.drawTooltip(Lang.localise((String)"gui.nc.container.machine_side_config"), mouseX, mouseY, 6, 40, 18, 18);
        this.drawTooltip(Lang.localise((String)"gui.nc.container.redstone_control"), mouseX, mouseY, 6, 60, 18, 18);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.func_73729_b(this.field_147003_i + 62, this.field_147009_r + 57, 176, 0, this.getCookProgressScaled(52.0), 10);
        int rays = (int)Math.round((double)this.tile.tick / 20.0 * 19.0);
        this.func_73729_b(this.field_147003_i + 68, this.field_147009_r + 38, 176, 10, 40, rays);
        this.drawBackgroundExtras();
    }

    protected void drawBackgroundExtras() {
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.initButtons();
    }

    public void initButtons() {
        this.field_146292_n.add(new NCButton.MachineConfig(0, this.field_147003_i + 6, this.field_147009_r + 40));
        this.field_146292_n.add(new NCToggleButton.RedstoneControl(1, this.field_147003_i + 6, this.field_147009_r + 60, (ITile)this.tile));
    }

    @Override
    protected void func_146284_a(GuiButton guiButton) {
        if (this.tile.func_145831_w().field_72995_K) {
            if (guiButton.field_146127_k == 0) {
                QMDPacketHandler.instance.sendToServer((IMessage)new QMDOpenSideConfigGuiPacket(this.tile));
            } else if (guiButton.field_146127_k == 1) {
                this.tile.setRedstoneControl(!this.tile.getRedstoneControl());
                PacketHandler.instance.sendToServer((IMessage)new ToggleRedstoneControlPacket((ITile)this.tile));
            }
        }
    }

    public static class SideConfig
    extends GuiIrradiator {
        public SideConfig(EntityPlayer player, TileItemAmountFuelProcessor tile) {
            super(player, tile, (ContainerTile)new ContainerMachineConfig(player, (ITileGui)tile));
        }

        protected void func_73869_a(char typedChar, int keyCode) throws IOException {
            if (this.isEscapeKeyDown(keyCode)) {
                QMDPacketHandler.instance.sendToServer((IMessage)new QMDOpenTileGuiPacket(this.tile));
            } else {
                super.func_73869_a(typedChar, keyCode);
            }
        }

        @Override
        public void renderButtonTooltips(int mouseX, int mouseY) {
            this.drawTooltip(TextFormatting.BLUE + Lang.localise((String)"gui.nc.container.input_item_config"), mouseX, mouseY, 44, 54, 18, 18);
            this.drawTooltip(TextFormatting.BLUE + Lang.localise((String)"gui.nc.container.input_item_config"), mouseX, mouseY, 80, 21, 18, 18);
            this.drawTooltip(TextFormatting.GOLD + Lang.localise((String)"gui.nc.container.output_item_config"), mouseX, mouseY, 116, 54, 18, 18);
        }

        @Override
        protected void drawBackgroundExtras() {
        }

        @Override
        public void initButtons() {
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemInput(0, this.field_147003_i + 43, this.field_147009_r + 53));
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemInput(1, this.field_147003_i + 79, this.field_147009_r + 20));
            this.field_146292_n.add(new NCButton.SorptionConfig.ItemOutputSmall(2, this.field_147003_i + 115, this.field_147009_r + 53));
        }

        @Override
        protected void func_146284_a(GuiButton guiButton) {
            if (this.tile.func_145831_w().field_72995_K) {
                switch (guiButton.field_146127_k) {
                    case 0: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiItemSorptions.Input((NCGui)this, (ITileInventory)this.tile, 0));
                        return;
                    }
                    case 1: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiItemSorptions.Input((NCGui)this, (ITileInventory)this.tile, 1));
                        return;
                    }
                    case 2: {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiItemSorptions.Output((NCGui)this, (ITileInventory)this.tile, 2));
                        return;
                    }
                }
            }
        }
    }
}

