/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.machine.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import lach_01298.qmd.particle.ParticleStorageSource;
import lach_01298.qmd.util.ByteUtil;
import nc.network.tile.TileUpdatePacket;
import nc.tile.ITileGui;
import net.minecraft.util.math.BlockPos;

public class CreativeParticleSourceUpdatePacket
extends TileUpdatePacket {
    public List<ParticleStorageSource> beams;

    public CreativeParticleSourceUpdatePacket() {
        this.beams = new ArrayList<ParticleStorageSource>();
    }

    public CreativeParticleSourceUpdatePacket(BlockPos pos, List<ParticleStorageSource> tanks) {
        this.pos = pos;
        this.beams = tanks;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.beams.add((ParticleStorageSource)ByteUtil.readBufBeam(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.beams.size());
        for (ParticleStorageSource beam : this.beams) {
            ByteUtil.writeBufBeam(beam, buf);
        }
    }

    public static class Handler
    extends TileUpdatePacket.Handler<CreativeParticleSourceUpdatePacket, ITileGui> {
        protected void onPacket(CreativeParticleSourceUpdatePacket message, ITileGui processor) {
            processor.onGuiPacket((TileUpdatePacket)message);
        }
    }
}

