/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.multiblock;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.multiblock.CuboidalOrToroidalMultiblock;
import nc.multiblock.BlockFacing;
import nc.multiblock.Multiblock;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.cuboidal.PartPosition;
import nc.multiblock.tile.TileMultiblockPart;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class TileCuboidalOrToroidalMultiblockPart<MULTIBLOCK extends CuboidalOrToroidalMultiblock>
extends TileMultiblockPart<MULTIBLOCK> {
    private BlockPos miniumInCoord;
    private BlockPos maximumInCoord;
    private int toroidThickness;
    private final CuboidalPartPositionType positionType;
    private PartPosition position;
    private BlockFacing externalFacings;

    public TileCuboidalOrToroidalMultiblockPart(Class<MULTIBLOCK> tClass, CuboidalPartPositionType positionType, int toroidThickness) {
        super(tClass);
        this.positionType = positionType;
        this.position = PartPosition.Unknown;
        this.externalFacings = BlockFacing.NONE;
        this.toroidThickness = toroidThickness;
    }

    public CuboidalPartPositionType getPartPositionType() {
        return this.positionType;
    }

    @Nonnull
    public BlockFacing getExternalDir() {
        return this.externalFacings;
    }

    @Nonnull
    public PartPosition getPartPosition() {
        return this.position;
    }

    @Nullable
    public EnumFacing getExternalFacing() {
        BlockFacing out;
        EnumFacing facing;
        EnumFacing enumFacing = facing = null != this.position ? this.position.getFacing() : null;
        if (null == facing && !(out = this.getExternalDir()).none() && 1 == out.countFacesIf(true)) {
            facing = out.firstIf(true);
        }
        return facing;
    }

    @Nullable
    public EnumFacing getExternalFacingFromWorldPosition() {
        BlockFacing facings = null;
        CuboidalOrToroidalMultiblock multiblock = (CuboidalOrToroidalMultiblock)this.getMultiblock();
        if (null != multiblock) {
            BlockPos position = this.field_174879_c;
            BlockPos min = multiblock.getMinimumCoord();
            BlockPos max = multiblock.getMaximumCoord();
            int x = position.func_177958_n();
            int y = position.func_177956_o();
            int z = position.func_177952_p();
            facings = BlockFacing.from((min.func_177956_o() == y ? 1 : 0) != 0, (max.func_177956_o() == y ? 1 : 0) != 0, (min.func_177952_p() == z || z == this.maximumInCoord.func_177952_p() && x > this.miniumInCoord.func_177958_n() && x < this.maximumInCoord.func_177958_n() ? 1 : 0) != 0, (max.func_177952_p() == z || z == this.miniumInCoord.func_177952_p() && x > this.miniumInCoord.func_177958_n() && x < this.maximumInCoord.func_177958_n() ? 1 : 0) != 0, (min.func_177958_n() == x || x == this.maximumInCoord.func_177958_n() && z > this.miniumInCoord.func_177952_p() && z < this.maximumInCoord.func_177952_p() ? 1 : 0) != 0, (max.func_177958_n() == x || x == this.miniumInCoord.func_177958_n() && z > this.miniumInCoord.func_177952_p() && z < this.maximumInCoord.func_177952_p() ? 1 : 0) != 0);
        }
        return null != facings && !facings.none() && 1 == facings.countFacesIf(true) ? facings.firstIf(true) : null;
    }

    public void onAttached(MULTIBLOCK newMultiblock) {
        super.onAttached(newMultiblock);
        this.recalculateExternalDirection(newMultiblock.getMinimumCoord(), newMultiblock.getMaximumCoord());
    }

    public void onMachineAssembled(MULTIBLOCK multiblock) {
        this.recalculateExternalDirection(multiblock.getMinimumCoord(), multiblock.getMaximumCoord());
    }

    public void onMachineBroken() {
        this.position = PartPosition.Unknown;
        this.externalFacings = BlockFacing.NONE;
    }

    public void recalculateExternalDirection(BlockPos minCoord, BlockPos maxCoord) {
        BlockPos myPosition = this.func_174877_v();
        BlockPos minInCoord = new BlockPos(minCoord.func_177958_n() + this.toroidThickness - 1, minCoord.func_177956_o(), minCoord.func_177952_p() + this.toroidThickness - 1);
        BlockPos maxInCoord = new BlockPos(maxCoord.func_177958_n() - this.toroidThickness + 1, maxCoord.func_177956_o(), maxCoord.func_177952_p() - this.toroidThickness + 1);
        int myX = myPosition.func_177958_n();
        int myY = myPosition.func_177956_o();
        int myZ = myPosition.func_177952_p();
        int facesMatching = 0;
        boolean downFacing = myY == minCoord.func_177956_o();
        boolean upFacing = myY == maxCoord.func_177956_o();
        boolean northFacing = myZ == minCoord.func_177952_p() || myZ == maxInCoord.func_177952_p() && myX > minInCoord.func_177958_n() && myX < maxInCoord.func_177958_n();
        boolean southFacing = myZ == maxCoord.func_177952_p() || myZ == minInCoord.func_177952_p() && myX > minInCoord.func_177958_n() && myX < maxInCoord.func_177958_n();
        boolean westFacing = myX == minCoord.func_177958_n() || myX == maxInCoord.func_177958_n() && myZ > minInCoord.func_177952_p() && myZ < maxInCoord.func_177952_p();
        boolean eastFacing = myX == maxCoord.func_177958_n() || myX == minInCoord.func_177958_n() && myZ > minInCoord.func_177952_p() && myZ < maxInCoord.func_177952_p();
        this.externalFacings = BlockFacing.from((boolean)downFacing, (boolean)upFacing, (boolean)northFacing, (boolean)southFacing, (boolean)westFacing, (boolean)eastFacing);
        if (eastFacing || westFacing) {
            ++facesMatching;
        }
        if (upFacing || downFacing) {
            ++facesMatching;
        }
        if (southFacing || northFacing) {
            ++facesMatching;
        }
        this.position = facesMatching <= 0 ? PartPosition.Interior : (facesMatching >= 3 ? PartPosition.FrameCorner : (facesMatching == 2 ? (!eastFacing && !westFacing ? PartPosition.FrameEastWest : (!southFacing && !northFacing ? PartPosition.FrameSouthNorth : PartPosition.FrameUpDown)) : (eastFacing ? PartPosition.EastFace : (westFacing ? PartPosition.WestFace : (southFacing ? PartPosition.SouthFace : (northFacing ? PartPosition.NorthFace : (upFacing ? PartPosition.TopFace : PartPosition.BottomFace)))))));
    }

    public boolean isGoodForFrame(Multiblock multiblock) {
        if (this.positionType.isGoodForFrame()) {
            return true;
        }
        this.setStandardLastError(multiblock);
        return false;
    }

    public boolean isGoodForSides(Multiblock multiblock) {
        if (this.positionType.isGoodForWall()) {
            return true;
        }
        this.setStandardLastError(multiblock);
        return false;
    }

    public boolean isGoodForTop(Multiblock multiblock) {
        if (this.positionType.isGoodForWall()) {
            return true;
        }
        this.setStandardLastError(multiblock);
        return false;
    }

    public boolean isGoodForBottom(Multiblock multiblock) {
        if (this.positionType.isGoodForWall()) {
            return true;
        }
        this.setStandardLastError(multiblock);
        return false;
    }

    public boolean isGoodForInterior(Multiblock multiblock) {
        if (this.positionType.isGoodForInterior()) {
            return true;
        }
        this.setStandardLastError(multiblock);
        return false;
    }
}

