/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particle;

import java.util.HashMap;
import java.util.Map;
import lach_01298.qmd.particle.Particle;
import lach_01298.qmd.util.Util;
import net.minecraft.util.ResourceLocation;

public class Particles {
    public static final Map<String, Particle> list = new HashMap<String, Particle>();
    private static ResourceLocation particlePath = new ResourceLocation("qmd", "textures/particles/");
    public static Particle up;
    public static Particle down;
    public static Particle charm;
    public static Particle strange;
    public static Particle top;
    public static Particle bottom;
    public static Particle antiup;
    public static Particle antidown;
    public static Particle anticharm;
    public static Particle antistrange;
    public static Particle antitop;
    public static Particle antibottom;
    public static Particle electron;
    public static Particle electron_neutrino;
    public static Particle muon;
    public static Particle muon_neutrino;
    public static Particle tau;
    public static Particle tau_neutrino;
    public static Particle positron;
    public static Particle electron_antineutrino;
    public static Particle antimuon;
    public static Particle muon_antineutrino;
    public static Particle antitau;
    public static Particle tau_antineutrino;
    public static Particle photon;
    public static Particle gluon;
    public static Particle w_plus_boson;
    public static Particle w_minus_boson;
    public static Particle z_boson;
    public static Particle higgs_boson;
    public static Particle proton;
    public static Particle antiproton;
    public static Particle neutron;
    public static Particle antineutron;
    public static Particle deuteron;
    public static Particle antideuteron;
    public static Particle alpha;
    public static Particle antialpha;
    public static Particle triton;
    public static Particle antitriton;
    public static Particle helion;
    public static Particle antihelion;
    public static Particle boron_ion;
    public static Particle calcium_48_ion;
    public static Particle pion_plus;
    public static Particle pion_naught;
    public static Particle pion_minus;
    public static Particle kaon_plus;
    public static Particle kaon_naught;
    public static Particle antikaon_naught;
    public static Particle kaon_minus;
    public static Particle eta;
    public static Particle eta_prime;
    public static Particle charmed_eta;
    public static Particle bottom_eta;
    public static Particle sigma_plus;
    public static Particle antisigma_plus;
    public static Particle sigma_minus;
    public static Particle antisigma_minus;
    public static Particle delta_plus_plus;
    public static Particle antidelta_plus_plus;
    public static Particle delta_minus;
    public static Particle antidelta_minus;
    public static Particle glueball;

    public static void registerParticle(Particle particle) {
        if (!list.containsKey(particle.getName())) {
            list.put(particle.getName(), particle);
        } else {
            Util.getLogger().error("tried registering paticle " + particle.getName() + " but " + particle.getName() + " already exists");
        }
    }

    public static Particle getParticleFromName(String name) {
        if (name != null) {
            if (!list.containsKey(name)) {
                Util.getLogger().error("there is no particle with name " + name);
                return null;
            }
            return list.get(name);
        }
        return null;
    }

    public static void init() {
        up = new Particle("up_quark", Util.appendPath(particlePath, "up_quark.png"), 2.2, 0.6666666666666666, 0.5, true, true);
        down = new Particle("down_quark", Util.appendPath(particlePath, "down_quark.png"), 4.7, -0.3333333333333333, 0.5, true, true);
        charm = new Particle("charm_quark", Util.appendPath(particlePath, "charm_quark.png"), 1280.0, 0.6666666666666666, 0.5, true, true);
        strange = new Particle("strange_quark", Util.appendPath(particlePath, "strange_quark.png"), 95.0, -0.3333333333333333, 0.5, true, true);
        top = new Particle("top_quark", Util.appendPath(particlePath, "top_quark.png"), 173000.0, 0.6666666666666666, 0.5, true, true);
        bottom = new Particle("bottom_quark", Util.appendPath(particlePath, "bottom_quark.png"), 4180.0, -0.3333333333333333, 0.5, true, true);
        antiup = Particles.makeAntiParticle(up, "antiup_quark", Util.appendPath(particlePath, "antiup_quark.png"));
        antidown = Particles.makeAntiParticle(down, "antidown_quark", Util.appendPath(particlePath, "antidown_quark.png"));
        anticharm = Particles.makeAntiParticle(charm, "anticharm_quark", Util.appendPath(particlePath, "anticharm_quark.png"));
        antistrange = Particles.makeAntiParticle(strange, "antistrange_quark", Util.appendPath(particlePath, "antistrange_quark.png"));
        antitop = Particles.makeAntiParticle(top, "antitop_quark", Util.appendPath(particlePath, "antitop_quark.png"));
        antibottom = Particles.makeAntiParticle(bottom, "antibottom_quark", Util.appendPath(particlePath, "antibottom_quark.png"));
        electron = new Particle("electron", Util.appendPath(particlePath, "electron.png"), 0.511, -1.0, 0.5, true);
        muon = new Particle("muon", Util.appendPath(particlePath, "muon.png"), 106.0, -1.0, 0.5, true);
        tau = new Particle("tau", Util.appendPath(particlePath, "tau.png"), 1780.0, -1.0, 0.5, true);
        electron_neutrino = new Particle("electron_neutrino", Util.appendPath(particlePath, "electron_neutrino.png"), 1.2E-7, 0.0, 0.5, true);
        muon_neutrino = new Particle("muon_neutrino", Util.appendPath(particlePath, "muon_neutrino.png"), 1.2E-7, 0.0, 0.5, true);
        tau_neutrino = new Particle("tau_neutrino", Util.appendPath(particlePath, "tau_neutrino.png"), 1.2E-7, 0.0, 0.5, true);
        positron = Particles.makeAntiParticle(electron, "positron", Util.appendPath(particlePath, "positron.png"));
        antimuon = Particles.makeAntiParticle(muon, "antimuon", Util.appendPath(particlePath, "antimuon.png"));
        antitau = Particles.makeAntiParticle(tau, "antitau", Util.appendPath(particlePath, "antitau.png"));
        electron_antineutrino = Particles.makeAntiParticle(electron_neutrino, "electron_antineutrino", Util.appendPath(particlePath, "electron_antineutrino.png"));
        muon_antineutrino = Particles.makeAntiParticle(muon_neutrino, "muon_antineutrino", Util.appendPath(particlePath, "muon_antineutrino.png"));
        tau_antineutrino = Particles.makeAntiParticle(tau_neutrino, "tau_antineutrino", Util.appendPath(particlePath, "tau_antineutrino.png"));
        photon = new Particle("photon", Util.appendPath(particlePath, "photon.png"), 0.0, 0.0, 1.0, false, false);
        gluon = new Particle("gluon", Util.appendPath(particlePath, "gluon.png"), 0.0, 0.0, 1.0, false, true);
        w_plus_boson = new Particle("w_plus_boson", Util.appendPath(particlePath, "w_plus_boson.png"), 80400.0, 1.0, 1.0, true, false);
        w_minus_boson = new Particle("w_minus_boson", Util.appendPath(particlePath, "w_minus_boson.png"), 80400.0, -1.0, 1.0, true, false);
        z_boson = new Particle("z_boson", Util.appendPath(particlePath, "z_boson.png"), 91200.0, 0.0, 1.0, false, false);
        higgs_boson = new Particle("higgs_boson", Util.appendPath(particlePath, "higgs_boson.png"), 125000.0, 0.0, 0.0, true, false);
        up.setAntiParticle(antiup);
        down.setAntiParticle(antidown);
        charm.setAntiParticle(anticharm);
        strange.setAntiParticle(antistrange);
        top.setAntiParticle(antitop);
        bottom.setAntiParticle(antibottom);
        electron.setAntiParticle(positron);
        electron_neutrino.setAntiParticle(electron_antineutrino);
        muon.setAntiParticle(antimuon);
        muon_neutrino.setAntiParticle(muon_antineutrino);
        tau.setAntiParticle(antitau);
        tau_neutrino.setAntiParticle(tau_antineutrino);
        w_plus_boson.setAntiParticle(w_minus_boson);
        Particles.initComposites();
    }

    public static void register() {
        Particles.registerParticle(up);
        Particles.registerParticle(antiup);
        Particles.registerParticle(down);
        Particles.registerParticle(antidown);
        Particles.registerParticle(charm);
        Particles.registerParticle(anticharm);
        Particles.registerParticle(strange);
        Particles.registerParticle(antistrange);
        Particles.registerParticle(top);
        Particles.registerParticle(antitop);
        Particles.registerParticle(bottom);
        Particles.registerParticle(antibottom);
        Particles.registerParticle(electron);
        Particles.registerParticle(positron);
        Particles.registerParticle(electron_neutrino);
        Particles.registerParticle(electron_antineutrino);
        Particles.registerParticle(muon);
        Particles.registerParticle(antimuon);
        Particles.registerParticle(muon_neutrino);
        Particles.registerParticle(muon_antineutrino);
        Particles.registerParticle(tau);
        Particles.registerParticle(antitau);
        Particles.registerParticle(tau_neutrino);
        Particles.registerParticle(tau_antineutrino);
        Particles.registerParticle(photon);
        Particles.registerParticle(gluon);
        Particles.registerParticle(w_plus_boson);
        Particles.registerParticle(w_minus_boson);
        Particles.registerParticle(z_boson);
        Particles.registerParticle(higgs_boson);
        Particles.registerParticle(proton);
        Particles.registerParticle(antiproton);
        Particles.registerParticle(neutron);
        Particles.registerParticle(antineutron);
        Particles.registerParticle(deuteron);
        Particles.registerParticle(antideuteron);
        Particles.registerParticle(alpha);
        Particles.registerParticle(antialpha);
        Particles.registerParticle(triton);
        Particles.registerParticle(antitriton);
        Particles.registerParticle(helion);
        Particles.registerParticle(antihelion);
        Particles.registerParticle(boron_ion);
        Particles.registerParticle(calcium_48_ion);
        Particles.registerParticle(pion_plus);
        Particles.registerParticle(pion_naught);
        Particles.registerParticle(pion_minus);
        Particles.registerParticle(kaon_plus);
        Particles.registerParticle(kaon_naught);
        Particles.registerParticle(antikaon_naught);
        Particles.registerParticle(kaon_minus);
        Particles.registerParticle(eta);
        Particles.registerParticle(eta_prime);
        Particles.registerParticle(charmed_eta);
        Particles.registerParticle(bottom_eta);
        Particles.registerParticle(glueball);
        Particles.registerParticle(sigma_plus);
        Particles.registerParticle(antisigma_plus);
        Particles.registerParticle(sigma_minus);
        Particles.registerParticle(antisigma_minus);
        Particles.registerParticle(delta_plus_plus);
        Particles.registerParticle(antidelta_plus_plus);
        Particles.registerParticle(delta_minus);
        Particles.registerParticle(antidelta_minus);
    }

    private static void initComposites() {
        proton = new Particle("proton", Util.appendPath(particlePath, "proton.png"), 938.0, 1.0, 0.5, true, true);
        proton.addComponentParticle(up, 2);
        proton.addComponentParticle(down);
        antiproton = Particles.makeAntiParticle(proton, "antiproton", Util.appendPath(particlePath, "antiproton.png"));
        neutron = new Particle("neutron", Util.appendPath(particlePath, "neutron.png"), 940.0, 0.0, 0.5, true, true);
        neutron.addComponentParticle(up);
        neutron.addComponentParticle(down, 2);
        antineutron = Particles.makeAntiParticle(neutron, "antineutron", Util.appendPath(particlePath, "antineutron.png"));
        deuteron = new Particle("deuteron", Util.appendPath(particlePath, "deuteron.png"), 1876.0, 1.0, 1.0, true, true);
        deuteron.addComponentParticle(proton);
        deuteron.addComponentParticle(neutron);
        antideuteron = Particles.makeAntiParticle(deuteron, "antideuteron", Util.appendPath(particlePath, "antideuteron.png"));
        alpha = new Particle("alpha", Util.appendPath(particlePath, "alpha.png"), 3727.0, 2.0, 0.0, true, true);
        alpha.addComponentParticle(proton, 2);
        alpha.addComponentParticle(neutron, 2);
        antialpha = Particles.makeAntiParticle(alpha, "antialpha", Util.appendPath(particlePath, "antialpha.png"));
        triton = new Particle("triton", Util.appendPath(particlePath, "triton.png"), 2809.0, 1.0, 0.5, true, true);
        triton.addComponentParticle(proton);
        triton.addComponentParticle(neutron, 2);
        antitriton = Particles.makeAntiParticle(triton, "antitriton", Util.appendPath(particlePath, "antitriton.png"));
        helion = new Particle("helion", Util.appendPath(particlePath, "helion.png"), 2808.0, 2.0, 0.5, true, true);
        helion.addComponentParticle(proton, 2);
        helion.addComponentParticle(neutron);
        antihelion = Particles.makeAntiParticle(helion, "antihelion", Util.appendPath(particlePath, "antihelion.png"));
        boron_ion = new Particle("boron_ion", Util.appendPath(particlePath, "boron_ion.png"), 10250.0, 1.0, 0.5, true, true);
        boron_ion.addComponentParticle(proton, 5);
        boron_ion.addComponentParticle(neutron, 6);
        boron_ion.addComponentParticle(electron, 4);
        calcium_48_ion = new Particle("calcium_48_ion", Util.appendPath(particlePath, "calcium_48_ion.png"), 44600.0, 1.0, 0.0, true, true);
        calcium_48_ion.addComponentParticle(proton, 20);
        calcium_48_ion.addComponentParticle(neutron, 28);
        calcium_48_ion.addComponentParticle(electron, 19);
        pion_plus = new Particle("pion_plus", Util.appendPath(particlePath, "pion_plus.png"), 140.0, 1.0, 0.0, true, true);
        pion_plus.addComponentParticle(up);
        pion_plus.addComponentParticle(antidown);
        pion_minus = Particles.makeAntiParticle(pion_plus, "pion_minus", Util.appendPath(particlePath, "pion_minus.png"));
        pion_naught = new Particle("pion_naught", Util.appendPath(particlePath, "pion_naught.png"), 135.0, 0.0, 0.0, true, true);
        pion_naught.addComponentParticle(up);
        pion_naught.addComponentParticle(antiup);
        kaon_plus = new Particle("kaon_plus", Util.appendPath(particlePath, "kaon_plus.png"), 464.0, 1.0, 0.0, true, true);
        kaon_plus.addComponentParticle(up);
        kaon_plus.addComponentParticle(antistrange);
        kaon_minus = Particles.makeAntiParticle(kaon_plus, "kaon_minus", Util.appendPath(particlePath, "kaon_minus.png"));
        kaon_naught = new Particle("kaon_naught", Util.appendPath(particlePath, "kaon_naught.png"), 498.0, 1.0, 0.0, true, true);
        kaon_naught.addComponentParticle(down);
        kaon_naught.addComponentParticle(antistrange);
        antikaon_naught = Particles.makeAntiParticle(kaon_naught, "antikaon_naught", Util.appendPath(particlePath, "antikaon_naught.png"));
        eta = new Particle("eta", Util.appendPath(particlePath, "eta.png"), 548.0, 0.0, 0.0, true, true);
        eta.addComponentParticle(down);
        eta.addComponentParticle(antidown);
        eta_prime = new Particle("eta_prime", Util.appendPath(particlePath, "eta_prime.png"), 958.0, 0.0, 0.0, true, true);
        eta_prime.addComponentParticle(strange);
        eta_prime.addComponentParticle(antistrange);
        charmed_eta = new Particle("charmed_eta", Util.appendPath(particlePath, "charmed_eta.png"), 2980.0, 0.0, 0.0, true, true);
        charmed_eta.addComponentParticle(charm);
        charmed_eta.addComponentParticle(anticharm);
        bottom_eta = new Particle("bottom_eta", Util.appendPath(particlePath, "bottom_eta.png"), 9400.0, 0.0, 0.0, true, true);
        bottom_eta.addComponentParticle(bottom);
        bottom_eta.addComponentParticle(antibottom);
        glueball = new Particle("glueball", Util.appendPath(particlePath, "glueball.png"), 1730.0, 0.0, 0.0, false, true);
        glueball.addComponentParticle(gluon, 2);
        sigma_plus = new Particle("sigma_plus", Util.appendPath(particlePath, "sigma_plus.png"), 1190.0, 1.0, 0.5, true, true);
        sigma_plus.addComponentParticle(up, 2);
        sigma_plus.addComponentParticle(strange);
        antisigma_plus = Particles.makeAntiParticle(sigma_plus, "antisigma_plus", Util.appendPath(particlePath, "antisigma_plus.png"));
        sigma_minus = new Particle("sigma_minus", Util.appendPath(particlePath, "sigma_minus.png"), 1200.0, -1.0, 0.5, true, true);
        sigma_minus.addComponentParticle(down, 2);
        sigma_minus.addComponentParticle(strange);
        antisigma_minus = Particles.makeAntiParticle(sigma_minus, "antisigma_minus", Util.appendPath(particlePath, "antisigma_minus.png"));
        delta_plus_plus = new Particle("delta_plus_plus", Util.appendPath(particlePath, "delta_plus_plus.png"), 1232.0, 2.0, 1.5, true, true);
        delta_plus_plus.addComponentParticle(up, 3);
        antidelta_plus_plus = Particles.makeAntiParticle(delta_plus_plus, "antidelta_plus_plus", Util.appendPath(particlePath, "antidelta_plus_plus.png"));
        delta_minus = new Particle("delta_minus", Util.appendPath(particlePath, "delta_minus.png"), 1232.0, -1.0, 1.5, true, true);
        delta_minus.addComponentParticle(down, 3);
        antidelta_minus = Particles.makeAntiParticle(delta_minus, "antidelta_minus", Util.appendPath(particlePath, "antidelta_minus.png"));
    }

    public static Particle makeAntiParticle(Particle particle, String name, ResourceLocation texture) {
        double mass = particle.getMass();
        double charge = 0.0;
        if (particle.getCharge() != 0.0) {
            charge = -particle.getCharge();
        }
        double spin = particle.getSpin();
        boolean weakCharged = particle.interactsWithWeak();
        boolean isColoured = particle.interactsWithStrong();
        HashMap<Particle, Integer> anticomponents = new HashMap<Particle, Integer>();
        for (Map.Entry<Particle, Integer> component : particle.getComponentParticles().entrySet()) {
            anticomponents.put(component.getKey().getAntiParticle(), component.getValue());
        }
        Particle antiparticle = new Particle(name, texture, mass, charge, spin, weakCharged, isColoured);
        antiparticle.setComponentParticles(anticomponents);
        antiparticle.setAntiParticle(particle);
        return antiparticle;
    }
}

