/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particleChamber;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.container.ContainerCollisionChamberController;
import lach_01298.qmd.multiblock.network.CollisionChamberUpdatePacket;
import lach_01298.qmd.multiblock.network.ParticleChamberUpdatePacket;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.particleChamber.ParticleChamber;
import lach_01298.qmd.particleChamber.ParticleChamberLogic;
import lach_01298.qmd.particleChamber.tile.IParticleChamberController;
import lach_01298.qmd.particleChamber.tile.TileCollisionChamberController;
import lach_01298.qmd.particleChamber.tile.TileParticleChamber;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberBeam;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberBeamPort;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberDetector;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberEnergyPort;
import lach_01298.qmd.recipe.QMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeInfo;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.multiblock.container.ContainerMultiblockController;
import nc.multiblock.tile.TileBeefAbstract;
import nc.tile.internal.fluid.Tank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class CollisionChamberLogic
extends ParticleChamberLogic {
    public QMDRecipeInfo<QMDRecipe> recipeInfo;
    public byte portASetting = (byte)2;
    public byte portBSetting = (byte)3;
    public byte portCSetting = (byte)4;
    public byte portDSetting = (byte)5;
    public static final int chamberLength = 17;

    public CollisionChamberLogic(ParticleChamberLogic oldLogic) {
        super(oldLogic);
    }

    @Override
    public String getID() {
        return "collision_chamber";
    }

    @Override
    public boolean isMachineWhole() {
        ArrayList portPostions;
        BlockPos port4;
        BlockPos port3;
        BlockPos port2;
        BlockPos port1;
        TileParticleChamberBeamPort port;
        BlockPos end2;
        BlockPos end1;
        EnumFacing.Axis axis;
        if (this.getMultiblock().getExteriorLengthX() > this.getMultiblock().getExteriorLengthZ()) {
            axis = EnumFacing.Axis.X;
            if (this.getMultiblock().getExteriorLengthX() != 17) {
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.wrong_length", null, new Object[0]);
                return false;
            }
            if (this.getMultiblock().getExteriorLengthZ() % 2 != 1 || this.getMultiblock().getExteriorLengthZ() != this.getMultiblock().getExteriorLengthY()) {
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_odd_square", null, new Object[0]);
                return false;
            }
        } else {
            axis = EnumFacing.Axis.Z;
            if (this.getMultiblock().getExteriorLengthZ() != 17) {
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.wrong_length", null, new Object[0]);
                return false;
            }
            if (this.getMultiblock().getExteriorLengthX() % 2 != 1 || this.getMultiblock().getExteriorLengthX() != this.getMultiblock().getExteriorLengthY()) {
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_odd_square", null, new Object[0]);
                return false;
            }
        }
        for (BlockPos pos : this.getinteriorAxisPositions(axis)) {
            if (this.getMultiblock().WORLD.func_175625_s(pos) instanceof TileParticleChamber) continue;
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_target", pos, new Object[0]);
            return false;
        }
        if (axis == EnumFacing.Axis.X) {
            end1 = this.getMultiblock().getExtremeInteriorCoord(false, false, false).func_177982_a(-1, this.getMultiblock().getInteriorLengthY() / 2, this.getMultiblock().getInteriorLengthZ() / 2);
            end2 = this.getMultiblock().getExtremeInteriorCoord(true, false, false).func_177982_a(1, this.getMultiblock().getInteriorLengthY() / 2, this.getMultiblock().getInteriorLengthZ() / 2);
            if (this.getMultiblock().WORLD.func_175625_s(end1) instanceof TileParticleChamberBeamPort) {
                port = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(end1);
                if (port.getIOType() != EnumTypes.IOType.INPUT) {
                    ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_input_beam_port", end1, new Object[0]);
                    return false;
                }
            } else {
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_input_beam_port", end1, new Object[0]);
                return false;
            }
            if (this.getMultiblock().WORLD.func_175625_s(end2) instanceof TileParticleChamberBeamPort) {
                port = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(end2);
                if (port.getIOType() != EnumTypes.IOType.INPUT) {
                    ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_input_beam_port", end2, new Object[0]);
                    return false;
                }
            } else {
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_input_beam_port", end2, new Object[0]);
                return false;
            }
        }
        if (axis == EnumFacing.Axis.Z) {
            end1 = this.getMultiblock().getExtremeInteriorCoord(false, false, false).func_177982_a(this.getMultiblock().getInteriorLengthX() / 2, this.getMultiblock().getInteriorLengthY() / 2, -1);
            end2 = this.getMultiblock().getExtremeInteriorCoord(false, false, true).func_177982_a(this.getMultiblock().getInteriorLengthX() / 2, this.getMultiblock().getInteriorLengthY() / 2, 1);
            if (this.getMultiblock().WORLD.func_175625_s(end1) instanceof TileParticleChamberBeamPort) {
                port = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(end1);
                if (port.getIOType() != EnumTypes.IOType.INPUT) {
                    ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_input_beam_port", end1, new Object[0]);
                    return false;
                }
            } else {
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_input_beam_port", end1, new Object[0]);
                return false;
            }
            if (this.getMultiblock().WORLD.func_175625_s(end2) instanceof TileParticleChamberBeamPort) {
                port = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(end2);
                if (port.getIOType() != EnumTypes.IOType.INPUT) {
                    ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_input_beam_port", end2, new Object[0]);
                    return false;
                }
            } else {
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_input_beam_port", end2, new Object[0]);
                return false;
            }
        }
        if (axis == EnumFacing.Axis.X) {
            port1 = this.getMultiblock().getExtremeCoord(false, false, true).func_177982_a(2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0);
            port2 = this.getMultiblock().getExtremeCoord(true, false, true).func_177982_a(-2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0);
            port3 = this.getMultiblock().getExtremeCoord(true, false, false).func_177982_a(-2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0);
            port4 = this.getMultiblock().getExtremeCoord(false, false, false).func_177982_a(2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0);
            portPostions = new ArrayList(){};
            portPostions.add(port1);
            portPostions.add(port2);
            portPostions.add(port3);
            portPostions.add(port4);
            for (BlockPos pos : portPostions) {
                int i;
                if (this.getMultiblock().WORLD.func_175625_s(pos) instanceof TileParticleChamberBeamPort) {
                    TileParticleChamberBeamPort port5 = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(pos);
                    if (port5.getIOType() != EnumTypes.IOType.OUTPUT) {
                        ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_output_beam_port", pos, new Object[0]);
                        return false;
                    }
                } else {
                    ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_output_beam_port", pos, new Object[0]);
                    return false;
                }
                for (i = 1; i <= this.getMultiblock().getExteriorLengthZ() - 2; ++i) {
                    if (i == (this.getMultiblock().getExteriorLengthZ() - 2) / 2 + 1 || this.getMultiblock().WORLD.func_175625_s(port1.func_177967_a(EnumFacing.NORTH, i)) instanceof TileParticleChamberBeam) continue;
                    ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_be_beam", port1.func_177967_a(EnumFacing.NORTH, i), new Object[0]);
                    return false;
                }
                for (i = 1; i <= this.getMultiblock().getExteriorLengthZ() - 2; ++i) {
                    if (i == (this.getMultiblock().getExteriorLengthZ() - 2) / 2 + 1 || this.getMultiblock().WORLD.func_175625_s(port2.func_177967_a(EnumFacing.NORTH, i)) instanceof TileParticleChamberBeam) continue;
                    ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_be_beam", port2.func_177967_a(EnumFacing.NORTH, i), new Object[0]);
                    return false;
                }
            }
        }
        if (axis == EnumFacing.Axis.Z) {
            int i;
            port1 = this.getMultiblock().getExtremeCoord(false, false, false).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, 2);
            port2 = this.getMultiblock().getExtremeCoord(false, false, true).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, -2);
            port3 = this.getMultiblock().getExtremeCoord(true, false, true).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, -2);
            port4 = this.getMultiblock().getExtremeCoord(true, false, false).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, 2);
            portPostions = new ArrayList(){};
            portPostions.add(port1);
            portPostions.add(port2);
            portPostions.add(port3);
            portPostions.add(port4);
            for (BlockPos pos : portPostions) {
                if (this.getMultiblock().WORLD.func_175625_s(pos) instanceof TileParticleChamberBeamPort) {
                    TileParticleChamberBeamPort port6 = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(pos);
                    if (port6.getIOType() == EnumTypes.IOType.OUTPUT) continue;
                    ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_output_beam_port", pos, new Object[0]);
                    return false;
                }
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.collision_chamber.must_be_output_beam_port", pos, new Object[0]);
                return false;
            }
            for (i = 1; i <= this.getMultiblock().getExteriorLengthX() - 2; ++i) {
                if (i == (this.getMultiblock().getExteriorLengthX() - 2) / 2 + 1 || this.getMultiblock().WORLD.func_175625_s(port1.func_177967_a(EnumFacing.EAST, i)) instanceof TileParticleChamberBeam) continue;
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_be_beam", port1.func_177967_a(EnumFacing.EAST, i), new Object[0]);
                return false;
            }
            for (i = 1; i <= this.getMultiblock().getExteriorLengthX() - 2; ++i) {
                if (i == (this.getMultiblock().getExteriorLengthX() - 2) / 2 + 1 || this.getMultiblock().WORLD.func_175625_s(port2.func_177967_a(EnumFacing.EAST, i)) instanceof TileParticleChamberBeam) continue;
                ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.chamber.must_be_beam", port2.func_177967_a(EnumFacing.EAST, i), new Object[0]);
                return false;
            }
        }
        if (this.getPartMap(TileParticleChamberEnergyPort.class).size() < 1) {
            ((ParticleChamber)this.multiblock).setLastError("qmd.multiblock_validation.need_energy_ports", null, new Object[0]);
            return false;
        }
        return true;
    }

    public Set<BlockPos> getinteriorAxisPositions(EnumFacing.Axis axis) {
        HashSet<BlockPos> postions = new HashSet<BlockPos>();
        if (axis == EnumFacing.Axis.X) {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.getMultiblock().getExtremeInteriorCoord(false, false, false).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2, this.getMultiblock().getInteriorLengthZ() / 2), (BlockPos)this.getMultiblock().getExtremeInteriorCoord(true, false, false).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2, this.getMultiblock().getInteriorLengthZ() / 2))) {
                postions.add(pos.func_185334_h());
            }
        }
        if (axis == EnumFacing.Axis.Z) {
            for (BlockPos pos : BlockPos.func_177975_b((BlockPos)this.getMultiblock().getExtremeInteriorCoord(false, false, false).func_177982_a(this.getMultiblock().getInteriorLengthX() / 2, this.getMultiblock().getInteriorLengthY() / 2, 0), (BlockPos)this.getMultiblock().getExtremeInteriorCoord(false, false, true).func_177982_a(this.getMultiblock().getInteriorLengthX() / 2, this.getMultiblock().getInteriorLengthY() / 2, 0))) {
                postions.add(pos.func_185334_h());
            }
        }
        return postions;
    }

    @Override
    public int getMaximumInteriorLength() {
        return 15;
    }

    @Override
    public void onChamberFormed() {
        this.onResetStats();
        if (!this.getWorld().field_72995_K) {
            if (this.getMultiblock().getExteriorLengthX() > this.getMultiblock().getExteriorLengthZ()) {
                BlockPos end1 = this.getMultiblock().getExtremeInteriorCoord(false, false, false).func_177982_a(-1, this.getMultiblock().getInteriorLengthY() / 2, this.getMultiblock().getInteriorLengthZ() / 2);
                BlockPos end2 = this.getMultiblock().getExtremeInteriorCoord(true, false, false).func_177982_a(1, this.getMultiblock().getInteriorLengthY() / 2, this.getMultiblock().getInteriorLengthZ() / 2);
                TileParticleChamberBeamPort port0 = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(end1);
                port0.setIONumber(0);
                TileParticleChamberBeamPort port1 = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(end2);
                port1.setIONumber(1);
                TileParticleChamberBeamPort portA = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(false, false, false).func_177982_a(2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0));
                TileParticleChamberBeamPort portB = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(true, false, false).func_177982_a(-2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0));
                TileParticleChamberBeamPort portC = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(true, false, true).func_177982_a(-2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0));
                TileParticleChamberBeamPort portD = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(false, false, true).func_177982_a(2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0));
                portA.setIONumber(this.portASetting);
                portB.setIONumber(this.portBSetting);
                portC.setIONumber(this.portCSetting);
                portD.setIONumber(this.portDSetting);
                for (TileParticleChamberDetector detector : this.getPartMap(TileParticleChamberDetector.class).values()) {
                    TileEntity chamber = this.getMultiblock().WORLD.func_175625_s(new BlockPos(detector.func_174877_v().func_177958_n(), this.getMultiblock().getMiddleY(), this.getMultiblock().getMiddleZ()));
                    this.getMultiblock().requiredEnergy += detector.basePower;
                    if (!detector.isInvalidPostion(chamber.func_174877_v())) continue;
                    this.getMultiblock().efficiency += detector.efficiency;
                }
            } else {
                BlockPos end1 = this.getMultiblock().getExtremeInteriorCoord(false, false, false).func_177982_a(this.getMultiblock().getInteriorLengthX() / 2, this.getMultiblock().getInteriorLengthY() / 2, -1);
                BlockPos end2 = this.getMultiblock().getExtremeInteriorCoord(false, false, true).func_177982_a(this.getMultiblock().getInteriorLengthX() / 2, this.getMultiblock().getInteriorLengthY() / 2, 1);
                TileParticleChamberBeamPort port0 = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(end1);
                port0.setIONumber(0);
                TileParticleChamberBeamPort port1 = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(end2);
                port1.setIONumber(1);
                TileParticleChamberBeamPort portA = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(true, false, false).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, 2));
                TileParticleChamberBeamPort portB = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(true, false, true).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, -2));
                TileParticleChamberBeamPort portC = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(false, false, true).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, -2));
                TileParticleChamberBeamPort portD = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(false, false, false).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, 2));
                portA.setIONumber(this.portASetting);
                portB.setIONumber(this.portBSetting);
                portC.setIONumber(this.portCSetting);
                portD.setIONumber(this.portDSetting);
                for (TileParticleChamberDetector detector : this.getPartMap(TileParticleChamberDetector.class).values()) {
                    TileEntity chamber = this.getMultiblock().WORLD.func_175625_s(new BlockPos(this.getMultiblock().getMiddleX(), this.getMultiblock().getMiddleY(), detector.func_174877_v().func_177952_p()));
                    this.getMultiblock().requiredEnergy += detector.basePower;
                    if (!detector.isInvalidPostion(chamber.func_174877_v())) continue;
                    this.getMultiblock().efficiency += detector.efficiency;
                }
            }
        }
        super.onChamberFormed();
    }

    @Override
    public void onMachineDisassembled() {
        for (TileParticleChamberBeamPort tile : this.getPartMap(TileParticleChamberBeamPort.class).values()) {
            tile.setIONumber(0);
        }
        super.onMachineDisassembled();
    }

    @Override
    public boolean onUpdateServer() {
        this.getMultiblock().beams.get(0).setParticleStack(null);
        this.getMultiblock().beams.get(1).setParticleStack(null);
        this.pull();
        this.isChamberOn();
        if (this.getMultiblock().isChamberOn) {
            if (this.getMultiblock().energyStorage.extractEnergy(this.getMultiblock().requiredEnergy, true) == this.getMultiblock().requiredEnergy) {
                this.refreshRecipe();
                if (this.recipeInfo != null) {
                    this.getMultiblock().energyStorage.changeEnergyStored((long)(-this.getMultiblock().requiredEnergy));
                    this.produceBeams();
                } else {
                    this.resetBeams();
                }
            } else {
                this.resetBeams();
            }
        } else {
            this.resetBeams();
        }
        this.push();
        return super.onUpdateServer();
    }

    public void onResetStats() {
        this.getMultiblock().efficiency = 1.0;
        this.getMultiblock().requiredEnergy = QMDConfig.collision_chamber_power;
    }

    @Override
    public boolean toggleSetting(BlockPos pos, int ioNumber) {
        TileParticleChamberBeamPort portD;
        TileParticleChamberBeamPort portC;
        TileParticleChamberBeamPort portB;
        TileParticleChamberBeamPort portA;
        if (ioNumber == 0 || ioNumber == 1) {
            return false;
        }
        if (this.getMultiblock().getExteriorLengthX() > this.getMultiblock().getExteriorLengthZ()) {
            portA = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(false, false, false).func_177982_a(2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0));
            portB = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(true, false, false).func_177982_a(-2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0));
            portC = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(true, false, true).func_177982_a(-2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0));
            portD = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(false, false, true).func_177982_a(2, this.getMultiblock().getInteriorLengthY() / 2 + 1, 0));
        } else {
            portA = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(true, false, false).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, 2));
            portB = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(true, false, true).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, -2));
            portC = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(false, false, true).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, -2));
            portD = (TileParticleChamberBeamPort)this.getMultiblock().WORLD.func_175625_s(this.getMultiblock().getExtremeCoord(false, false, false).func_177982_a(0, this.getMultiblock().getInteriorLengthY() / 2 + 1, 2));
        }
        if (pos.equals((Object)portA.func_174877_v())) {
            int otherIO = portB.getIONumber();
            portB.setIONumber(ioNumber);
            this.portBSetting = (byte)ioNumber;
            portA.setIONumber(otherIO);
            this.portASetting = (byte)otherIO;
            return true;
        }
        if (pos.equals((Object)portB.func_174877_v())) {
            int otherIO = portC.getIONumber();
            portC.setIONumber(ioNumber);
            this.portCSetting = (byte)ioNumber;
            portB.setIONumber(otherIO);
            this.portBSetting = (byte)otherIO;
            return true;
        }
        if (pos.equals((Object)portC.func_174877_v())) {
            int otherIO = portD.getIONumber();
            portD.setIONumber(ioNumber);
            this.portDSetting = (byte)ioNumber;
            portC.setIONumber(otherIO);
            this.portCSetting = (byte)otherIO;
            return true;
        }
        if (pos.equals((Object)portD.func_174877_v())) {
            int otherIO = portA.getIONumber();
            portA.setIONumber(ioNumber);
            this.portASetting = (byte)ioNumber;
            portD.setIONumber(otherIO);
            this.portDSetting = (byte)otherIO;
            return true;
        }
        return false;
    }

    private void produceBeams() {
        ParticleStack input1 = this.getMultiblock().beams.get(0).getParticleStack();
        ParticleStack input2 = this.getMultiblock().beams.get(1).getParticleStack();
        ParticleStack output1 = (ParticleStack)this.recipeInfo.getRecipe().getParticleProducts().get(0).getStack();
        ParticleStack output2 = (ParticleStack)this.recipeInfo.getRecipe().getParticleProducts().get(1).getStack();
        ParticleStack output3 = (ParticleStack)this.recipeInfo.getRecipe().getParticleProducts().get(2).getStack();
        ParticleStack output4 = (ParticleStack)this.recipeInfo.getRecipe().getParticleProducts().get(3).getStack();
        long energyReleased = this.recipeInfo.getRecipe().getEnergyRelased();
        double crossSection = this.recipeInfo.getRecipe().getCrossSection();
        long collisionEnergy = (long)(2.0 * Math.sqrt(input1.getMeanEnergy() * input2.getMeanEnergy()));
        double inputFocus = Math.min(input1.getFocus(), input2.getFocus());
        int inputAmount = Math.min(input1.getAmount(), input2.getAmount());
        double outputFactor = crossSection * this.getMultiblock().efficiency * (1.0 - (double)Math.abs(input1.getMeanEnergy() - input2.getMeanEnergy()) / (double)(input1.getMeanEnergy() + input2.getMeanEnergy()));
        if (outputFactor >= 1.0) {
            outputFactor = 1.0;
        }
        int particlesOut = 0;
        if (output1 != null) {
            particlesOut += output1.getAmount();
        }
        if (output2 != null) {
            particlesOut += output2.getAmount();
        }
        if (output3 != null) {
            particlesOut += output3.getAmount();
        }
        if (output4 != null) {
            particlesOut += output4.getAmount();
        }
        this.getMultiblock().beams.get(2).setParticleStack(output1);
        if (output1 != null) {
            this.getMultiblock().beams.get(2).getParticleStack().setMeanEnergy((collisionEnergy + energyReleased) / (long)particlesOut);
            this.getMultiblock().beams.get(2).getParticleStack().setAmount((int)((double)output1.getAmount() * outputFactor * (double)inputAmount));
            this.getMultiblock().beams.get(2).getParticleStack().setFocus(inputFocus - (double)(this.getMultiblock().getMaximumInteriorLength() + this.getMultiblock().getExteriorLengthY() / 2) * QMDConfig.beamAttenuationRate);
        }
        this.getMultiblock().beams.get(3).setParticleStack(output2);
        if (output2 != null) {
            this.getMultiblock().beams.get(3).getParticleStack().setMeanEnergy((collisionEnergy + energyReleased) / (long)particlesOut);
            this.getMultiblock().beams.get(3).getParticleStack().setAmount((int)((double)output2.getAmount() * outputFactor * (double)inputAmount));
            this.getMultiblock().beams.get(3).getParticleStack().setFocus(inputFocus - (double)(this.getMultiblock().getMaximumInteriorLength() + this.getMultiblock().getExteriorLengthY() / 2) * QMDConfig.beamAttenuationRate);
        }
        this.getMultiblock().beams.get(4).setParticleStack(output3);
        if (output3 != null) {
            this.getMultiblock().beams.get(4).getParticleStack().setMeanEnergy((collisionEnergy + energyReleased) / (long)particlesOut);
            this.getMultiblock().beams.get(4).getParticleStack().setAmount((int)((double)output3.getAmount() * outputFactor * (double)inputAmount));
            this.getMultiblock().beams.get(4).getParticleStack().setFocus(inputFocus - (double)(this.getMultiblock().getMaximumInteriorLength() + this.getMultiblock().getExteriorLengthY() / 2) * QMDConfig.beamAttenuationRate);
        }
        this.getMultiblock().beams.get(5).setParticleStack(output4);
        if (output4 != null) {
            this.getMultiblock().beams.get(5).getParticleStack().setMeanEnergy((collisionEnergy + energyReleased) / (long)particlesOut);
            this.getMultiblock().beams.get(5).getParticleStack().setAmount((int)((double)output4.getAmount() * outputFactor * (double)inputAmount));
            this.getMultiblock().beams.get(5).getParticleStack().setFocus(inputFocus - (double)(this.getMultiblock().getMaximumInteriorLength() + this.getMultiblock().getExteriorLengthY() / 2) * QMDConfig.beamAttenuationRate);
        }
    }

    private void resetBeams() {
        this.getMultiblock().beams.get(2).setParticleStack(null);
        this.getMultiblock().beams.get(3).setParticleStack(null);
        this.getMultiblock().beams.get(4).setParticleStack(null);
        this.getMultiblock().beams.get(5).setParticleStack(null);
    }

    protected void refreshRecipe() {
        if (this.getMultiblock().beams.get(0).getParticleStack() != null && this.getMultiblock().beams.get(1).getParticleStack() != null) {
            ArrayList<ParticleStack> particles = new ArrayList<ParticleStack>();
            long collisionEnergy = (long)(2.0 * Math.sqrt(this.getMultiblock().beams.get(0).getParticleStack().getMeanEnergy() * this.getMultiblock().beams.get(1).getParticleStack().getMeanEnergy()));
            ParticleStack copy1 = this.getMultiblock().beams.get(0).getParticleStack().copy();
            ParticleStack copy2 = this.getMultiblock().beams.get(1).getParticleStack().copy();
            copy1.setMeanEnergy(collisionEnergy / 2L);
            copy2.setMeanEnergy(collisionEnergy / 2L);
            particles.add(copy1);
            particles.add(copy2);
            this.recipeInfo = QMDRecipes.collision_chamber.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), new ArrayList<Tank>(), particles);
            if (this.recipeInfo != null && collisionEnergy > this.recipeInfo.getRecipe().getMaxEnergy()) {
                this.recipeInfo = null;
            }
        } else {
            this.recipeInfo = null;
        }
    }

    @Override
    public ParticleChamberUpdatePacket getUpdatePacket() {
        return new CollisionChamberUpdatePacket(this.getMultiblock().controller.getTilePos(), this.getMultiblock().isChamberOn, this.getMultiblock().requiredEnergy, this.getMultiblock().efficiency, this.getMultiblock().energyStorage, this.getMultiblock().tanks, this.getMultiblock().beams);
    }

    @Override
    public void onPacket(ParticleChamberUpdatePacket message) {
        super.onPacket(message);
        if (message instanceof CollisionChamberUpdatePacket) {
            CollisionChamberUpdatePacket packet = (CollisionChamberUpdatePacket)message;
            this.getMultiblock().beams = packet.beams;
        }
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
        logicTag.func_74774_a("portASetting", this.portASetting);
        logicTag.func_74774_a("portBSetting", this.portBSetting);
        logicTag.func_74774_a("portCSetting", this.portCSetting);
        logicTag.func_74774_a("portDSetting", this.portDSetting);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
        this.portASetting = logicTag.func_74771_c("portASetting");
        this.portBSetting = logicTag.func_74771_c("portBSetting");
        this.portCSetting = logicTag.func_74771_c("portCSetting");
        this.portDSetting = logicTag.func_74771_c("portDSetting");
    }

    @Override
    public ContainerMultiblockController<ParticleChamber, IParticleChamberController> getContainer(EntityPlayer player) {
        return new ContainerCollisionChamberController(player, (TileCollisionChamberController)this.getMultiblock().controller);
    }
}

