/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particleChamber;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.multiblock.network.ParticleChamberUpdatePacket;
import lach_01298.qmd.particle.IParticleStackHandler;
import lach_01298.qmd.particleChamber.ParticleChamber;
import lach_01298.qmd.particleChamber.tile.IParticleChamberController;
import lach_01298.qmd.particleChamber.tile.IParticleChamberPart;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberBeamPort;
import nc.multiblock.Multiblock;
import nc.multiblock.MultiblockLogic;
import nc.multiblock.container.ContainerMultiblockController;
import nc.multiblock.tile.TileBeefAbstract;
import nc.tile.internal.fluid.Tank;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class ParticleChamberLogic
extends MultiblockLogic<ParticleChamber, ParticleChamberLogic, IParticleChamberPart, ParticleChamberUpdatePacket> {
    public static final int maxSize = 7;
    public static final int minSize = 1;

    public ParticleChamberLogic(ParticleChamber multiblock) {
        super((Multiblock)multiblock);
    }

    public ParticleChamberLogic(ParticleChamberLogic oldLogic) {
        super((MultiblockLogic)oldLogic);
    }

    public String getID() {
        return "";
    }

    protected ParticleChamber getMultiblock() {
        return (ParticleChamber)this.multiblock;
    }

    public int getMinimumInteriorLength() {
        return 1;
    }

    public int getMaximumInteriorLength() {
        return 7;
    }

    public void onMachineAssembled() {
        this.onChamberFormed();
    }

    public void onChamberFormed() {
        ObjectIterator objectIterator = this.getPartMap(IParticleChamberController.class).values().iterator();
        while (objectIterator.hasNext()) {
            IParticleChamberController contr;
            this.getMultiblock().controller = contr = (IParticleChamberController)objectIterator.next();
        }
        this.getMultiblock().energyStorage.setStorageCapacity((long)(QMDConfig.particle_chamber_base_energy_capacity * this.getCapacityMultiplier()));
        this.getMultiblock().energyStorage.setMaxTransfer(QMDConfig.particle_chamber_base_energy_capacity * this.getCapacityMultiplier());
        if (!this.getWorld().field_72995_K) {
            this.refreshChamber();
            this.getMultiblock().updateActivity();
        }
    }

    public void onMachineRestored() {
        this.onChamberFormed();
    }

    public int getCapacityMultiplier() {
        return this.getMultiblock().getExteriorVolume();
    }

    public void onMachinePaused() {
        this.onChamberBroken();
    }

    public void onMachineDisassembled() {
        this.onChamberBroken();
    }

    public void onChamberBroken() {
        if (!this.getWorld().field_72995_K) {
            this.getMultiblock().updateActivity();
        }
    }

    public boolean isMachineWhole() {
        ((ParticleChamber)this.multiblock).setLastError("zerocore.api.nc.multiblock.validation.invalid_logic", null, new Object[0]);
        return false;
    }

    public void writeToLogicTag(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
    }

    public void readFromLogicTag(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
    }

    public ParticleChamberUpdatePacket getUpdatePacket() {
        return null;
    }

    public void onPacket(ParticleChamberUpdatePacket message) {
    }

    public void onAssimilate(Multiblock assimilated) {
        if (assimilated instanceof ParticleChamber) {
            ParticleChamber assimilatedAccelerator = (ParticleChamber)assimilated;
            this.getMultiblock().energyStorage.mergeEnergyStorage(assimilatedAccelerator.energyStorage);
        }
        if (this.getMultiblock().isAssembled()) {
            this.onChamberFormed();
        } else {
            this.onChamberBroken();
        }
    }

    public void onAssimilated(Multiblock assimilator) {
    }

    public void refreshChamber() {
    }

    public boolean onUpdateServer() {
        return true;
    }

    public void onUpdateClient() {
    }

    public void refreshChamberStats() {
        this.getMultiblock().resetStats();
    }

    public boolean isChamberOn() {
        return this.getMultiblock().beams.get(0).getParticleStack() != null;
    }

    public ContainerMultiblockController<ParticleChamber, IParticleChamberController> getContainer(EntityPlayer player) {
        return null;
    }

    protected void pull() {
        for (TileParticleChamberBeamPort port : this.getPartMap(TileParticleChamberBeamPort.class).values()) {
            if (port.getIOType() != EnumTypes.IOType.INPUT) continue;
            for (EnumFacing face : EnumFacing.field_176754_o) {
                TileEntity tile = port.func_145831_w().func_175625_s(port.func_174877_v().func_177972_a(face));
                if (tile == null || !tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d())) continue;
                IParticleStackHandler otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d());
                this.getMultiblock().beams.get(port.getIONumber()).setParticleStack(otherStorage.extractParticle(face.func_176734_d()));
            }
        }
    }

    protected void push() {
        for (TileParticleChamberBeamPort port : this.getPartMap(TileParticleChamberBeamPort.class).values()) {
            if (port.getIOType() != EnumTypes.IOType.OUTPUT) continue;
            for (EnumFacing face : EnumFacing.field_176754_o) {
                TileEntity tile = port.func_145831_w().func_175625_s(port.func_174877_v().func_177972_a(face));
                if (tile == null || !tile.hasCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d())) continue;
                IParticleStackHandler otherStorage = (IParticleStackHandler)tile.getCapability(CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY, face.func_176734_d());
                otherStorage.reciveParticle(face.func_176734_d(), this.getMultiblock().beams.get(port.getIONumber()).getParticleStack());
            }
        }
    }

    public boolean toggleSetting(BlockPos pos, int ioNumber) {
        return false;
    }

    public List<Pair<Class<? extends IParticleChamberPart>, String>> getPartBlacklist() {
        return new ArrayList<Pair<Class<? extends IParticleChamberPart>, String>>();
    }

    public void clearAllMaterial() {
        for (Tank tank : this.getMultiblock().tanks) {
            tank.setFluidStored(null);
        }
    }

    @Nonnull
    public List<Tank> getTanks(List<Tank> backupTanks) {
        return this.getMultiblock().isAssembled() ? this.getMultiblock().tanks : backupTanks;
    }
}

