/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particleChamber.tile;

import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.block.BlockProperties;
import lach_01298.qmd.capabilities.CapabilityParticleStackHandler;
import lach_01298.qmd.enums.EnumTypes;
import lach_01298.qmd.io.IIOType;
import lach_01298.qmd.particle.ITileParticleStorage;
import lach_01298.qmd.particle.ParticleStorage;
import lach_01298.qmd.particle.ParticleStorageAccelerator;
import lach_01298.qmd.particleChamber.CollisionChamberLogic;
import lach_01298.qmd.particleChamber.ParticleChamber;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberPart;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.util.Lang;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;

public class TileParticleChamberBeamPort
extends TileParticleChamberPart
implements IIOType,
ITileParticleStorage {
    @Nonnull
    private final List<ParticleStorageAccelerator> backupTanks = Lists.newArrayList((Object[])new ParticleStorageAccelerator[]{new ParticleStorageAccelerator(), new ParticleStorageAccelerator(), new ParticleStorageAccelerator(), new ParticleStorageAccelerator()});
    private EnumTypes.IOType mode = EnumTypes.IOType.INPUT;
    private int IONumber = 0;

    public TileParticleChamberBeamPort() {
        super(CuboidalPartPositionType.WALL);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    @Override
    public EnumTypes.IOType getIOType() {
        return this.mode;
    }

    @Override
    public void setIOType(EnumTypes.IOType type) {
        this.mode = type;
    }

    public void cycleMode() {
        this.setIOType(this.mode.getNextIO());
        this.func_145831_w().func_175656_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a(BlockProperties.IO, (Comparable)((Object)this.mode)));
        this.markDirtyAndNotify();
        ((ParticleChamber)this.getMultiblock()).checkIfMachineIsWhole();
    }

    public boolean toggleSetting() {
        if (this.isMultiblockAssembled()) {
            return ((ParticleChamber)this.getMultiblock()).toggleSetting(this.field_174879_c, this.IONumber);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            if (!this.toggleSetting()) return false;
            int inputNumberOffset = 0;
            if (((ParticleChamber)this.getMultiblock()).getLogic() instanceof CollisionChamberLogic) {
                inputNumberOffset = 1;
            }
            player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise((String)"qmd.block.particle_chamber_port_setting_toggle") + " " + TextFormatting.LIGHT_PURPLE + " " + (this.getIONumber() - inputNumberOffset)));
            return true;
        } else {
            TextFormatting format;
            this.cycleMode();
            switch (this.getIOType()) {
                case INPUT: {
                    format = TextFormatting.DARK_AQUA;
                    break;
                }
                case OUTPUT: {
                    format = TextFormatting.RED;
                    break;
                }
                default: {
                    format = TextFormatting.GRAY;
                }
            }
            player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise((String)"qmd.block.port_mode_toggle") + " " + format + Lang.localise((String)("qmd.block.port_mode." + this.getIOType().name())) + " " + TextFormatting.WHITE + Lang.localise((String)"qmd.block.port.mode")));
        }
        return true;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74768_a("mode", this.mode.getID());
        nbt.func_74768_a("IONumber", this.IONumber);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.mode = EnumTypes.IOType.getTypeFromID(nbt.func_74762_e("mode"));
        this.IONumber = nbt.func_74762_e("IONumber");
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY) {
            return this.mode != EnumTypes.IOType.DISABLED;
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityParticleStackHandler.PARTICLE_HANDLER_CAPABILITY) {
            if (!this.getParticleBeams().isEmpty()) {
                return (T)this.getParticleBeams().get(this.IONumber);
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }

    @Override
    public List<? extends ParticleStorage> getParticleBeams() {
        if (!this.isMultiblockAssembled()) {
            return this.backupTanks;
        }
        return ((ParticleChamber)this.getMultiblock()).beams;
    }

    public void setIONumber(int number) {
        if (number >= 0) {
            this.IONumber = number;
        }
    }

    public int getIONumber() {
        return this.IONumber;
    }
}

