/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.particleChamber.tile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lach_01298.qmd.multiblock.container.ContainerTargetChamberController;
import lach_01298.qmd.particleChamber.ParticleChamber;
import lach_01298.qmd.particleChamber.tile.IParticleChamberController;
import lach_01298.qmd.particleChamber.tile.TileParticleChamberPart;
import lach_01298.qmd.recipe.QMDRecipeHandler;
import lach_01298.qmd.recipes.QMDRecipes;
import nc.block.property.BlockProperties;
import nc.multiblock.container.ContainerMultiblockController;
import nc.multiblock.cuboidal.CuboidalMultiblock;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.util.NBTHelper;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileTargetChamberController
extends TileParticleChamberPart
implements IParticleChamberController,
ITileInventory {
    @Nonnull
    private final String inventoryName = "qmd.container.target_chamber_controller";
    @Nonnull
    private final NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    @Nonnull
    private InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll((List)Lists.newArrayList((Object[])new ItemSorption[]{ItemSorption.IN, ItemSorption.OUT}));
    public QMDRecipeHandler recipe_handler = QMDRecipes.target_chamber;
    protected Set<EntityPlayer> playersToUpdate = new ObjectOpenHashSet();

    public TileTargetChamberController() {
        super(CuboidalPartPositionType.WALL);
    }

    public String getLogicID() {
        return "target_chamber";
    }

    public void onMachineAssembled(ParticleChamber controller) {
        super.onMachineAssembled((CuboidalMultiblock)controller);
        if (!this.func_145831_w().field_72995_K && this.getPartPosition().getFacing() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)this.getPartPosition().getFacing()), 2);
        }
    }

    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
        super.onBlockNeighborChanged(state, world, pos, fromPos);
        if (this.getMultiblock() != null) {
            ((ParticleChamber)this.getMultiblock()).updateActivity();
        }
    }

    public QMDRecipeHandler getRecipeHandler() {
        return this.recipe_handler;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
    }

    public NonNullList<ItemStack> getInventoryStacks() {
        return this.inventoryStacks;
    }

    public String func_70005_c_() {
        return "qmd.container.target_chamber_controller";
    }

    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    public void setInventoryConnections(InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    public ItemOutputSetting getItemOutputSetting(int slot) {
        return ItemOutputSetting.DEFAULT;
    }

    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
    }

    public NBTTagCompound writeInventory(NBTTagCompound nbt) {
        NBTHelper.writeAllItems((NBTTagCompound)nbt, (List[])new List[]{this.inventoryStacks});
        return nbt;
    }

    public void readInventory(NBTTagCompound nbt) {
        NBTHelper.readAllItems((NBTTagCompound)nbt, (List[])new List[]{this.inventoryStacks});
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.getRecipeHandler() == null) {
            return true;
        }
        if (stack == ItemStack.field_190927_a || slot >= this.getRecipeHandler().itemInputSize) {
            return false;
        }
        return this.getRecipeHandler().isValidItemInput(stack);
    }

    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return this.getRecipeHandler() == null || this.func_94041_b(slot, stack);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)this.getItemHandler(side);
            }
            return null;
        }
        return (T)super.getCapability(capability, side);
    }

    public ContainerMultiblockController getContainer(EntityPlayer player) {
        return new ContainerTargetChamberController(player, this);
    }
}

