/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.pipe;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Constructor;
import javax.annotation.Nonnull;
import lach_01298.qmd.pipe.IPipeController;
import lach_01298.qmd.pipe.IPipePart;
import lach_01298.qmd.pipe.PipeLogic;
import lach_01298.qmd.pipe.PipeMultiblock;
import lach_01298.qmd.pipe.PipeUpdatePacket;
import nc.multiblock.ILogicMultiblock;
import nc.multiblock.Multiblock;
import nc.multiblock.tile.ITileMultiblockPart;
import nc.multiblock.tile.TileBeefAbstract;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Pipe
extends PipeMultiblock<IPipePart, PipeUpdatePacket>
implements ILogicMultiblock<PipeLogic, IPipePart> {
    public static final ObjectSet<Class<? extends IPipePart>> PART_CLASSES = new ObjectOpenHashSet();
    public static final Object2ObjectMap<String, Constructor<? extends PipeLogic>> LOGIC_MAP = new Object2ObjectOpenHashMap();
    @Nonnull
    protected PipeLogic logic = new PipeLogic(this);
    protected final Multiblock.PartSuperMap<IPipePart> partSuperMap = new Multiblock.PartSuperMap();
    public IPipeController controller;

    public Pipe(World world) {
        super(world);
        for (Class clazz : PART_CLASSES) {
            this.partSuperMap.equip(clazz);
        }
    }

    @Nonnull
    public PipeLogic getLogic() {
        return this.logic;
    }

    public void setLogic(String logicID) {
        if (logicID.equals(this.logic.getID())) {
            return;
        }
        this.logic = (PipeLogic)this.getNewLogic((Constructor)LOGIC_MAP.get((Object)logicID));
    }

    public Multiblock.PartSuperMap<IPipePart> getPartSuperMap() {
        return this.partSuperMap;
    }

    public void onAttachedPartWithMultiblockData(ITileMultiblockPart part, NBTTagCompound data) {
        this.logic.onAttachedPartWithMultiblockData(part, data);
        this.syncDataFrom(data, TileBeefAbstract.SyncReason.FullSync);
    }

    protected void onBlockAdded(ITileMultiblockPart newPart) {
        this.onPartAdded(newPart);
        this.logic.onBlockAdded(newPart);
    }

    protected void onBlockRemoved(ITileMultiblockPart oldPart) {
        this.onPartRemoved(oldPart);
        this.logic.onBlockRemoved(oldPart);
    }

    protected void onMachineAssembled() {
        this.logic.onMachineAssembled();
    }

    protected void onMachineRestored() {
        this.logic.onMachineRestored();
    }

    protected void onMachinePaused() {
        this.logic.onMachinePaused();
    }

    protected void onMachineDisassembled() {
        this.logic.onMachineDisassembled();
    }

    protected void onAssimilate(Multiblock assimilated) {
        this.logic.onAssimilate(assimilated);
    }

    protected void onAssimilated(Multiblock assimilator) {
        this.logic.onAssimilated(assimilator);
    }

    protected boolean updateServer() {
        if (this.logic.onUpdateServer()) {
            return true;
        }
        this.sendUpdateToListeningPlayers();
        return true;
    }

    @Override
    protected boolean isMachineWhole() {
        return this.setLogic(this) && super.isMachineWhole() && this.logic.isMachineWhole();
    }

    protected void updateClient() {
        this.logic.onUpdateClient();
    }

    protected boolean isBlockGoodForInterior(World world, BlockPos pos) {
        return this.logic.isBlockGoodForInterior(world, pos);
    }

    public void syncDataFrom(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.logic.readFromLogicTag(data, syncReason);
    }

    public void syncDataTo(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.logic.writeToLogicTag(data, syncReason);
    }

    protected PipeUpdatePacket getUpdatePacket() {
        return this.logic.getUpdatePacket();
    }

    public void onPacket(PipeUpdatePacket message) {
        this.logic.onPacket(message);
    }

    public boolean setLogic(Multiblock multiblock) {
        if (this.getPartMap(IPipeController.class).isEmpty()) {
            multiblock.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        ObjectIterator objectIterator = this.getPartMap(IPipeController.class).values().iterator();
        while (objectIterator.hasNext()) {
            IPipeController contr;
            this.controller = contr = (IPipeController)objectIterator.next();
        }
        this.setLogic(this.controller.getLogicID());
        return true;
    }
}

