/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.recipe;

import com.google.common.collect.Lists;
import crafttweaker.annotations.ZenRegister;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import lach_01298.qmd.particle.Particle;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.particle.Particles;
import lach_01298.qmd.recipe.IQMDRecipe;
import lach_01298.qmd.recipe.QMDRecipeHelper;
import lach_01298.qmd.recipe.QMDRecipeInfo;
import lach_01298.qmd.recipe.QMDRecipeMatchResult;
import lach_01298.qmd.recipe.QMDRecipeTupleGenerator;
import lach_01298.qmd.recipe.ingredient.EmptyParticleIngredient;
import lach_01298.qmd.recipe.ingredient.IParticleIngredient;
import lach_01298.qmd.recipe.ingredient.ParticleIngredient;
import nc.recipe.IngredientSorption;
import nc.recipe.ingredient.ChanceFluidIngredient;
import nc.recipe.ingredient.ChanceItemIngredient;
import nc.recipe.ingredient.EmptyFluidIngredient;
import nc.recipe.ingredient.EmptyItemIngredient;
import nc.recipe.ingredient.FluidIngredient;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IItemIngredient;
import nc.recipe.ingredient.ItemIngredient;
import nc.recipe.ingredient.OreIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.FluidRegHelper;
import nc.util.OreDictHelper;
import nc.util.PermutationHelper;
import nc.util.StackHelper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Triple;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.qmd.AbstractQMDRecipeHandler")
@ZenRegister
public abstract class AbstractQMDRecipeHandler<RECIPE extends IQMDRecipe> {
    protected List<RECIPE> recipeList = new ArrayList<RECIPE>();
    protected Long2ObjectMap<List<RECIPE>> recipeCache = new Long2ObjectOpenHashMap();
    private static List<Class<?>> validItemInputs = Lists.newArrayList((Object[])new Class[]{IItemIngredient.class, ArrayList.class, String.class, Item.class, Block.class, ItemStack.class, ItemStack[].class});
    private static List<Class<?>> validFluidInputs = Lists.newArrayList((Object[])new Class[]{IFluidIngredient.class, ArrayList.class, String.class, Fluid.class, FluidStack.class, FluidStack[].class});
    private static List<Class<?>> validParticleInputs = Lists.newArrayList((Object[])new Class[]{IParticleIngredient.class, ArrayList.class, String.class, Particle.class, ParticleStack.class, ParticleStack[].class});
    private static List<Class<?>> validItemOutputs = Lists.newArrayList((Object[])new Class[]{IItemIngredient.class, String.class, Item.class, Block.class, ItemStack.class});
    private static List<Class<?>> validFluidOutputs = Lists.newArrayList((Object[])new Class[]{IFluidIngredient.class, String.class, Fluid.class, FluidStack.class});
    private static List<Class<?>> validParticleOutputs = Lists.newArrayList((Object[])new Class[]{IParticleIngredient.class, String.class, Particle.class, ParticleStack.class});
    private static List<Class<?>> needItemAltering = Lists.newArrayList((Object[])new Class[]{Item.class, Block.class});
    private static List<Class<?>> needFluidAltering = Lists.newArrayList((Object[])new Class[]{Fluid.class});
    private static List<Class<?>> needParticleAltering = Lists.newArrayList((Object[])new Class[]{Particle.class});
    public static final IntList INVALID = new IntArrayList(new int[]{-1});

    public abstract void addRecipes();

    @ZenMethod
    public abstract String getRecipeName();

    @ZenMethod
    public abstract List<RECIPE> getRecipeList();

    public Long2ObjectMap<List<RECIPE>> getRecipeCache() {
        return this.recipeCache;
    }

    public abstract void addRecipe(Object ... var1);

    @Nullable
    public QMDRecipeInfo<RECIPE> getRecipeInfoFromInputs(List<ItemStack> itemInputs, List<Tank> fluidInputs, List<ParticleStack> particleInputs) {
        List matchingRecipes = (List)this.recipeCache.get(QMDRecipeHelper.hashMaterialsRaw(itemInputs, fluidInputs, particleInputs));
        if (matchingRecipes != null) {
            for (IQMDRecipe recipe : matchingRecipes) {
                QMDRecipeMatchResult matchResult = recipe.matchInputs(itemInputs, fluidInputs, particleInputs, recipe.getExtras());
                if (!matchResult.matches()) continue;
                return new QMDRecipeInfo<IQMDRecipe>(recipe, matchResult);
            }
        }
        return null;
    }

    @Nullable
    public RECIPE getRecipeFromIngredients(List<IItemIngredient> itemIngredients, List<IFluidIngredient> fluidIngredients, List<IParticleIngredient> particleIngredients) {
        for (IQMDRecipe recipe : this.recipeList) {
            if (!recipe.matchIngredients(itemIngredients, fluidIngredients, particleIngredients).matches()) continue;
            return (RECIPE)recipe;
        }
        return null;
    }

    @Nullable
    public RECIPE getRecipeFromProducts(List<IItemIngredient> itemProducts, List<IFluidIngredient> fluidProducts, List<IParticleIngredient> particleProducts) {
        for (IQMDRecipe recipe : this.recipeList) {
            if (!recipe.matchProducts(itemProducts, fluidProducts, particleProducts).matches()) continue;
            return (RECIPE)recipe;
        }
        return null;
    }

    public boolean addRecipe(RECIPE recipe) {
        return recipe != null ? this.recipeList.add(recipe) : false;
    }

    public boolean removeRecipe(RECIPE recipe) {
        return recipe != null ? this.recipeList.remove(recipe) : false;
    }

    public void removeAllRecipes() {
        this.recipeList.clear();
        this.recipeCache.clear();
    }

    public void refreshCache() {
        this.recipeCache.clear();
        block0: for (IQMDRecipe recipe : this.recipeList) {
            int maxNumber;
            int i;
            ArrayList<List<ItemStack>> itemInputLists = new ArrayList<List<ItemStack>>();
            ArrayList<List<FluidStack>> fluidInputLists = new ArrayList<List<FluidStack>>();
            ArrayList<List<ParticleStack>> particleInputLists = new ArrayList<List<ParticleStack>>();
            for (IItemIngredient item : recipe.getItemIngredients()) {
                itemInputLists.add(item.getInputStackHashingList());
            }
            for (IFluidIngredient fluid : recipe.getFluidIngredients()) {
                fluidInputLists.add(fluid.getInputStackHashingList());
            }
            for (IParticleIngredient particle : recipe.getParticleIngredients()) {
                particleInputLists.add(particle.getInputStackHashingList());
            }
            int arrSize = recipe.getItemIngredients().size() + recipe.getFluidIngredients().size() + recipe.getParticleIngredients().size();
            int[] inputNumbers = new int[arrSize];
            Arrays.fill(inputNumbers, 0);
            int[] maxNumbers = new int[arrSize];
            for (i = 0; i < itemInputLists.size(); ++i) {
                maxNumber = ((List)itemInputLists.get(i)).size() - 1;
                if (maxNumber < 0) continue block0;
                maxNumbers[i] = maxNumber;
            }
            for (i = 0; i < fluidInputLists.size(); ++i) {
                maxNumber = ((List)fluidInputLists.get(i)).size() - 1;
                if (maxNumber < 0) continue block0;
                maxNumbers[i + itemInputLists.size()] = maxNumber;
            }
            for (i = 0; i < particleInputLists.size(); ++i) {
                maxNumber = ((List)particleInputLists.get(i)).size() - 1;
                if (maxNumber < 0) continue block0;
                maxNumbers[i + itemInputLists.size() + fluidInputLists.size()] = maxNumber;
            }
            ArrayList<Triple<List<ItemStack>, List<FluidStack>, List<ParticleStack>>> materialListTuples = new ArrayList<Triple<List<ItemStack>, List<FluidStack>, List<ParticleStack>>>();
            QMDRecipeTupleGenerator.INSTANCE.generateMaterialListTuples(materialListTuples, maxNumbers, inputNumbers, itemInputLists, fluidInputLists, particleInputLists);
            for (Triple triple : materialListTuples) {
                for (List items : PermutationHelper.permutations((List)((List)triple.getLeft()))) {
                    for (List fluids : PermutationHelper.permutations((List)((List)triple.getMiddle()))) {
                        for (List particles : PermutationHelper.permutations((List)((List)triple.getRight()))) {
                            if (this.recipeCache.containsKey(QMDRecipeHelper.hashMaterials(items, fluids, particles))) {
                                ((List)this.recipeCache.get(QMDRecipeHelper.hashMaterials(items, fluids, particles))).add(recipe);
                                continue;
                            }
                            ArrayList<IQMDRecipe> recipes = new ArrayList<IQMDRecipe>();
                            recipes.add(recipe);
                            this.recipeCache.put(QMDRecipeHelper.hashMaterials(items, fluids, particles), recipes);
                        }
                    }
                }
            }
        }
    }

    public static void addValidItemInput(Class itemInputType) {
        validItemInputs.add(itemInputType);
    }

    public static void addValidFluidInput(Class fluidInputType) {
        validFluidInputs.add(fluidInputType);
    }

    public static void addValidParticleInput(Class particleInputType) {
        validParticleInputs.add(particleInputType);
    }

    public static void addValidItemOutput(Class itemOutputType) {
        validItemOutputs.add(itemOutputType);
    }

    public static void addValidFluidOutput(Class fluidOutputType) {
        validFluidOutputs.add(fluidOutputType);
    }

    public static void addValidParticleOutput(Class particleOutputType) {
        validParticleOutputs.add(particleOutputType);
    }

    public static boolean isValidItemInputType(Object itemInput) {
        for (Class<?> itemInputType : validItemInputs) {
            if (itemInput instanceof ArrayList && itemInputType == ArrayList.class) {
                ArrayList list = (ArrayList)itemInput;
                for (Object obj : list) {
                    if (!AbstractQMDRecipeHandler.isValidItemInputType(obj)) continue;
                    return true;
                }
                continue;
            }
            if (!itemInputType.isInstance(itemInput)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidFluidInputType(Object fluidInput) {
        for (Class<?> fluidInputType : validFluidInputs) {
            if (fluidInput instanceof ArrayList && fluidInputType == ArrayList.class) {
                ArrayList list = (ArrayList)fluidInput;
                for (Object obj : list) {
                    if (!AbstractQMDRecipeHandler.isValidFluidInputType(obj)) continue;
                    return true;
                }
                continue;
            }
            if (!fluidInputType.isInstance(fluidInput)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidParticleInputType(Object particleInput) {
        for (Class<?> particleInputType : validParticleInputs) {
            if (particleInput instanceof ArrayList && particleInputType == ArrayList.class) {
                ArrayList list = (ArrayList)particleInput;
                for (Object obj : list) {
                    if (!AbstractQMDRecipeHandler.isValidParticleInputType(obj)) continue;
                    return true;
                }
                continue;
            }
            if (!particleInputType.isInstance(particleInput)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidItemOutputType(Object itemOutput) {
        for (Class<?> itemOutputType : validItemOutputs) {
            if (!itemOutputType.isInstance(itemOutput)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidFluidOutputType(Object fluidOutput) {
        for (Class<?> fluidOutputType : validFluidOutputs) {
            if (!fluidOutputType.isInstance(fluidOutput)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidParticleOutputType(Object particleOutput) {
        for (Class<?> particleOutputType : validParticleOutputs) {
            if (!particleOutputType.isInstance(particleOutput)) continue;
            return true;
        }
        return false;
    }

    public static boolean requiresItemFixing(Object object) {
        for (Class<?> objectType : needItemAltering) {
            if (!objectType.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean requiresFluidFixing(Object object) {
        for (Class<?> objectType : needFluidAltering) {
            if (!objectType.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean requiresParticleFixing(Object object) {
        for (Class<?> objectType : needParticleAltering) {
            if (!objectType.isInstance(object)) continue;
            return true;
        }
        return false;
    }

    public boolean isValidItemInput(ItemStack stack) {
        for (IQMDRecipe recipe : this.recipeList) {
            for (IItemIngredient input : recipe.getItemIngredients()) {
                if (!input.match((Object)stack, IngredientSorption.NEUTRAL).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidFluidInput(FluidStack stack) {
        for (IQMDRecipe recipe : this.recipeList) {
            for (IFluidIngredient input : recipe.getFluidIngredients()) {
                if (!input.match((Object)stack, IngredientSorption.NEUTRAL).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidParticleInput(ParticleStack stack) {
        for (IQMDRecipe recipe : this.recipeList) {
            for (IParticleIngredient input : recipe.getParticleIngredients()) {
                if (!input.match(stack, IngredientSorption.NEUTRAL).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidItemOutput(ItemStack stack) {
        for (IQMDRecipe recipe : this.recipeList) {
            for (IItemIngredient output : recipe.getItemProducts()) {
                if (!output.match((Object)stack, IngredientSorption.OUTPUT).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidFluidOutput(FluidStack stack) {
        for (IQMDRecipe recipe : this.recipeList) {
            for (IFluidIngredient output : recipe.getFluidProducts()) {
                if (!output.match((Object)stack, IngredientSorption.OUTPUT).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidParticleOutput(ParticleStack stack) {
        for (IQMDRecipe recipe : this.recipeList) {
            for (IParticleIngredient output : recipe.getParticleProducts()) {
                if (!output.match(stack, IngredientSorption.OUTPUT).matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isValidItemInput(ItemStack stack, ItemStack slotStack, List<ItemStack> otherInputs) {
        if (otherInputs.isEmpty() || stack.func_77969_a(slotStack) && StackHelper.areItemStackTagsEqual((ItemStack)stack, (ItemStack)slotStack)) {
            return this.isValidItemInput(stack);
        }
        ArrayList<ItemStack> otherStacks = new ArrayList<ItemStack>();
        for (ItemStack otherInput : otherInputs) {
            if (otherInput.func_190926_b()) continue;
            otherStacks.add(otherInput);
        }
        if (otherStacks.isEmpty()) {
            return this.isValidItemInput(stack);
        }
        ArrayList allStacks = Lists.newArrayList((Object[])new ItemStack[]{stack});
        allStacks.addAll(otherStacks);
        ArrayList<RECIPE> recipeList = new ArrayList<RECIPE>(this.recipeList);
        block1: for (IQMDRecipe recipe : this.recipeList) {
            block2: for (ItemStack obj : allStacks) {
                for (IItemIngredient input : recipe.getItemIngredients()) {
                    if (!input.match((Object)obj, IngredientSorption.NEUTRAL).matches()) continue;
                    continue block2;
                }
                recipeList.remove(recipe);
                continue block1;
            }
        }
        for (IQMDRecipe recipe : recipeList) {
            for (IItemIngredient input : recipe.getItemIngredients()) {
                if (!input.match((Object)stack, IngredientSorption.NEUTRAL).matches()) continue;
                for (ItemStack other : otherStacks) {
                    if (!input.match((Object)other, IngredientSorption.NEUTRAL).matches()) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static OreIngredient oreStack(String oreType, int stackSize) {
        if (!OreDictHelper.oreExists((String)oreType)) {
            return null;
        }
        return new OreIngredient(oreType, stackSize);
    }

    public static FluidIngredient fluidStack(String fluidName, int stackSize) {
        if (!FluidRegHelper.fluidExists((String)fluidName)) {
            return null;
        }
        return new FluidIngredient(fluidName, stackSize);
    }

    public static ParticleIngredient particleStack(String particleName, int meanEnergy, int amount, double focus) {
        if (Particles.getParticleFromName(particleName) == null) {
            return null;
        }
        return new ParticleIngredient(particleName, meanEnergy, amount, focus);
    }

    public static List<OreIngredient> oreStackList(List<String> oreTypes, int stackSize) {
        ArrayList<OreIngredient> oreStackList = new ArrayList<OreIngredient>();
        for (String oreType : oreTypes) {
            if (AbstractQMDRecipeHandler.oreStack(oreType, stackSize) == null) continue;
            oreStackList.add(AbstractQMDRecipeHandler.oreStack(oreType, stackSize));
        }
        return oreStackList;
    }

    public static List<FluidIngredient> fluidStackList(List<String> fluidNames, int stackSize) {
        ArrayList<FluidIngredient> fluidStackList = new ArrayList<FluidIngredient>();
        for (String fluidName : fluidNames) {
            if (AbstractQMDRecipeHandler.fluidStack(fluidName, stackSize) == null) continue;
            fluidStackList.add(AbstractQMDRecipeHandler.fluidStack(fluidName, stackSize));
        }
        return fluidStackList;
    }

    public static EmptyItemIngredient emptyItemStack() {
        return new EmptyItemIngredient();
    }

    public static EmptyFluidIngredient emptyFluidStack() {
        return new EmptyFluidIngredient();
    }

    public static EmptyParticleIngredient emptyParticleStack() {
        return new EmptyParticleIngredient();
    }

    public static ChanceItemIngredient chanceItemStack(ItemStack stack, int chancePercent) {
        if (stack == null) {
            return null;
        }
        return new ChanceItemIngredient((IItemIngredient)new ItemIngredient(stack), chancePercent);
    }

    public static ChanceItemIngredient chanceItemStack(ItemStack stack, int chancePercent, int minStackSize) {
        if (stack == null) {
            return null;
        }
        return new ChanceItemIngredient((IItemIngredient)new ItemIngredient(stack), chancePercent, minStackSize);
    }

    public static ChanceItemIngredient chanceOreStack(String oreType, int stackSize, int chancePercent) {
        if (!OreDictHelper.oreExists((String)oreType)) {
            return null;
        }
        return new ChanceItemIngredient((IItemIngredient)AbstractQMDRecipeHandler.oreStack(oreType, stackSize), chancePercent);
    }

    public static ChanceItemIngredient chanceOreStack(String oreType, int stackSize, int chancePercent, int minStackSize) {
        if (!OreDictHelper.oreExists((String)oreType)) {
            return null;
        }
        return new ChanceItemIngredient((IItemIngredient)AbstractQMDRecipeHandler.oreStack(oreType, stackSize), chancePercent, minStackSize);
    }

    public static ChanceFluidIngredient chanceFluidStack(String fluidName, int stackSize, int chancePercent, int stackDiff) {
        if (!FluidRegHelper.fluidExists((String)fluidName)) {
            return null;
        }
        return new ChanceFluidIngredient((IFluidIngredient)AbstractQMDRecipeHandler.fluidStack(fluidName, stackSize), chancePercent, stackDiff);
    }

    public static ChanceFluidIngredient chanceFluidStack(String fluidName, int stackSize, int chancePercent, int stackDiff, int minStackSize) {
        if (!FluidRegHelper.fluidExists((String)fluidName)) {
            return null;
        }
        return new ChanceFluidIngredient((IFluidIngredient)AbstractQMDRecipeHandler.fluidStack(fluidName, stackSize), chancePercent, stackDiff, minStackSize);
    }

    public static List<ChanceItemIngredient> chanceOreStackList(List<String> oreTypes, int stackSize, int chancePercent) {
        ArrayList<ChanceItemIngredient> oreStackList = new ArrayList<ChanceItemIngredient>();
        for (String oreType : oreTypes) {
            if (AbstractQMDRecipeHandler.chanceOreStack(oreType, stackSize, chancePercent) == null) continue;
            oreStackList.add(AbstractQMDRecipeHandler.chanceOreStack(oreType, stackSize, chancePercent));
        }
        return oreStackList;
    }

    public static List<ChanceItemIngredient> chanceOreStackList(List<String> oreTypes, int stackSize, int chancePercent, int minStackSize) {
        ArrayList<ChanceItemIngredient> oreStackList = new ArrayList<ChanceItemIngredient>();
        for (String oreType : oreTypes) {
            if (AbstractQMDRecipeHandler.chanceOreStack(oreType, stackSize, chancePercent, minStackSize) == null) continue;
            oreStackList.add(AbstractQMDRecipeHandler.chanceOreStack(oreType, stackSize, chancePercent, minStackSize));
        }
        return oreStackList;
    }

    public static List<ChanceFluidIngredient> chanceFluidStackList(List<String> fluidNames, int stackSize, int chancePercent, int stackDiff) {
        ArrayList<ChanceFluidIngredient> fluidStackList = new ArrayList<ChanceFluidIngredient>();
        for (String fluidName : fluidNames) {
            if (AbstractQMDRecipeHandler.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff) == null) continue;
            fluidStackList.add(AbstractQMDRecipeHandler.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff));
        }
        return fluidStackList;
    }

    public static List<ChanceFluidIngredient> chanceFluidStackList(List<String> fluidNames, int stackSize, int chancePercent, int stackDiff, int minStackSize) {
        ArrayList<ChanceFluidIngredient> fluidStackList = new ArrayList<ChanceFluidIngredient>();
        for (String fluidName : fluidNames) {
            if (AbstractQMDRecipeHandler.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff, minStackSize) == null) continue;
            fluidStackList.add(AbstractQMDRecipeHandler.chanceFluidStack(fluidName, stackSize, chancePercent, stackDiff, minStackSize));
        }
        return fluidStackList;
    }
}

