/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.recipe.ingredient;

import com.google.common.collect.Lists;
import crafttweaker.api.item.IIngredient;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Collection;
import java.util.List;
import lach_01298.qmd.crafttweaker.particle.CTParticleStack;
import lach_01298.qmd.particle.ParticleStack;
import lach_01298.qmd.recipe.ingredient.IParticleIngredient;
import nc.recipe.IngredientMatchResult;
import nc.recipe.IngredientSorption;
import net.minecraftforge.fml.common.Optional;

public class ParticleIngredient
implements IParticleIngredient {
    public ParticleStack stack;

    public ParticleIngredient(ParticleStack stack) {
        this.stack = stack;
    }

    public ParticleIngredient(String particleName, int amount, long meanEnergy, double focus) {
        this.stack = ParticleStack.getParticleStack(particleName, amount, meanEnergy, focus);
    }

    public ParticleStack getStack() {
        return this.stack == null ? null : this.stack.copy();
    }

    public List<ParticleStack> getInputStackList() {
        return Lists.newArrayList((Object[])new ParticleStack[]{this.stack});
    }

    public List<ParticleStack> getOutputStackList() {
        return Lists.newArrayList((Object[])new ParticleStack[]{this.stack});
    }

    public int getMaxStackSize(int ingredientNumber) {
        return this.stack.getAmount();
    }

    public void setMaxStackSize(int stackSize) {
        this.stack.setAmount(stackSize);
    }

    public String getIngredientName() {
        return this.stack.getParticle().getName();
    }

    public String getIngredientNamesConcat() {
        return this.stack.getParticle().getName();
    }

    public IntList getFactors() {
        return new IntArrayList((Collection)Lists.newArrayList((Object[])new Integer[]{this.stack.getAmount()}));
    }

    @Override
    public IParticleIngredient getFactoredIngredient(int factor) {
        ParticleStack newStack = this.stack.copy();
        newStack.setAmount(this.stack.getAmount() / factor);
        return new ParticleIngredient(newStack);
    }

    @Override
    public IngredientMatchResult match(Object object, IngredientSorption type) {
        if (object instanceof ParticleStack) {
            ParticleStack particleStack = (ParticleStack)object;
            if (!this.stack.matchesType(particleStack)) {
                return IngredientMatchResult.FAIL;
            }
            return new IngredientMatchResult(type.checkStackSize(this.stack.getAmount(), this.stack.getAmount()), 0);
        }
        if (object instanceof ParticleIngredient && this.match(((ParticleIngredient)object).stack, type).matches()) {
            return new IngredientMatchResult(type.checkStackSize(this.getMaxStackSize(0), ((ParticleIngredient)object).getMaxStackSize(0)), 0);
        }
        return IngredientMatchResult.FAIL;
    }

    @Override
    public IngredientMatchResult matchWithData(Object object, IngredientSorption type, List extras) {
        if (object instanceof ParticleStack) {
            ParticleStack particleStack = (ParticleStack)object;
            if (!this.stack.isInRange(particleStack, (Long)extras.get(0))) {
                return IngredientMatchResult.FAIL;
            }
            return new IngredientMatchResult(type.checkStackSize(this.stack.getAmount(), this.stack.getAmount()), 0);
        }
        if (object instanceof ParticleIngredient && this.matchWithData(((ParticleIngredient)object).stack, type, extras).matches()) {
            return new IngredientMatchResult(type.checkStackSize(this.getMaxStackSize(0), ((ParticleIngredient)object).getMaxStackSize(0)), 0);
        }
        return IngredientMatchResult.FAIL;
    }

    public boolean isValid() {
        return this.stack != null;
    }

    @Optional.Method(modid="crafttweaker")
    public IIngredient ct() {
        return new CTParticleStack(this.stack);
    }
}

