/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.vacuumChamber;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lach_01298.qmd.block.QMDBlocks;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.enums.BlockTypes;
import lach_01298.qmd.vacuumChamber.VacuumChamber;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberPart;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberBeam;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberHeater;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberPart;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberPlasmaGlass;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberPlasmaNozzle;
import nc.multiblock.PlacementRule;
import nc.util.StringHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class HeaterPlacement {
    public static final List<PlacementRule.RuleParser<IVacuumChamberPart>> RULE_PARSER_LIST = new LinkedList<PlacementRule.RuleParser<IVacuumChamberPart>>();
    public static final Object2ObjectMap<String, String> RULE_MAP_RAW = new Object2ObjectArrayMap();
    public static final Object2ObjectMap<String, PlacementRule<IVacuumChamberPart>> RULE_MAP = new PlacementRule.PlacementMap();
    public static final List<PlacementRule.TooltipBuilder<IVacuumChamberPart>> TOOLTIP_BUILDER_LIST = new LinkedList<PlacementRule.TooltipBuilder<IVacuumChamberPart>>();
    public static PlacementRule.RecipeHandler recipe_handler;
    public static final Object2ObjectMap<String, String> TOOLTIP_MAP;

    public static void preInit() {
        RULE_PARSER_LIST.add((PlacementRule.RuleParser<IVacuumChamberPart>)new DefaultRuleParser());
        TOOLTIP_BUILDER_LIST.add((PlacementRule.TooltipBuilder<IVacuumChamberPart>)new DefaultTooltipBuilder());
    }

    public static void init() {
        recipe_handler = new RecipeHandler();
        RULE_MAP.put((Object)"", (Object)new PlacementRule.Or(new ArrayList()));
        HeaterPlacement.addRule("iron_heater", QMDConfig.heater_rule[BlockTypes.HeaterType.IRON.getID()], new ItemStack(QMDBlocks.vacuumChamberHeater, 1, BlockTypes.HeaterType.IRON.getID()));
        HeaterPlacement.addRule("redstone_heater", QMDConfig.heater_rule[BlockTypes.HeaterType.REDSTONE.getID()], new ItemStack(QMDBlocks.vacuumChamberHeater, 1, BlockTypes.HeaterType.REDSTONE.getID()));
        HeaterPlacement.addRule("quartz_heater", QMDConfig.heater_rule[BlockTypes.HeaterType.QUARTZ.getID()], new ItemStack(QMDBlocks.vacuumChamberHeater, 1, BlockTypes.HeaterType.QUARTZ.getID()));
        HeaterPlacement.addRule("obsidian_heater", QMDConfig.heater_rule[BlockTypes.HeaterType.OBSIDIAN.getID()], new ItemStack(QMDBlocks.vacuumChamberHeater, 1, BlockTypes.HeaterType.OBSIDIAN.getID()));
        HeaterPlacement.addRule("glowstone_heater", QMDConfig.heater_rule[BlockTypes.HeaterType.GLOWSTONE.getID()], new ItemStack(QMDBlocks.vacuumChamberHeater, 1, BlockTypes.HeaterType.GLOWSTONE.getID()));
        HeaterPlacement.addRule("lapis_heater", QMDConfig.heater_rule[BlockTypes.HeaterType.LAPIS.getID()], new ItemStack(QMDBlocks.vacuumChamberHeater, 1, BlockTypes.HeaterType.LAPIS.getID()));
        HeaterPlacement.addRule("gold_heater", QMDConfig.heater_rule[BlockTypes.HeaterType.GOLD.getID()], new ItemStack(QMDBlocks.vacuumChamberHeater, 1, BlockTypes.HeaterType.GOLD.getID()));
        HeaterPlacement.addRule("diamond_heater", QMDConfig.heater_rule[BlockTypes.HeaterType.DIAMOND.getID()], new ItemStack(QMDBlocks.vacuumChamberHeater, 1, BlockTypes.HeaterType.DIAMOND.getID()));
    }

    public static void addRule(String id, String rule, Object ... blocks) {
        RULE_MAP_RAW.put((Object)id, (Object)rule);
        RULE_MAP.put((Object)id, HeaterPlacement.parse(rule));
        for (Object block : blocks) {
            recipe_handler.addRecipe(new Object[]{block, id});
        }
    }

    public static void postInit() {
        for (Object2ObjectMap.Entry entry : RULE_MAP.object2ObjectEntrySet()) {
            for (PlacementRule.TooltipBuilder<IVacuumChamberPart> builder : TOOLTIP_BUILDER_LIST) {
                String tooltip = builder.buildTooltip((PlacementRule)entry.getValue());
                if (tooltip == null) continue;
                TOOLTIP_MAP.put(entry.getKey(), (Object)tooltip);
            }
        }
    }

    public static PlacementRule<IVacuumChamberPart> parse(String string) {
        return PlacementRule.parse((String)string, RULE_PARSER_LIST);
    }

    public static boolean isCasing(VacuumChamber vacuumChamber, BlockPos pos) {
        TileEntity tile = vacuumChamber.WORLD.func_175625_s(pos);
        return tile instanceof TileVacuumChamberPart && ((TileVacuumChamberPart)tile).getPartPositionType().isGoodForWall();
    }

    public static boolean isBeam(VacuumChamber vacuumChamber, BlockPos pos) {
        TileVacuumChamberBeam beam = (TileVacuumChamberBeam)vacuumChamber.getPartMap(TileVacuumChamberBeam.class).get(pos.func_177986_g());
        return beam == null ? false : beam.isFunctional();
    }

    public static boolean isPlasmaGlass(VacuumChamber vacuumChamber, BlockPos pos) {
        TileVacuumChamberPlasmaGlass glass = (TileVacuumChamberPlasmaGlass)vacuumChamber.getPartMap(TileVacuumChamberPlasmaGlass.class).get(pos.func_177986_g());
        return glass != null;
    }

    public static boolean isNozzle(VacuumChamber vacuumChamber, BlockPos pos) {
        TileVacuumChamberPlasmaNozzle nozzle = (TileVacuumChamberPlasmaNozzle)vacuumChamber.getPartMap(TileVacuumChamberPlasmaNozzle.class).get(pos.func_177986_g());
        return nozzle != null;
    }

    public static boolean isActiveHeater(VacuumChamber vacuumChamber, BlockPos pos, String heaterName) {
        TileVacuumChamberHeater heater = (TileVacuumChamberHeater)vacuumChamber.getPartMap(TileVacuumChamberHeater.class).get(pos.func_177986_g());
        return heater == null ? false : heater.isFunctional() && (heaterName.equals("any") || heater.name.equals(heaterName));
    }

    static {
        TOOLTIP_MAP = new Object2ObjectOpenHashMap();
    }

    public static class RecipeHandler
    extends PlacementRule.RecipeHandler {
        public RecipeHandler() {
            super("vacuum_chamber");
        }
    }

    public static class DefaultTooltipBuilder
    extends PlacementRule.DefaultTooltipBuilder<IVacuumChamberPart> {
    }

    public static class AdjacentHeater
    extends Adjacent {
        protected final String heaterType;

        public AdjacentHeater(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType, String heaterType) {
            super(heaterType + "_heater", amount, countType, adjType);
            this.heaterType = heaterType;
        }

        public void checkIsRuleAllowed(String ruleID) {
            super.checkIsRuleAllowed(ruleID);
            if (this.countType != PlacementRule.CountType.AT_LEAST && this.heaterType.equals("any")) {
                throw new IllegalArgumentException((this.countType == PlacementRule.CountType.EXACTLY ? "Exact 'any heater'" : "'At most n of any heater'") + " placement rule with ID \"" + ruleID + "\" is disallowed due to potential ambiguity during rule checks!");
            }
        }

        public boolean satisfied(IVacuumChamberPart part, EnumFacing dir) {
            return HeaterPlacement.isActiveHeater((VacuumChamber)part.getMultiblock(), part.getTilePos().func_177972_a(dir), this.heaterType);
        }
    }

    public static class AdjacentNozzle
    extends Adjacent {
        public AdjacentNozzle(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("nozzle", amount, countType, adjType);
        }

        public boolean satisfied(IVacuumChamberPart part, EnumFacing dir) {
            return HeaterPlacement.isNozzle((VacuumChamber)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentGlass
    extends Adjacent {
        public AdjacentGlass(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("plasma_glass", amount, countType, adjType);
        }

        public boolean satisfied(IVacuumChamberPart part, EnumFacing dir) {
            return HeaterPlacement.isPlasmaGlass((VacuumChamber)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentBeam
    extends Adjacent {
        public AdjacentBeam(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("beam", amount, countType, adjType);
        }

        public boolean satisfied(IVacuumChamberPart part, EnumFacing dir) {
            return HeaterPlacement.isBeam((VacuumChamber)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static class AdjacentCasing
    extends Adjacent {
        public AdjacentCasing(int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super("vacuum_chamber_casing", amount, countType, adjType);
        }

        public boolean satisfied(IVacuumChamberPart part, EnumFacing dir) {
            return HeaterPlacement.isCasing((VacuumChamber)part.getMultiblock(), part.getTilePos().func_177972_a(dir));
        }
    }

    public static abstract class Adjacent
    extends PlacementRule.Adjacent<IVacuumChamberPart> {
        public Adjacent(String dependency, int amount, PlacementRule.CountType countType, PlacementRule.AdjacencyType adjType) {
            super(dependency, amount, countType, adjType);
        }
    }

    public static class DefaultRuleParser
    extends PlacementRule.DefaultRuleParser<IVacuumChamberPart> {
        @Nullable
        protected PlacementRule<IVacuumChamberPart> partialParse(String s) {
            PlacementRule.AdjacencyType adjType;
            PlacementRule.CountType countType;
            s = s.toLowerCase(Locale.ROOT);
            s = s.replaceAll("at exactly one vertex", "vertex");
            boolean exact = s.contains("exact");
            boolean atMost = s.contains("at most");
            boolean axial = s.contains("axial");
            boolean vertex = s.contains("vertex");
            boolean different = s.contains("different");
            if (exact && atMost || axial && vertex) {
                return null;
            }
            s = s.replaceAll("at least", "");
            s = s.replaceAll("exactly", "");
            s = s.replaceAll("exact", "");
            s = s.replaceAll("at most", "");
            s = s.replaceAll("axially", "");
            s = s.replaceAll("axial", "");
            s = s.replaceAll("at one vertex", "");
            s = s.replaceAll("at a vertex", "");
            s = s.replaceAll("at vertex", "");
            s = s.replaceAll("vertex", "");
            int amount = -1;
            String rule = null;
            String type = null;
            String[] split = s.split(Pattern.quote(" "));
            for (int i = 0; i < split.length; ++i) {
                if (StringHelper.NUMBER_S2I_MAP.containsKey((Object)split[i])) {
                    amount = StringHelper.NUMBER_S2I_MAP.getInt((Object)split[i]);
                }
                if (split[i].contains("wall") || split[i].contains("casing")) {
                    rule = "casing";
                    continue;
                }
                if (rule != null) continue;
                if (split[i].contains("beam")) {
                    rule = "beam";
                }
                if (split[i].contains("glass")) {
                    rule = "glass";
                }
                if (split[i].contains("nozzle")) {
                    rule = "nozzle";
                    continue;
                }
                if (!split[i].contains("heater")) continue;
                rule = "heater";
                if (i > 0) {
                    type = split[i - 1];
                    continue;
                }
                return null;
            }
            if (amount < 0 || rule == null) {
                return null;
            }
            PlacementRule.CountType countType2 = exact ? PlacementRule.CountType.EXACTLY : (countType = atMost ? PlacementRule.CountType.AT_MOST : PlacementRule.CountType.AT_LEAST);
            PlacementRule.AdjacencyType adjacencyType = axial ? PlacementRule.AdjacencyType.AXIAL : (adjType = vertex ? PlacementRule.AdjacencyType.VERTEX : PlacementRule.AdjacencyType.STANDARD);
            if (rule.equals("casing")) {
                return new AdjacentCasing(amount, countType, adjType);
            }
            if (rule.equals("beam")) {
                return new AdjacentBeam(amount, countType, adjType);
            }
            if (rule.equals("glass")) {
                return new AdjacentGlass(amount, countType, adjType);
            }
            if (rule.equals("nozzle")) {
                return new AdjacentNozzle(amount, countType, adjType);
            }
            if (rule.equals("heater")) {
                return new AdjacentHeater(amount, countType, adjType, type);
            }
            return null;
        }
    }
}

