/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.vacuumChamber;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.annotation.Nonnull;
import lach_01298.qmd.config.QMDConfig;
import lach_01298.qmd.multiblock.IMultiBlockTank;
import lach_01298.qmd.multiblock.network.ContainmentRenderPacket;
import lach_01298.qmd.multiblock.network.VacuumChamberUpdatePacket;
import lach_01298.qmd.network.QMDPacketHandler;
import lach_01298.qmd.particle.ParticleStorageAccelerator;
import lach_01298.qmd.recipes.QMDRecipes;
import lach_01298.qmd.vacuumChamber.VacuumChamberLogic;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberController;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberPart;
import nc.multiblock.ILogicMultiblock;
import nc.multiblock.Multiblock;
import nc.multiblock.container.ContainerMultiblockController;
import nc.multiblock.cuboidal.CuboidalMultiblock;
import nc.multiblock.tile.ITileMultiblockPart;
import nc.multiblock.tile.TileBeefAbstract;
import nc.recipe.BasicRecipe;
import nc.recipe.RecipeInfo;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.heat.HeatBuffer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class VacuumChamber
extends CuboidalMultiblock<IVacuumChamberPart, VacuumChamberUpdatePacket>
implements ILogicMultiblock<VacuumChamberLogic, IVacuumChamberPart>,
IMultiBlockTank {
    public static final ObjectSet<Class<? extends IVacuumChamberPart>> PART_CLASSES = new ObjectOpenHashSet();
    public static final Object2ObjectMap<String, Constructor<? extends VacuumChamberLogic>> LOGIC_MAP = new Object2ObjectOpenHashMap();
    @Nonnull
    protected VacuumChamberLogic logic = new VacuumChamberLogic(this);
    @Nonnull
    protected NBTTagCompound cachedData = new NBTTagCompound();
    protected final Multiblock.PartSuperMap<IVacuumChamberPart> partSuperMap = new Multiblock.PartSuperMap();
    public float materialXOffset = 0.0f;
    public float materialYOffset = 0.0f;
    public float materialZOffset = 0.0f;
    public float materialAngle = 0.0f;
    public long prevRenderTime = 0L;
    public boolean refreshFlag = true;
    public boolean isChamberOn = false;
    public boolean cold = false;
    public static final int MAX_TEMP = 400;
    public int ambientTemp = 290;
    public int maxOperatingTemp = 0;
    public long heating = 0L;
    public long currentHeating = 0L;
    public int maxCoolantIn = 0;
    public int maxCoolantOut = 0;
    public RecipeInfo<BasicRecipe> coolingRecipeInfo;
    public int requiredEnergy;
    public IVacuumChamberController controller;
    public final HeatBuffer heatBuffer = new HeatBuffer((long)QMDConfig.accelerator_base_heat_capacity);
    public final EnergyStorage energyStorage = new EnergyStorage((long)QMDConfig.accelerator_base_energy_capacity);
    public List<ParticleStorageAccelerator> beams = Lists.newArrayList((Object[])new ParticleStorageAccelerator[]{new ParticleStorageAccelerator(), new ParticleStorageAccelerator()});
    public List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(QMDConfig.accelerator_base_input_tank_capacity, QMDRecipes.accelerator_cooling_valid_fluids.get(0)), new Tank(QMDConfig.accelerator_base_output_tank_capacity, null), new Tank(1, null), new Tank(1, null), new Tank(1, null), new Tank(1, null), new Tank(1, null), new Tank(1, null)});

    public VacuumChamber(World world) {
        super(world);
        for (Class clazz : PART_CLASSES) {
            this.partSuperMap.equip(clazz);
        }
    }

    public VacuumChamberLogic getLogic() {
        return this.logic;
    }

    public void setLogic(String logicID) {
        if (logicID.equals(this.logic.getID())) {
            return;
        }
        this.logic = (VacuumChamberLogic)this.getNewLogic((Constructor)LOGIC_MAP.get((Object)logicID));
    }

    public Multiblock.PartSuperMap<IVacuumChamberPart> getPartSuperMap() {
        return this.partSuperMap;
    }

    protected int getMinimumInteriorLength() {
        return this.logic.getMinimumInteriorLength();
    }

    protected int getMaximumInteriorLength() {
        return this.logic.getMaximumInteriorLength();
    }

    public void onAttachedPartWithMultiblockData(ITileMultiblockPart part, NBTTagCompound data) {
        this.logic.onAttachedPartWithMultiblockData(part, data);
        this.syncDataFrom(data, TileBeefAbstract.SyncReason.FullSync);
    }

    protected void onBlockAdded(ITileMultiblockPart newPart) {
        this.onPartAdded(newPart);
        this.logic.onBlockAdded(newPart);
    }

    protected void onBlockRemoved(ITileMultiblockPart oldPart) {
        this.onPartRemoved(oldPart);
        this.logic.onBlockRemoved(oldPart);
    }

    protected void onMachineAssembled() {
        this.logic.onMachineAssembled();
    }

    protected void onMachineRestored() {
        this.logic.onMachineRestored();
    }

    protected void onMachinePaused() {
        this.logic.onMachinePaused();
    }

    protected void onMachineDisassembled() {
        this.logic.onMachineDisassembled();
    }

    protected boolean isMachineWhole() {
        return this.setLogic((Multiblock)this) && super.isMachineWhole() && this.logic.isMachineWhole();
    }

    public boolean setLogic(Multiblock multiblock) {
        if (this.getPartMap(IVacuumChamberController.class).isEmpty()) {
            multiblock.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.getPartMap(IVacuumChamberController.class).size() > 1) {
            multiblock.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        ObjectIterator objectIterator = this.getPartMap(IVacuumChamberController.class).values().iterator();
        while (objectIterator.hasNext()) {
            IVacuumChamberController contr;
            this.controller = contr = (IVacuumChamberController)objectIterator.next();
        }
        this.setLogic(this.controller.getLogicID());
        return true;
    }

    protected void onAssimilate(Multiblock assimilated) {
        this.logic.onAssimilate(assimilated);
    }

    protected void onAssimilated(Multiblock assimilator) {
        this.logic.onAssimilated(assimilator);
    }

    public long getExternalHeating() {
        return (long)((double)(this.ambientTemp - this.getTemperature()) * QMDConfig.accelerator_thermal_conductivity * (double)this.getExteriorSurfaceArea());
    }

    public long getMaxExternalHeating() {
        return (long)((double)this.ambientTemp * QMDConfig.accelerator_thermal_conductivity * (double)this.getExteriorSurfaceArea());
    }

    public int getTemperature() {
        return Math.round(400.0f * (float)this.heatBuffer.getHeatStored() / (float)this.heatBuffer.getHeatCapacity());
    }

    protected boolean updateServer() {
        boolean flag = false;
        this.updateActivity();
        if (this.logic.onUpdateServer()) {
            flag = true;
        }
        return flag;
    }

    public void updateActivity() {
        boolean wasContainmentOn = this.isChamberOn;
        boolean bl = this.isChamberOn = this.isAssembled() && this.logic.isMultiblockOn();
        if (this.isChamberOn != wasContainmentOn && this.controller != null) {
            this.controller.setActivity(this.isChamberOn);
            this.sendUpdateToAllPlayers();
        }
    }

    protected void updateClient() {
        this.logic.onUpdateClient();
    }

    public void syncDataTo(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.heatBuffer.writeToNBT(data, "heatBuffer");
        this.energyStorage.writeToNBT(data, "energyStorage");
        this.writeTanks(this.tanks, data, "tanks");
        this.writeBeams(this.beams, data);
        data.func_74757_a("isContainmentOn", this.isChamberOn);
        data.func_74772_a("heating", this.heating);
        data.func_74768_a("coolantIn", this.maxCoolantIn);
        data.func_74768_a("coolantOut", this.maxCoolantOut);
        data.func_74780_a("maxOperatingTemp", (double)this.maxOperatingTemp);
        data.func_74772_a("requiredEnergy", (long)this.requiredEnergy);
        data.func_74757_a("cold", this.cold);
        this.writeLogicNBT(data, syncReason);
    }

    public void syncDataFrom(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.heatBuffer.readFromNBT(data, "heatBuffer");
        this.energyStorage.readFromNBT(data, "energyStorage");
        this.readTanks(this.tanks, data, "tanks");
        this.readBeams(this.beams, data);
        this.isChamberOn = data.func_74767_n("isContainmentOn");
        this.heating = data.func_74763_f("rawHeating");
        this.maxCoolantIn = data.func_74762_e("coolantIn");
        this.maxCoolantOut = data.func_74762_e("coolantOut");
        this.maxOperatingTemp = data.func_74762_e("maxOperatingTemp");
        this.requiredEnergy = data.func_74762_e("requiredEnergy");
        this.cold = data.func_74767_n("cold");
        this.readLogicNBT(data, syncReason);
    }

    public NBTTagCompound writeBeams(List<ParticleStorageAccelerator> beams, NBTTagCompound data) {
        for (int i = 0; i < beams.size(); ++i) {
            beams.get(i).writeToNBT(data, i);
        }
        return data;
    }

    public void readBeams(List<ParticleStorageAccelerator> beams, NBTTagCompound data) {
        for (int i = 0; i < beams.size(); ++i) {
            beams.get(i).readFromNBT(data, i);
        }
        beams.get(0).readFromNBT(data);
    }

    protected VacuumChamberUpdatePacket getUpdatePacket() {
        return this.logic.getUpdatePacket();
    }

    public void onPacket(VacuumChamberUpdatePacket message) {
        this.heatBuffer.setHeatCapacity(message.heatBuffer.getHeatCapacity());
        this.heatBuffer.setHeatStored(message.heatBuffer.getHeatStored());
        this.energyStorage.setStorageCapacity((long)message.energyStorage.getMaxEnergyStored());
        this.energyStorage.setEnergyStored((long)message.energyStorage.getEnergyStored());
        for (int i = 0; i < this.tanks.size(); ++i) {
            this.tanks.get(i).readInfo(message.tanksInfo.get(i));
        }
        this.beams = message.beams;
        this.isChamberOn = message.isContainmentOn;
        this.heating = message.heating;
        this.currentHeating = message.currentHeating;
        this.maxCoolantIn = message.maxCoolantIn;
        this.maxCoolantOut = message.maxCoolantOut;
        this.maxOperatingTemp = message.maxOperatingTemp;
        this.requiredEnergy = message.requiredEnergy;
        this.logic.onPacket(message);
    }

    protected ContainmentRenderPacket getRenderPacket() {
        return this.logic.getRenderPacket();
    }

    public void onRenderPacket(ContainmentRenderPacket message) {
        this.logic.onRenderPacket(message);
    }

    public void sendIndividualRender(EntityPlayer player) {
        if (this.WORLD.field_72995_K) {
            return;
        }
        ContainmentRenderPacket packet = this.getRenderPacket();
        if (packet == null) {
            return;
        }
        QMDPacketHandler.instance.sendTo((IMessage)packet, (EntityPlayerMP)player);
    }

    public void sendRenderToAllPlayers() {
        if (this.WORLD.field_72995_K) {
            return;
        }
        ContainmentRenderPacket packet = this.getRenderPacket();
        if (packet == null) {
            return;
        }
        QMDPacketHandler.instance.sendToAll((IMessage)packet);
    }

    public void sendUpdateToListeningPlayers() {
        VacuumChamberUpdatePacket packet = this.getUpdatePacket();
        if (packet == null) {
            return;
        }
        for (EntityPlayer player : this.playersToUpdate) {
            QMDPacketHandler.instance.sendTo((IMessage)this.getUpdatePacket(), (EntityPlayerMP)player);
        }
    }

    public void sendIndividualUpdate(EntityPlayer player) {
        if (this.WORLD.field_72995_K) {
            return;
        }
        VacuumChamberUpdatePacket packet = this.getUpdatePacket();
        if (packet == null) {
            return;
        }
        QMDPacketHandler.instance.sendTo((IMessage)this.getUpdatePacket(), (EntityPlayerMP)player);
    }

    public void sendUpdateToAllPlayers() {
        if (this.WORLD.field_72995_K) {
            return;
        }
        VacuumChamberUpdatePacket packet = this.getUpdatePacket();
        if (packet == null) {
            return;
        }
        QMDPacketHandler.instance.sendToAll((IMessage)this.getUpdatePacket());
    }

    public ContainerMultiblockController<VacuumChamber, IVacuumChamberController> getContainer(EntityPlayer player) {
        return this.logic.getContainer(player);
    }

    public void clearAllMaterial() {
        this.logic.clearAllMaterial();
        super.clearAllMaterial();
        if (!this.WORLD.field_72995_K) {
            this.updateActivity();
        }
    }

    protected boolean isBlockGoodForInterior(World world, BlockPos pos) {
        return this.logic.isBlockGoodForInterior(world, pos);
    }

    @Override
    public List<Tank> getTanks() {
        return this.tanks;
    }
}

