/*
 * Decompiled with CFR 0.152.
 */
package lach_01298.qmd.vacuumChamber.tile;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import lach_01298.qmd.enums.BlockTypes;
import lach_01298.qmd.vacuumChamber.HeaterPlacement;
import lach_01298.qmd.vacuumChamber.VacuumChamber;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberComponent;
import lach_01298.qmd.vacuumChamber.tile.IVacuumChamberPart;
import lach_01298.qmd.vacuumChamber.tile.TileVacuumChamberPart;
import nc.multiblock.Multiblock;
import nc.multiblock.PlacementRule;
import nc.multiblock.cuboidal.CuboidalMultiblock;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.tile.ITileMultiblockPart;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;

public class TileVacuumChamberHeater
extends TileVacuumChamberPart
implements IVacuumChamberComponent {
    public String name;
    public int coolingRate;
    public String ruleID;
    public PlacementRule<IVacuumChamberPart> placementRule;
    public boolean isSearched = false;
    public boolean isInValidPosition = false;

    public TileVacuumChamberHeater() {
        super(CuboidalPartPositionType.INTERIOR);
    }

    public TileVacuumChamberHeater(String name, int coolingRate, String ruleID) {
        this();
        this.name = name;
        this.coolingRate = coolingRate;
        this.ruleID = ruleID;
        this.placementRule = (PlacementRule)HeaterPlacement.RULE_MAP.get((Object)ruleID);
    }

    protected TileVacuumChamberHeater(String name, int coolingRate) {
        this(name, coolingRate, name + "_heater");
    }

    public void onMachineAssembled(VacuumChamber controller) {
        this.doStandardNullControllerResponse((Multiblock)controller);
        super.onMachineAssembled((CuboidalMultiblock)controller);
    }

    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Override
    public boolean isFunctional() {
        return this.isInValidPosition;
    }

    @Override
    public void setFunctional(boolean functional) {
        this.isInValidPosition = false;
    }

    @Override
    public int getMaxOperatingTemp() {
        return 400;
    }

    public void coolerSearch(ObjectSet<TileVacuumChamberHeater> validCache, ObjectSet<TileVacuumChamberHeater> searchCache, Long2ObjectMap<TileVacuumChamberHeater> partFailCache, Long2ObjectMap<TileVacuumChamberHeater> assumedValidCache) {
        if (!this.isHeaterValid(partFailCache, assumedValidCache)) {
            return;
        }
        if (this.isSearched) {
            return;
        }
        this.isSearched = true;
        validCache.add((Object)this);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            TileVacuumChamberHeater part = (TileVacuumChamberHeater)((VacuumChamber)this.getMultiblock()).getPartMap(TileVacuumChamberHeater.class).get(this.getTilePos().func_177972_a(dir).func_177986_g());
            if (part == null) continue;
            searchCache.add((Object)part);
        }
    }

    public boolean isHeaterValid(Long2ObjectMap<TileVacuumChamberHeater> partFailCache, Long2ObjectMap<TileVacuumChamberHeater> assumedValidCache) {
        if (partFailCache.containsKey(this.field_174879_c.func_177986_g())) {
            this.isInValidPosition = false;
            return false;
        }
        if (this.placementRule.requiresRecheck()) {
            this.isInValidPosition = this.placementRule.satisfied((ITileMultiblockPart)this);
            if (this.isInValidPosition) {
                assumedValidCache.put(this.field_174879_c.func_177986_g(), (Object)this);
            }
            return this.isInValidPosition;
        }
        if (this.isInValidPosition) {
            return true;
        }
        this.isInValidPosition = this.placementRule.satisfied((ITileMultiblockPart)this);
        return this.isInValidPosition;
    }

    public boolean isSearchRoot() {
        for (String dep : this.placementRule.getDependencies()) {
            if (!dep.equals("beam") && !dep.equals("vacuum_chamber_casing") && !dep.equals("plasma_glass") && !dep.equals("nozzle")) continue;
            return true;
        }
        return false;
    }

    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74778_a("name", this.name);
        nbt.func_74768_a("coolingRate", this.coolingRate);
        nbt.func_74778_a("ruleID", this.ruleID);
        return nbt;
    }

    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        if (nbt.func_74764_b("name")) {
            this.name = nbt.func_74779_i("name");
        }
        if (nbt.func_74764_b("coolingRate")) {
            this.coolingRate = nbt.func_74762_e("coolingRate");
        }
        if (nbt.func_74764_b("ruleID")) {
            this.ruleID = nbt.func_74779_i("ruleID");
            this.placementRule = (PlacementRule)HeaterPlacement.RULE_MAP.get((Object)this.ruleID);
        }
    }

    @Override
    public int getHeating() {
        return 0;
    }

    @Override
    public int getPower() {
        return 0;
    }

    public static class Diamond
    extends TileVacuumChamberHeater {
        public Diamond() {
            super("diamond", BlockTypes.HeaterType.DIAMOND.getHeatRemoved());
        }
    }

    public static class Gold
    extends TileVacuumChamberHeater {
        public Gold() {
            super("gold", BlockTypes.HeaterType.GOLD.getHeatRemoved());
        }
    }

    public static class Lapis
    extends TileVacuumChamberHeater {
        public Lapis() {
            super("lapis", BlockTypes.HeaterType.LAPIS.getHeatRemoved());
        }
    }

    public static class Glowstone
    extends TileVacuumChamberHeater {
        public Glowstone() {
            super("glowstone", BlockTypes.HeaterType.GLOWSTONE.getHeatRemoved());
        }
    }

    public static class Obsidian
    extends TileVacuumChamberHeater {
        public Obsidian() {
            super("obsidian", BlockTypes.HeaterType.OBSIDIAN.getHeatRemoved());
        }
    }

    public static class Quartz
    extends TileVacuumChamberHeater {
        public Quartz() {
            super("quartz", BlockTypes.HeaterType.QUARTZ.getHeatRemoved());
        }
    }

    public static class Redstone
    extends TileVacuumChamberHeater {
        public Redstone() {
            super("redstone", BlockTypes.HeaterType.REDSTONE.getHeatRemoved());
        }
    }

    public static class Iron
    extends TileVacuumChamberHeater {
        public Iron() {
            super("iron", BlockTypes.HeaterType.IRON.getHeatRemoved());
        }
    }
}

