/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.desirepaths;

import CoroUtil.forge.CULog;
import CoroUtil.util.CoroUtilPlayer;
import CoroUtil.util.Vec3;
import com.corosus.desirepaths.ai.EntityAIEatGrassExtended;
import com.corosus.desirepaths.block.BlockGrassWorn;
import com.corosus.desirepaths.config.ConfigDesirePaths;
import com.corosus.desirepaths.config.ConfigDesirePathsDeveloper;
import com.corosus.desirepaths.util.UtilEntityBuffsInstances;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EventHandlerForge {
    private static Class<?> animaniaSheepClass;

    @SubscribeEvent
    public void onEntityCreatedOrLoaded(EntityJoinWorldEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (event.getEntity() instanceof EntitySheep && (animaniaSheepClass == null || !animaniaSheepClass.isAssignableFrom(event.getEntity().getClass()))) {
            EntitySheep ent = (EntitySheep)event.getEntity();
            EntityAIEatGrassExtended task = new EntityAIEatGrassExtended((EntityLiving)ent);
            UtilEntityBuffsInstances.replaceTaskIfMissing((EntityCreature)ent, EntityAIEatGrass.class, (EntityAIBase)task);
            ent.field_146087_bs = task;
        }
    }

    @SubscribeEvent
    public void entityTick(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase ent = event.getEntityLiving();
        int walkOnRate = 5;
        if (!ent.field_70170_p.field_72995_K && ConfigDesirePaths.pathsWearDown && ent.field_70122_E && ent.field_70170_p.func_82737_E() % (long)walkOnRate == 0L) {
            double speed = Math.sqrt(ent.field_70159_w * ent.field_70159_w + ent.field_70181_x * ent.field_70181_x + ent.field_70179_y * ent.field_70179_y);
            if (ent instanceof EntityPlayer) {
                Vec3 vec = CoroUtilPlayer.getPlayerSpeedCapped((EntityPlayer)((EntityPlayer)ent), (float)0.1f);
                speed = Math.sqrt(vec.xCoord * vec.xCoord + vec.yCoord * vec.yCoord + vec.zCoord * vec.zCoord);
            }
            if (speed > 0.08) {
                int newX = MathHelper.func_76128_c((double)ent.field_70165_t);
                int newY = MathHelper.func_76128_c((double)(ent.func_174813_aQ().field_72338_b - 1.0));
                int newZ = MathHelper.func_76128_c((double)ent.field_70161_v);
                BlockPos pos = new BlockPos(newX, newY, newZ);
                float amp = 1.0f * (float)ConfigDesirePathsDeveloper.pathWalkWearAmplifier;
                if (ent instanceof EntitySheep) {
                    amp = (float)Math.max(ConfigDesirePaths.sheepPathWearAmplifier, 0.0);
                }
                if (amp != 0.0f) {
                    BlockGrassWorn.performWearTick(ent.field_70170_p, pos, amp);
                }
            }
        }
    }

    static {
        try {
            animaniaSheepClass = Loader.isModLoaded((String)"animania") ? Class.forName("com.animania.common.entities.sheep.EntityAnimaniaSheep") : null;
        }
        catch (ClassNotFoundException e) {
            CULog.err((String)"ERROR getting animania base sheep class, mod might have changed it, needs updating in DesirePaths");
            e.printStackTrace();
        }
    }
}

