/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.desirepaths.block;

import CoroUtil.forge.CULog;
import CoroUtil.world.WorldDirectorManager;
import CoroUtil.world.grid.block.BlockDataPoint;
import com.corosus.desirepaths.DesirePaths;
import com.corosus.desirepaths.config.ConfigDesirePaths;
import com.corosus.desirepaths.config.ConfigDesirePathsDeveloper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGrassWorn
extends Block
implements IGrowable {
    public static List<Block> listDegradeProgression = new ArrayList<Block>();
    public static HashMap<Integer, Block> lookupStageToBlock = new HashMap();
    public static HashMap<Block, Integer> lookupBlockToStage = new HashMap();

    public BlockGrassWorn() {
        super(Material.field_151577_b);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149675_a(true);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149713_g(255);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185849_b);
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        BlockDataPoint bdp;
        super.func_176206_d(worldIn, pos, state);
        if (!worldIn.field_72995_K && (bdp = WorldDirectorManager.instance().getBlockDataGrid(worldIn).getBlockData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) != null) {
            bdp.walkedOnAmount = 0.0f;
            bdp.lastTickTimeGrass = 0L;
            WorldDirectorManager.instance().getBlockDataGrid(worldIn).removeBlockDataIfRemovable(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public static void performWearTick(World world, BlockPos pos, float wearAmplifier) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        int index = -1;
        if (lookupBlockToStage.containsKey(block)) {
            index = lookupBlockToStage.get(block);
        }
        if (index == -1 || index == lookupBlockToStage.size() - 1) {
            return;
        }
        BlockDataPoint bdp = WorldDirectorManager.instance().getBlockDataGrid(world).getBlockData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        bdp.walkedOnAmount += 0.05f * wearAmplifier;
        bdp.lastTickTimeGrass = world.func_82737_E();
        if (bdp.walkedOnAmount > 1.0f) {
            BlockGrassWorn.decaySlowly(world, block, pos);
            bdp.walkedOnAmount = 0.1f;
            WorldDirectorManager.instance().getBlockDataGrid(world).removeBlockDataIfRemovable(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            long curTickTime = worldIn.func_82737_E();
            BlockDataPoint bdp = WorldDirectorManager.instance().getBlockDataGrid(worldIn).getBlockData(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            long lastTickTimeGrass = bdp.lastTickTimeGrass;
            bdp.lastTickTimeGrass = curTickTime;
            if (ConfigDesirePaths.pathsRepair && worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
                for (int i = 0; i < 4; ++i) {
                    IBlockState iblockstate1;
                    Block block;
                    BlockPos blockpos = pos.func_177982_a(rand.nextInt(3) - 1, rand.nextInt(3) - 1, rand.nextInt(3) - 1);
                    if (blockpos.func_177956_o() >= 0 && blockpos.func_177956_o() < 256 && !worldIn.func_175667_e(blockpos) || ((block = (iblockstate1 = worldIn.func_180495_p(blockpos)).func_177230_c()) != Blocks.field_150349_c || worldIn.func_180495_p(blockpos.func_177984_a()).func_177230_c() instanceof BlockGrassWorn) && block != DesirePaths.dirt_1 && block != DesirePaths.dirt_2 && block != DesirePaths.dirt_3) continue;
                    long timeSinceLastTick = curTickTime - lastTickTimeGrass;
                    long timeTo1StageOfRegrowth = 216000L;
                    if (state.func_177230_c() == DesirePaths.dirt_1) {
                        timeTo1StageOfRegrowth = 36000L;
                    } else if (state.func_177230_c() == DesirePaths.dirt_2) {
                        timeTo1StageOfRegrowth = 72000L;
                    } else if (state.func_177230_c() == DesirePaths.dirt_3) {
                        timeTo1StageOfRegrowth = 144000L;
                    }
                    float oneStageOfRegrowth = 1.0f;
                    float scale = (float)timeSinceLastTick / (float)timeTo1StageOfRegrowth;
                    if (!ConfigDesirePaths.useWorldTimePassedForPathRepair) {
                        scale = (float)ConfigDesirePathsDeveloper.repairAmountPerRandomTickNonTimeSimulated;
                    }
                    float amountToAdjust = oneStageOfRegrowth * scale * (float)Math.max(ConfigDesirePathsDeveloper.pathRepairAmplifier, 0.0);
                    bdp.walkedOnAmount -= amountToAdjust;
                    if (!(bdp.walkedOnAmount <= 0.0f)) break;
                    BlockGrassWorn.growSlowly(worldIn, state.func_177230_c(), pos);
                    bdp.walkedOnAmount = 0.9f;
                    IBlockState stateNew = worldIn.func_180495_p(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()));
                    if (stateNew.func_177230_c() != Blocks.field_150349_c) break;
                    BlockPos posUp = pos.func_177984_a();
                    if (ConfigDesirePaths.chanceToRegrowDoubleGrass > 0.0 && rand.nextDouble() < ConfigDesirePaths.chanceToRegrowDoubleGrass) {
                        if (Blocks.field_150398_cm.func_176196_c(worldIn, posUp)) {
                            Blocks.field_150398_cm.func_176491_a(worldIn, posUp, BlockDoublePlant.EnumPlantType.GRASS, 3);
                        }
                    } else if (ConfigDesirePaths.chanceToRegrowTallGrass > 0.0 && rand.nextDouble() < ConfigDesirePaths.chanceToRegrowTallGrass && Blocks.field_150329_H.func_176196_c(worldIn, posUp)) {
                        worldIn.func_175656_a(posUp, Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS));
                    }
                    bdp.lastTickTimeGrass = 0L;
                    WorldDirectorManager.instance().getBlockDataGrid(worldIn).removeBlockDataIfRemovable(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    break;
                }
            }
        }
    }

    public static void growSlowly(World worldIn, Block blockFrom, BlockPos pos) {
        Block blockNext;
        int stage = -1;
        if (lookupBlockToStage.containsKey(blockFrom)) {
            stage = lookupBlockToStage.get(blockFrom);
        }
        if (stage != -1 && (blockNext = lookupStageToBlock.get(stage - 1)) != null) {
            worldIn.func_175656_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), blockNext.func_176223_P());
        }
    }

    public static void decaySlowly(World worldIn, Block blockFrom, BlockPos pos) {
        Block blockNext;
        int stage = -1;
        if (lookupBlockToStage.containsKey(blockFrom)) {
            stage = lookupBlockToStage.get(blockFrom);
        }
        if (stage != -1 && (blockNext = lookupStageToBlock.get(stage + 1)) != null) {
            IBlockState stateNext = blockNext.func_176223_P();
            if (blockNext == DesirePaths.dirt_6) {
                try {
                    String[] str = ConfigDesirePaths.blockFinalWornStage.split(" ");
                    int meta = 0;
                    Block blockNextOverride = Block.func_149684_b((String)str[0]);
                    if (blockNextOverride != null) {
                        if (str.length > 1) {
                            meta = Integer.valueOf(str[1]);
                        }
                        stateNext = blockNextOverride.func_176203_a(meta);
                    } else {
                        CULog.err((String)("could not parse to block from this string: " + str[0]));
                    }
                }
                catch (Exception ex) {
                    CULog.err((String)("incorrect use of blockToSetForFullDirt, " + ex.toString()));
                }
            }
            worldIn.func_175656_a(new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()), stateNext);
        }
    }

    @Nullable
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Blocks.field_150346_d.func_180660_a(Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.DIRT), rand, fortune);
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        worldIn.func_175656_a(pos, Blocks.field_150349_c.func_176223_P());
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        if (!worldIn.field_72995_K) {
            BlockGrassWorn.performWearTick(worldIn, pos, 10.0f);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn != null && !worldIn.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(hand);
            if (playerIn.func_175151_a(pos.func_177972_a(facing), facing, stack)) {
                if (stack.func_77973_b() instanceof ItemSpade) {
                    worldIn.func_175656_a(pos, Blocks.field_185774_da.func_176223_P());
                    worldIn.func_184133_a(playerIn, pos, SoundEvents.field_187771_eN, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    stack.func_77972_a(1, (EntityLivingBase)playerIn);
                    return true;
                }
                if (stack.func_77973_b() instanceof ItemHoe) {
                    worldIn.func_175656_a(pos, Blocks.field_150458_ak.func_176223_P());
                    stack.func_77972_a(1, (EntityLivingBase)playerIn);
                    return true;
                }
            }
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        if (super.canSustainPlant(state, world, pos, direction, plantable)) {
            return true;
        }
        if (state.func_177230_c() == DesirePaths.dirt_1 || state.func_177230_c() == DesirePaths.dirt_2 || state.func_177230_c() == DesirePaths.dirt_3) {
            EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
            if (plantType == EnumPlantType.Plains) {
                return true;
            }
            if (plantType == EnumPlantType.Beach) {
                return world.func_180495_p(pos.func_177974_f()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177976_e()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177978_c()).func_185904_a() == Material.field_151586_h || world.func_180495_p(pos.func_177968_d()).func_185904_a() == Material.field_151586_h;
            }
        }
        return false;
    }

    public boolean isToolEffective(String type, IBlockState state) {
        if (type.equals("shovel")) {
            return true;
        }
        return super.isToolEffective(type, state);
    }
}

