/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.provided.book.context;

import com.teamwizardry.librarianlib.features.eventbus.Event;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponent;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.facade.component.GuiLayerEvents;
import com.teamwizardry.librarianlib.features.facade.components.ComponentSprite;
import com.teamwizardry.librarianlib.features.facade.components.ComponentText;
import com.teamwizardry.librarianlib.features.facade.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.facade.provided.book.context.BookContext;
import com.teamwizardry.librarianlib.features.facade.provided.book.context.EventNavBarChange;
import com.teamwizardry.librarianlib.features.sprite.Sprite;
import java.awt.Color;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u000b\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/context/ComponentNavBar;", "Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;", "book", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;", "posX", "", "posY", "width", "(Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;III)V", "maxPage", "getMaxPage", "()I", "nextSprite", "Lcom/teamwizardry/librarianlib/features/sprite/Sprite;", "target", "page", "getPage", "setPage", "(I)V", "librarianlib-1.12.2"})
public final class ComponentNavBar
extends GuiComponent {
    private final Sprite nextSprite;
    private final IBookGui book;

    public final int getMaxPage() {
        return this.book.getContext().getPages().size() - 1;
    }

    public final int getPage() {
        return this.book.getContext().getPosition();
    }

    public final void setPage(int target) {
        int x2 = MathHelper.func_76125_a((int)target, (int)0, (int)this.getMaxPage());
        if (this.getPage() == x2) {
            return;
        }
        EventNavBarChange eventNavBarChange = new EventNavBarChange(this.getPage());
        this.BUS.fire((Event)eventNavBarChange);
        this.book.changePage(x2);
    }

    public ComponentNavBar(@NotNull IBookGui book, int posX, int posY, int width) {
        Intrinsics.checkParameterIsNotNull(book, "book");
        super(posX, posY, width, 20);
        this.book = book;
        this.BUS.hook(GuiLayerEvents.Tick.class, (Function1)new Function1<GuiLayerEvents.Tick, Unit>(){

            @Override
            public final void invoke(@NotNull GuiLayerEvents.Tick it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                this.setVisible(this.getMaxPage() > 0 || book.getContext().getParent() != null);
            }
        });
        Sprite backSprite = this.book.getBackSprite();
        Sprite homeSprite = this.book.getHomeSprite();
        this.nextSprite = this.book.getNextSprite();
        final ComponentSprite back = new ComponentSprite(backSprite, 0, (int)(this.getSize().getY() / 2.0 - (double)backSprite.getHeight() / 2.0), 0, 0, 24, null);
        final ComponentSprite home = new ComponentSprite(homeSprite, (int)(this.getSize().getX() / 2.0 - (double)homeSprite.getWidth() / 2.0), (int)(this.getSize().getY() / 2.0 - (double)backSprite.getHeight() / 2.0), 0, 0, 24, null);
        final ComponentSprite next = new ComponentSprite(this.nextSprite, (int)(this.getSize().getX() - (double)this.nextSprite.getWidth()), (int)(this.getSize().getY() / 2.0 - (double)this.nextSprite.getHeight() / 2.0), 0, 0, 24, null);
        this.add(back, next, home);
        home.BUS.hook(GuiComponentEvents.MouseMoveInEvent.class, (Function1)new Function1<GuiComponentEvents.MouseMoveInEvent, Unit>(){

            @Override
            public final void invoke(@NotNull GuiComponentEvents.MouseMoveInEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                home.setSprite(book.getHomeSpritePressed());
                Color color2 = book.getBook().getBookColor().brighter();
                Intrinsics.checkExpressionValueIsNotNull(color2, "book.book.bookColor.brighter()");
                home.setColor(color2);
            }
        });
        home.BUS.hook(GuiComponentEvents.MouseMoveOutEvent.class, (Function1)new Function1<GuiComponentEvents.MouseMoveOutEvent, Unit>(){

            @Override
            public final void invoke(@NotNull GuiComponentEvents.MouseMoveOutEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                home.setSprite(book.getHomeSprite());
                Color color2 = Color.WHITE;
                Intrinsics.checkExpressionValueIsNotNull(color2, "Color.WHITE");
                home.setColor(color2);
            }
        });
        ArrayList<String> homeTooltip = new ArrayList<String>();
        homeTooltip.add(I18n.func_135052_a((String)"librarianlib.book.nav.back", (Object[])new Object[0]));
        home.BUS.hook(GuiComponentEvents.MouseClickEvent.class, (Function1)new Function1<GuiComponentEvents.MouseClickEvent, Unit>(){

            @Override
            public final void invoke(@NotNull GuiComponentEvents.MouseClickEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (GuiScreen.func_146272_n()) {
                    book.focusOn(new BookContext(book, book.getBook().createComponents(book), book.getBook(), book.getBook().addAllBookmarks(null), book.getContext()));
                } else {
                    book.up();
                }
            }
        });
        home.BUS.hook(GuiLayerEvents.Tick.class, (Function1)new Function1<GuiLayerEvents.Tick, Unit>(){

            @Override
            public final void invoke(@NotNull GuiLayerEvents.Tick it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                home.setVisible(book.getContext().getParent() != null);
            }
        });
        back.BUS.hook(GuiLayerEvents.Tick.class, (Function1)new Function1<GuiLayerEvents.Tick, Unit>(){

            @Override
            public final void invoke(@NotNull GuiLayerEvents.Tick it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                int x2 = MathHelper.func_76125_a((int)(this.getPage() - 1), (int)0, (int)this.getMaxPage());
                back.setVisible(this.getPage() != x2);
                if (back.isVisible()) {
                    if (back.getMouseOver()) {
                        back.setSprite(book.getBackSpritePressed());
                        Color color2 = book.getBook().getBookColor().brighter();
                        Intrinsics.checkExpressionValueIsNotNull(color2, "book.book.bookColor.brighter()");
                        back.setColor(color2);
                    } else {
                        back.setSprite(book.getBackSprite());
                        Color color3 = Color.WHITE;
                        Intrinsics.checkExpressionValueIsNotNull(color3, "Color.WHITE");
                        back.setColor(color3);
                    }
                }
            }
        });
        back.BUS.hook(GuiComponentEvents.MouseClickEvent.class, (Function1)new Function1<GuiComponentEvents.MouseClickEvent, Unit>(){

            @Override
            public final void invoke(@NotNull GuiComponentEvents.MouseClickEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (GuiScreen.func_146272_n()) {
                    this.setPage(0);
                } else {
                    ComponentNavBar componentNavBar = this;
                    int n = componentNavBar.getPage();
                    componentNavBar.setPage(n + -1);
                }
            }
        });
        ArrayList<String> backTooltip = new ArrayList<String>();
        backTooltip.add(I18n.func_135052_a((String)"librarianlib.book.nav.previous", (Object[])new Object[0]));
        next.BUS.hook(GuiLayerEvents.Tick.class, (Function1)new Function1<GuiLayerEvents.Tick, Unit>(){

            @Override
            public final void invoke(@NotNull GuiLayerEvents.Tick event) {
                Intrinsics.checkParameterIsNotNull(event, "event");
                int x2 = MathHelper.func_76125_a((int)(this.getPage() + 1), (int)0, (int)this.getMaxPage());
                next.setVisible(this.getPage() != x2);
                if (next.isVisible()) {
                    if (next.getMouseOver()) {
                        Color color2 = book.getBook().getBookColor().brighter();
                        Intrinsics.checkExpressionValueIsNotNull(color2, "book.book.bookColor.brighter()");
                        next.setColor(color2);
                        next.setSprite(book.getNextSpritePressed());
                    } else {
                        Color color3 = Color.WHITE;
                        Intrinsics.checkExpressionValueIsNotNull(color3, "Color.WHITE");
                        next.setColor(color3);
                        next.setSprite(book.getNextSprite());
                    }
                }
            }
        });
        next.BUS.hook(GuiComponentEvents.MouseClickEvent.class, (Function1)new Function1<GuiComponentEvents.MouseClickEvent, Unit>(){

            @Override
            public final void invoke(@NotNull GuiComponentEvents.MouseClickEvent it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                if (GuiScreen.func_146272_n()) {
                    this.setPage(this.getMaxPage());
                } else {
                    ComponentNavBar componentNavBar = this;
                    int n = componentNavBar.getPage();
                    componentNavBar.setPage(n + 1);
                }
            }
        });
        ArrayList<String> nextTooltip = new ArrayList<String>();
        nextTooltip.add(I18n.func_135052_a((String)"librarianlib.book.nav.next", (Object[])new Object[0]));
        final ComponentText pageStringComponent = new ComponentText((int)this.getSize().getX() / 2, (int)(this.getSize().getY() / (double)2 - (double)this.nextSprite.getHeight() / 2.0) + 15, ComponentText.TextAlignH.CENTER, ComponentText.TextAlignV.MIDDLE);
        pageStringComponent.setUnicode(false);
        pageStringComponent.getText_im().invoke(new Function0<String>(){

            @Override
            @NotNull
            public final String invoke() {
                return "" + (this.getPage() + 1) + '/' + (this.getMaxPage() + 1);
            }
        });
        pageStringComponent.BUS.hook(GuiLayerEvents.Tick.class, (Function1)new Function1<GuiLayerEvents.Tick, Unit>(){

            @Override
            public final void invoke(@NotNull GuiLayerEvents.Tick it) {
                Intrinsics.checkParameterIsNotNull(it, "it");
                pageStringComponent.setVisible(this.getMaxPage() > 0);
            }
        });
        this.add(pageStringComponent);
    }
}

