/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math.coordinatespaces;

import com.teamwizardry.librarianlib.features.math.Matrix3;
import com.teamwizardry.librarianlib.features.math.Rect2d;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.librarianlib.features.math.coordinatespaces.UnrelatedCoordinateSpaceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmDefault;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000H\u0017J\u0010\u0010\r\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000H\u0017J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0000H\u0017J\u0010\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0017J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0000H\u0017J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0017J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0000H\u0017J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0017J\u0018\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u0000H\u0017J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0017J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0002J\u0010\u0010\u001b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0000H\u0002J\u0010\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0000H\u0002R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\u0005R\u0014\u0010\b\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u0091(0\u0001\u00a8\u0006\u001e"}, d2={"Lcom/teamwizardry/librarianlib/features/math/coordinatespaces/CoordinateSpace2D;", "", "inverseMatrix", "Lcom/teamwizardry/librarianlib/features/math/Matrix3;", "getInverseMatrix", "()Lcom/teamwizardry/librarianlib/features/math/Matrix3;", "matrix", "getMatrix", "parentSpace", "getParentSpace", "()Lcom/teamwizardry/librarianlib/features/math/coordinatespaces/CoordinateSpace2D;", "conversionMatrixFrom", "other", "conversionMatrixTo", "convertPointFrom", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "point", "convertPointFromParent", "convertPointTo", "convertPointToParent", "convertRectFrom", "Lcom/teamwizardry/librarianlib/features/math/Rect2d;", "rect", "convertRectFromParent", "convertRectTo", "convertRectToParent", "lowestCommonAncestor", "matrixFromParent", "matrixToParent", "parent", "librarianlib-1.12.2"})
public interface CoordinateSpace2D {
    @Nullable
    public CoordinateSpace2D getParentSpace();

    @NotNull
    public Matrix3 getMatrix();

    @NotNull
    public Matrix3 getInverseMatrix();

    @JvmDefault
    @NotNull
    default public Matrix3 conversionMatrixTo(@NotNull CoordinateSpace2D other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        if (other == this) {
            return Matrix3.identity;
        }
        if (other == this.getParentSpace()) {
            return this.getMatrix().copy();
        }
        if (other.getParentSpace() == this) {
            return other.getInverseMatrix().copy();
        }
        CoordinateSpace2D coordinateSpace2D = DefaultImpls.lowestCommonAncestor(this, other);
        if (coordinateSpace2D == null) {
            throw (Throwable)new UnrelatedCoordinateSpaceException(this, other);
        }
        CoordinateSpace2D lca = coordinateSpace2D;
        if (lca == other) {
            return DefaultImpls.matrixToParent(this, other);
        }
        if (lca == this) {
            return DefaultImpls.matrixFromParent(other, this);
        }
        Matrix3 matrix = new Matrix3();
        matrix.timesAssign(DefaultImpls.matrixFromParent(other, lca));
        matrix.timesAssign(DefaultImpls.matrixToParent(this, lca));
        return matrix;
    }

    @JvmDefault
    @NotNull
    default public Matrix3 conversionMatrixFrom(@NotNull CoordinateSpace2D other) {
        Intrinsics.checkParameterIsNotNull(other, "other");
        return other.conversionMatrixTo(this);
    }

    @JvmDefault
    @NotNull
    default public Vec2d convertPointTo(@NotNull Vec2d point, @NotNull CoordinateSpace2D other) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return this.conversionMatrixTo(other).times(point);
    }

    @JvmDefault
    @NotNull
    default public Vec2d convertPointFrom(@NotNull Vec2d point, @NotNull CoordinateSpace2D other) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return other.convertPointTo(point, this);
    }

    /*
     * WARNING - void declaration
     */
    @JvmDefault
    @NotNull
    default public Rect2d convertRectTo(@NotNull Rect2d rect, @NotNull CoordinateSpace2D other) {
        void x$iv;
        void x$iv2;
        Intrinsics.checkParameterIsNotNull(rect, "rect");
        Intrinsics.checkParameterIsNotNull(other, "other");
        Vec2d min = rect.getMin();
        Vec2d max = rect.getMax();
        double d = min.getX();
        double y$iv = max.getY();
        Vec2d minmax = Vec2d.Companion.getPooled((double)x$iv2, y$iv);
        y$iv = max.getX();
        double y$iv2 = min.getY();
        Vec2d maxmin = Vec2d.Companion.getPooled((double)x$iv, y$iv2);
        Matrix3 matrix = this.conversionMatrixTo(other);
        min = matrix.times(min);
        max = matrix.times(max);
        minmax = matrix.times(minmax);
        maxmin = matrix.times(maxmin);
        Vec2d pos2 = Vec2d.Companion.min(Vec2d.Companion.min(min, max), Vec2d.Companion.min(minmax, maxmin));
        Vec2d size2 = Vec2d.Companion.max(Vec2d.Companion.max(min, max), Vec2d.Companion.max(minmax, maxmin)).minus(pos2);
        return new Rect2d(pos2, size2);
    }

    @JvmDefault
    @NotNull
    default public Rect2d convertRectFrom(@NotNull Rect2d rect, @NotNull CoordinateSpace2D other) {
        Intrinsics.checkParameterIsNotNull(rect, "rect");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return other.convertRectTo(rect, this);
    }

    @JvmDefault
    @NotNull
    default public Vec2d convertPointToParent(@NotNull Vec2d point) {
        CoordinateSpace2D coordinateSpace2D;
        CoordinateSpace2D it;
        Intrinsics.checkParameterIsNotNull(point, "point");
        Object object = this.getParentSpace();
        if (object == null || (object = this.convertPointTo(point, it = (coordinateSpace2D = object))) == null) {
            object = point;
        }
        return object;
    }

    @JvmDefault
    @NotNull
    default public Vec2d convertPointFromParent(@NotNull Vec2d point) {
        CoordinateSpace2D coordinateSpace2D;
        CoordinateSpace2D it;
        Intrinsics.checkParameterIsNotNull(point, "point");
        Object object = this.getParentSpace();
        if (object == null || (object = this.convertPointFrom(point, it = (coordinateSpace2D = object))) == null) {
            object = point;
        }
        return object;
    }

    @JvmDefault
    @NotNull
    default public Rect2d convertRectToParent(@NotNull Rect2d rect) {
        CoordinateSpace2D coordinateSpace2D;
        CoordinateSpace2D it;
        Intrinsics.checkParameterIsNotNull(rect, "rect");
        Object object = this.getParentSpace();
        if (object == null || (object = this.convertRectTo(rect, it = (coordinateSpace2D = object))) == null) {
            object = rect;
        }
        return object;
    }

    @JvmDefault
    @NotNull
    default public Rect2d convertRectFromParent(@NotNull Rect2d rect) {
        CoordinateSpace2D coordinateSpace2D;
        CoordinateSpace2D it;
        Intrinsics.checkParameterIsNotNull(rect, "rect");
        Object object = this.getParentSpace();
        if (object == null || (object = this.convertRectFrom(rect, it = (coordinateSpace2D = object))) == null) {
            object = rect;
        }
        return object;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=3)
    public static final class DefaultImpls {
        private static CoordinateSpace2D lowestCommonAncestor(CoordinateSpace2D $this, CoordinateSpace2D other) {
            CoordinateSpace2D ancestor;
            CoordinateSpace2D thisAncestor = $this.getParentSpace();
            CoordinateSpace2D otherAncestor = other.getParentSpace();
            while (thisAncestor != null || otherAncestor != null) {
                if (thisAncestor == other) {
                    return other;
                }
                if (otherAncestor == $this) {
                    return $this;
                }
                CoordinateSpace2D coordinateSpace2D = thisAncestor;
                thisAncestor = coordinateSpace2D != null ? coordinateSpace2D.getParentSpace() : null;
                CoordinateSpace2D coordinateSpace2D2 = otherAncestor;
                otherAncestor = coordinateSpace2D2 != null ? coordinateSpace2D2.getParentSpace() : null;
            }
            Set<CoordinateSpace2D> set = Collections.newSetFromMap(new IdentityHashMap());
            Intrinsics.checkExpressionValueIsNotNull(set, "Collections.newSetFromMa\u2026ace2D>(IdentityHashMap())");
            Set<CoordinateSpace2D> ancestors = set;
            for (ancestor = $this.getParentSpace(); ancestor != null; ancestor = ancestor.getParentSpace()) {
                ancestors.add(ancestor);
            }
            for (ancestor = other.getParentSpace(); ancestor != null; ancestor = ancestor.getParentSpace()) {
                if (!ancestors.contains(ancestor)) continue;
                return ancestor;
            }
            return null;
        }

        private static Matrix3 matrixToParent(CoordinateSpace2D $this, CoordinateSpace2D parent2) {
            List ancestors = new ArrayList();
            CoordinateSpace2D space = $this;
            while (space != parent2) {
                ancestors.add(space);
                if (space.getParentSpace() != null) continue;
                Intrinsics.throwNpe();
            }
            Matrix3 matrix = new Matrix3();
            Iterable $receiver$iv = CollectionsKt.reversed(ancestors);
            for (Object element$iv : $receiver$iv) {
                CoordinateSpace2D it = (CoordinateSpace2D)element$iv;
                matrix.timesAssign(it.getMatrix());
            }
            return matrix;
        }

        private static Matrix3 matrixFromParent(CoordinateSpace2D $this, CoordinateSpace2D other) {
            List ancestors = new ArrayList();
            CoordinateSpace2D space = $this;
            while (space != other) {
                ancestors.add(space);
                if (space.getParentSpace() != null) continue;
                Intrinsics.throwNpe();
            }
            Matrix3 matrix = new Matrix3();
            Iterable $receiver$iv = ancestors;
            for (Object element$iv : $receiver$iv) {
                CoordinateSpace2D it = (CoordinateSpace2D)element$iv;
                matrix.timesAssign(it.getInverseMatrix());
            }
            return matrix;
        }
    }
}

