/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.function.IFunction;
import org.magicwerk.brownies.collections.function.IPredicate;
import org.magicwerk.brownies.collections.primitive.IntObjBigList;
import org.magicwerk.brownies.collections.primitive.IntObjGapList;

public abstract class IIntList
implements Cloneable,
Serializable {
    private static final int TRANSFER_COPY = 0;
    private static final int TRANSFER_MOVE = 1;
    private static final int TRANSFER_REMOVE = 2;

    static int[] toArray(Collection<Integer> coll) {
        Object[] values2 = coll.toArray();
        int[] v = new int[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            v[i] = (Integer)values2[i];
        }
        return v;
    }

    public IIntList copy() {
        return (IIntList)this.clone();
    }

    public abstract IIntList unmodifiableList();

    public Object clone() {
        try {
            IIntList list2 = (IIntList)super.clone();
            list2.doClone(this);
            return list2;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    protected abstract void doClone(IIntList var1);

    public void clear() {
        this.doClear();
    }

    protected void doClear() {
        this.doRemoveAll(0, this.size());
    }

    public void resize(int len, int elem) {
        this.checkLength(len);
        int size2 = this.size();
        if (len < size2) {
            this.remove(len, size2 - len);
        } else {
            for (int i = size2; i < len; ++i) {
                this.add(elem);
            }
        }
        assert (this.size() == len);
    }

    public abstract int size();

    public abstract int capacity();

    public int get(int index) {
        this.checkIndex(index);
        return this.doGet(index);
    }

    protected abstract int doGet(int var1);

    protected abstract int doSet(int var1, int var2);

    public int set(int index, int elem) {
        this.checkIndex(index);
        return this.doSet(index, elem);
    }

    public int put(int index, int elem) {
        this.checkIndexAdd(index);
        if (index < this.size()) {
            return this.doSet(index, elem);
        }
        this.doAdd(-1, elem);
        return 0;
    }

    protected abstract int doReSet(int var1, int var2);

    protected abstract int getDefaultElem();

    protected void doModify() {
    }

    public boolean add(int elem) {
        return this.doAdd(-1, elem);
    }

    public void add(int index, int elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    protected abstract boolean doAdd(int var1, int var2);

    public int remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    protected abstract int doRemove(int var1);

    public void ensureCapacity(int minCapacity) {
        this.doModify();
        this.doEnsureCapacity(minCapacity);
    }

    protected abstract void doEnsureCapacity(int var1);

    public abstract void trimToSize();

    public boolean equals(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof IntObjGapList) {
            obj = ((IntObjGapList)obj).list;
        } else if (obj instanceof IntObjBigList) {
            obj = ((IntObjBigList)obj).list;
        }
        if (!(obj instanceof IIntList)) {
            return false;
        }
        IIntList list2 = (IIntList)obj;
        int size2 = this.size();
        if (size2 != list2.size()) {
            return false;
        }
        for (int i = 0; i < size2; ++i) {
            if (IIntList.equalsElem(this.doGet(i), list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            int elem = this.doGet(i);
            hashCode = 31 * hashCode + IIntList.hashCodeElem(elem);
        }
        return hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("[");
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.doGet(i));
        }
        buf.append("]");
        return buf.toString();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    static boolean equalsElem(int elem1, int elem2) {
        return elem1 == elem2;
    }

    static int hashCodeElem(int elem) {
        return elem;
    }

    public int getCount(int elem) {
        int count = 0;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!IIntList.equalsElem(this.doGet(i), elem)) continue;
            ++count;
        }
        return count;
    }

    public IIntList getAll(int elem) {
        IIntList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            int e = this.doGet(i);
            if (!IIntList.equalsElem(e, elem)) continue;
            list2.add(e);
        }
        return list2;
    }

    public IIntList getWhere(IPredicate predicate) {
        IIntList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            int e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
        }
        return list2;
    }

    public void removeWhere(IPredicate predicate) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            int e = this.doGet(i);
            if (!predicate.test(e)) continue;
            this.doRemove(i);
            --size2;
            --i;
        }
    }

    public void retainWhere(IPredicate predicate) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            int e = this.doGet(i);
            if (predicate.test(e)) continue;
            this.doRemove(i);
            --size2;
            --i;
        }
    }

    public IIntList extractWhere(IPredicate predicate) {
        IIntList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            int e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
            this.doRemove(i);
            --size2;
            --i;
        }
        return list2;
    }

    public Set getDistinct() {
        HashSet<Integer> set = new HashSet<Integer>();
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            set.add(this.doGet(i));
        }
        return set;
    }

    public <R> IList<R> mappedList(IFunction<Integer, R> mapper) {
        int size2 = this.size();
        GapList<R> mappedList = new GapList<R>(size2);
        for (int i = 0; i < size2; ++i) {
            int e = this.doGet(i);
            ((IList)mappedList).add(mapper.apply(e));
        }
        return mappedList;
    }

    public void filter(IPredicate<Integer> predicate) {
        IIntList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            int e = this.doGet(i);
            if (!predicate.test(e)) continue;
            list2.add(e);
        }
        this.doAssign(list2);
    }

    public int indexOf(int elem) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!IIntList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int elem) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!IIntList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int indexOf(int elem, int fromIndex) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        int size2 = this.size();
        for (int i = fromIndex; i < size2; ++i) {
            if (!IIntList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int elem, int fromIndex) {
        int size2 = this.size();
        if (fromIndex >= size2) {
            fromIndex = size2 - 1;
        }
        for (int i = fromIndex; i >= 0; --i) {
            if (!IIntList.equalsElem(this.doGet(i), elem)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeElem(int elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean contains(int elem) {
        return this.indexOf(elem) != -1;
    }

    public boolean addIfAbsent(int elem) {
        if (this.contains(elem)) {
            return false;
        }
        return this.add(elem);
    }

    public boolean containsAny(Collection<Integer> coll) {
        for (int elem : coll) {
            if (!this.contains(elem)) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(Collection<Integer> coll) {
        for (int elem : coll) {
            if (this.contains(elem)) continue;
            return false;
        }
        return true;
    }

    public IIntList removeAll(int elem) {
        IIntList list2 = this.doCreate(-1);
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            int e = this.doGet(i);
            if (!IIntList.equalsElem(elem, e)) continue;
            list2.add(e);
            this.doRemove(i);
            --size2;
            --i;
        }
        return list2;
    }

    public boolean removeAll(Collection<Integer> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean removeAll(IIntList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (!coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<Integer> coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(IIntList coll) {
        this.checkNonNull(coll);
        boolean modified = false;
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            if (coll.contains(this.doGet(i))) continue;
            this.doRemove(i);
            --size2;
            --i;
            modified = true;
        }
        return modified;
    }

    public int[] toArray() {
        int size2 = this.size();
        int[] array = new int[size2];
        this.doGetAll(array, 0, size2);
        return array;
    }

    public int[] toArray(int index, int len) {
        int[] array = new int[len];
        this.doGetAll(array, index, len);
        return array;
    }

    public int[] toArray(int[] array) {
        int size2 = this.size();
        if (array.length < size2) {
            array = (int[])Array.newInstance(array.getClass().getComponentType(), size2);
        }
        this.doGetAll(array, 0, size2);
        if (array.length > size2) {
            array[size2] = 0;
        }
        return array;
    }

    protected void doGetAll(int[] array, int index, int len) {
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
    }

    protected boolean doAddAll(int index, IIntList list2) {
        int listSize = list2.size();
        this.doEnsureCapacity(this.size() + listSize);
        if (listSize == 0) {
            return false;
        }
        boolean changed = false;
        int prevSize = this.size();
        for (int i = 0; i < listSize; ++i) {
            int elem = list2.get(i);
            if (!this.doAdd(index, elem)) continue;
            changed = true;
            if (index == -1 || prevSize == this.size()) continue;
            prevSize = this.size();
            ++index;
        }
        return changed;
    }

    public int peek() {
        if (this.size() == 0) {
            return 0;
        }
        return this.getFirst();
    }

    public int element() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public int poll() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doRemove(0);
    }

    public int remove() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public boolean offer(int elem) {
        return this.doAdd(-1, elem);
    }

    public int getFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(0);
    }

    public int getLast() {
        int size2 = this.size();
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        return this.doGet(size2 - 1);
    }

    public void addFirst(int elem) {
        this.doAdd(0, elem);
    }

    public void addLast(int elem) {
        this.doAdd(-1, elem);
    }

    public int removeFirst() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public int removeLast() {
        int size2 = this.size();
        if (size2 == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(size2 - 1);
    }

    public boolean offerFirst(int elem) {
        this.doAdd(0, elem);
        return true;
    }

    public boolean offerLast(int elem) {
        this.doAdd(-1, elem);
        return true;
    }

    public int peekFirst() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doGet(0);
    }

    public int peekLast() {
        int size2 = this.size();
        if (size2 == 0) {
            return 0;
        }
        return this.doGet(size2 - 1);
    }

    public int pollFirst() {
        if (this.size() == 0) {
            return 0;
        }
        return this.doRemove(0);
    }

    public int pollLast() {
        int size2 = this.size();
        if (size2 == 0) {
            return 0;
        }
        return this.doRemove(size2 - 1);
    }

    public int pop() {
        if (this.size() == 0) {
            throw new NoSuchElementException();
        }
        return this.doRemove(0);
    }

    public void push(int elem) {
        this.doAdd(0, elem);
    }

    public boolean removeFirstOccurrence(int elem) {
        int index = this.indexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public boolean removeLastOccurrence(int elem) {
        int index = this.lastIndexOf(elem);
        if (index == -1) {
            return false;
        }
        this.doRemove(index);
        return true;
    }

    public static void transferCopy(IIntList src, int srcIndex, int srcLen, IIntList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.copy(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(0, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferMove(IIntList src, int srcIndex, int srcLen, IIntList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.move(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(1, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    public static void transferRemove(IIntList src, int srcIndex, int srcLen, IIntList dst, int dstIndex, int dstLen) {
        if (src == dst) {
            src.checkLengths(srcLen, dstLen);
            src.drag(srcIndex, dstIndex, srcLen);
        } else {
            src.doTransfer(2, srcIndex, srcLen, dst, dstIndex, dstLen);
        }
    }

    void doTransfer(int transferMode, int srcIndex, int srcLen, IIntList dst, int dstIndex, int dstLen) {
        if (srcLen == -1) {
            srcLen = this.size() - srcIndex;
        }
        this.checkRange(srcIndex, srcLen);
        if (dstIndex == -1) {
            dstIndex = dst.size();
        } else {
            dst.checkIndexAdd(dstIndex);
        }
        if (dstLen == -1) {
            dstLen = dst.size() - dstIndex;
        } else {
            dst.checkLength(dstLen);
        }
        int defaultElem = this.getDefaultElem();
        if (dstLen > srcLen) {
            dst.remove(dstIndex, dstLen - srcLen);
        } else if (srcLen > dstLen) {
            dst.addMult(dstIndex, srcLen - dstLen, defaultElem);
        }
        if (transferMode == 1) {
            for (int i = 0; i < srcLen; ++i) {
                int elem = this.doReSet(srcIndex + i, defaultElem);
                dst.doSet(dstIndex + i, elem);
            }
        } else {
            for (int i = 0; i < srcLen; ++i) {
                int elem = this.doGet(srcIndex + i);
                dst.doSet(dstIndex + i, elem);
            }
            if (transferMode == 2) {
                this.remove(srcIndex, srcLen);
            }
        }
    }

    public static void transferSwap(IIntList src, int srcIndex, IIntList dst, int dstIndex, int len) {
        if (src == dst) {
            src.swap(srcIndex, dstIndex, len);
        } else {
            src.doTransferSwap(srcIndex, dst, dstIndex, len);
        }
    }

    void doTransferSwap(int srcIndex, IIntList dst, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        dst.checkRange(dstIndex, len);
        for (int i = 0; i < len; ++i) {
            int swap = this.doGet(srcIndex + i);
            swap = dst.doSet(dstIndex + i, swap);
            this.doSet(srcIndex + i, swap);
        }
    }

    protected abstract IIntList doCreate(int var1);

    protected abstract void doAssign(IIntList var1);

    public IIntList getAll(int index, int len) {
        this.checkRange(index, len);
        IIntList list2 = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list2.add(this.doGet(index + i));
        }
        return list2;
    }

    public IIntList extract(int index, int len) {
        this.checkRange(index, len);
        IIntList list2 = this.doCreate(len);
        for (int i = 0; i < len; ++i) {
            list2.add(this.doGet(index + i));
        }
        this.remove(index, len);
        return list2;
    }

    public int[] getArray(int index, int len) {
        this.checkRange(index, len);
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = this.doGet(index + i);
        }
        return array;
    }

    public void remove(int index, int len) {
        this.checkRange(index, len);
        this.doRemoveAll(index, len);
    }

    protected void doRemoveAll(int index, int len) {
        for (int i = index + len - 1; i >= index; --i) {
            this.doRemove(i);
        }
    }

    public boolean addAll(IIntList list2) {
        return this.doAddAll(-1, list2);
    }

    public boolean addAll(int index, IIntList list2) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, list2);
    }

    public boolean addAll(Collection<Integer> coll) {
        if (coll instanceof List) {
            return this.doAddAll(-1, new IReadOnlyIntListFromList((List)coll));
        }
        return this.doAddAll(-1, new IReadOnlyIntListFromCollection(coll));
    }

    public boolean addAll(int index, Collection<Integer> coll) {
        this.checkIndexAdd(index);
        if (coll instanceof List) {
            return this.doAddAll(index, new IReadOnlyIntListFromList((List)coll));
        }
        return this.doAddAll(index, new IReadOnlyIntListFromCollection(coll));
    }

    public boolean addArray(int ... elems) {
        return this.doAddAll(-1, new IReadOnlyIntListFromArray(elems));
    }

    public boolean addArray(int index, int ... elems) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyIntListFromArray(elems));
    }

    public boolean addMult(int len, int elem) {
        return this.doAddAll(-1, new IReadOnlyIntListFromMult(len, elem));
    }

    public boolean addMult(int index, int len, int elem) {
        this.checkIndexAdd(index);
        return this.doAddAll(index, new IReadOnlyIntListFromMult(len, elem));
    }

    public void setAll(int index, IIntList list2) {
        int listSize = list2.size();
        this.checkRange(index, listSize);
        this.doReplaceAll(index, listSize, list2);
    }

    public void setAll(int index, Collection<Integer> coll) {
        int collSize = coll.size();
        this.checkRange(index, collSize);
        if (coll instanceof List) {
            this.doReplaceAll(index, collSize, new IReadOnlyIntListFromList((List)coll));
        } else {
            this.doReplaceAll(index, collSize, new IReadOnlyIntListFromCollection(coll));
        }
    }

    public void setArray(int index, int ... elems) {
        int arrayLen = elems.length;
        this.checkRange(index, arrayLen);
        this.doReplaceAll(index, arrayLen, new IReadOnlyIntListFromArray(elems));
    }

    public void setMult(int index, int len, int elem) {
        this.checkRange(index, len);
        this.doReplaceAll(index, len, new IReadOnlyIntListFromMult(len, elem));
    }

    public void putAll(int index, IIntList list2) {
        this.checkIndexAdd(index);
        this.checkNonNull(list2);
        int len = this.size() - index;
        if (list2 != null && list2.size() < len) {
            len = list2.size();
        }
        this.doReplaceAll(index, len, list2);
    }

    public void putAll(int index, Collection<Integer> coll) {
        if (coll instanceof IIntList) {
            this.putAll(index, (IIntList)((Object)coll));
        } else if (coll instanceof List) {
            this.putAll(index, new IReadOnlyIntListFromList((List)coll));
        } else {
            this.putAll(index, new IReadOnlyIntListFromCollection(coll));
        }
    }

    public void putArray(int index, int ... elems) {
        this.putAll(index, new IReadOnlyIntListFromArray(elems));
    }

    public void putMult(int index, int len, int elem) {
        this.putAll(index, new IReadOnlyIntListFromMult(len, elem));
    }

    public void initAll(IIntList list2) {
        this.checkNonNull(list2);
        this.doReplaceAll(0, this.size(), list2);
    }

    public void initAll(Collection<Integer> coll) {
        if (coll instanceof IIntList) {
            this.initAll((IIntList)((Object)coll));
        } else if (coll instanceof List) {
            this.initAll(new IReadOnlyIntListFromList((List)coll));
        } else {
            this.initAll(new IReadOnlyIntListFromCollection(coll));
        }
    }

    public void initArray(int ... elems) {
        this.initAll(new IReadOnlyIntListFromArray(elems));
    }

    public void initMult(int len, int elem) {
        this.checkLength(len);
        this.initAll(new IReadOnlyIntListFromMult(len, elem));
    }

    public void replaceAll(int index, int len, Collection<Integer> coll) {
        if (coll instanceof IIntList) {
            this.replaceAll(index, len, (IIntList)((Object)coll));
        } else if (coll instanceof List) {
            this.replaceAll(index, len, new IReadOnlyIntListFromList((List)coll));
        } else {
            this.replaceAll(index, len, new IReadOnlyIntListFromCollection(coll));
        }
    }

    public void replaceArray(int index, int len, int ... elems) {
        this.replaceAll(index, len, new IReadOnlyIntListFromArray(elems));
    }

    public void replaceMult(int index, int len, int numElems, int elem) {
        this.replaceAll(index, len, new IReadOnlyIntListFromMult(numElems, elem));
    }

    public void replaceAll(int index, int len, IIntList list2) {
        if (index == -1) {
            index = this.size();
        } else {
            this.checkIndexAdd(index);
        }
        if (len == -1) {
            len = this.size() - index;
            if (list2 != null && list2.size() < len) {
                len = list2.size();
            }
        } else {
            this.checkRange(index, len);
        }
        this.doReplaceAll(index, len, list2);
    }

    protected boolean doReplaceAll(int index, int len, IIntList list2) {
        assert (index >= 0 && index <= this.size());
        assert (len >= 0 && index + len <= this.size());
        int srcLen = 0;
        if (list2 != null) {
            srcLen = list2.size();
        }
        this.doEnsureCapacity(this.size() - len + srcLen);
        this.doRemoveAll(index, len);
        for (int i = 0; i < srcLen; ++i) {
            if (this.doAdd(index + i, list2.doGet(i))) continue;
            --index;
        }
        return len > 0 || srcLen > 0;
    }

    public void fill(int elem) {
        int size2 = this.size();
        for (int i = 0; i < size2; ++i) {
            this.doSet(i, elem);
        }
    }

    public void copy(int srcIndex, int dstIndex, int len) {
        block3: {
            block2: {
                this.checkRange(srcIndex, len);
                this.checkRange(dstIndex, len);
                if (srcIndex >= dstIndex) break block2;
                for (int i = len - 1; i >= 0; --i) {
                    this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
                }
                break block3;
            }
            if (srcIndex <= dstIndex) break block3;
            for (int i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
    }

    public void move(int srcIndex, int dstIndex, int len) {
        int fill;
        int i;
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            for (i = len - 1; i >= 0; --i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        } else if (srcIndex > dstIndex) {
            for (i = 0; i < len; ++i) {
                this.doReSet(dstIndex + i, this.doGet(srcIndex + i));
            }
        }
        if (srcIndex < dstIndex) {
            fill = Math.min(len, dstIndex - srcIndex);
            this.setMult(srcIndex, fill, 0);
        } else if (srcIndex > dstIndex) {
            fill = Math.min(len, srcIndex - dstIndex);
            this.setMult(srcIndex + len - fill, fill, 0);
        }
    }

    public void drag(int srcIndex, int dstIndex, int len) {
        this.checkRange(srcIndex, len);
        this.checkRange(dstIndex, len);
        if (srcIndex < dstIndex) {
            this.doRotate(srcIndex, len + (dstIndex - srcIndex), dstIndex - srcIndex);
        } else if (srcIndex > dstIndex) {
            this.doRotate(dstIndex, len + (srcIndex - dstIndex), dstIndex - srcIndex);
        }
    }

    public void swap(int index1, int index2, int len) {
        this.checkRange(index1, len);
        this.checkRange(index2, len);
        if (index1 < index2 && index1 + len > index2 || index1 > index2 && index2 + len > index1) {
            throw new IndexOutOfBoundsException("Swap ranges overlap");
        }
        for (int i = 0; i < len; ++i) {
            int swap = this.doGet(index1 + i);
            swap = this.doReSet(index2 + i, swap);
            this.doReSet(index1 + i, swap);
        }
    }

    public void reverse() {
        this.reverse(0, this.size());
    }

    public void reverse(int index, int len) {
        this.checkRange(index, len);
        int pos1 = index;
        int pos2 = index + len - 1;
        int mid = len / 2;
        for (int i = 0; i < mid; ++i) {
            int swap = this.doGet(pos1);
            swap = this.doReSet(pos2, swap);
            this.doReSet(pos1, swap);
            ++pos1;
            --pos2;
        }
    }

    public void rotate(int distance) {
        this.rotate(0, this.size(), distance);
    }

    public void rotate(int index, int len, int distance) {
        this.checkRange(index, len);
        this.doRotate(index, len, distance);
    }

    protected void doRotate(int index, int len, int distance) {
        if ((distance %= len) < 0) {
            distance += len;
        }
        if (distance == 0) {
            return;
        }
        assert (distance >= 0 && distance < len);
        int num = 0;
        int start = 0;
        while (num != len) {
            int elem = this.doGet(index + start);
            int i = start;
            do {
                if ((i += distance) >= len) {
                    i -= len;
                }
                elem = this.doReSet(index + i, elem);
                ++num;
            } while (i != start);
            ++start;
        }
    }

    public void sort() {
        this.sort(0, this.size());
    }

    public abstract void sort(int var1, int var2);

    public int binarySearch(int key) {
        return this.binarySearch(0, this.size(), key);
    }

    public abstract int binarySearch(int var1, int var2, int var3);

    protected void checkIndex(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkIndexAdd(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
    }

    protected void checkRange(int index, int len) {
        if (index < 0 || len < 0 || index + len > this.size()) {
            throw new IndexOutOfBoundsException("Invalid range: " + index + "/" + len + " (size: " + this.size() + ")");
        }
    }

    protected void checkLength(int len) {
        if (len < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len);
        }
    }

    protected void checkLengths(int len1, int len2) {
        if (len1 != len2) {
            throw new IndexOutOfBoundsException("Invalid lengths: " + len1 + ", " + len2);
        }
        if (len1 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len1);
        }
        if (len2 < 0) {
            throw new IndexOutOfBoundsException("Invalid length: " + len2);
        }
    }

    protected void checkNonNull(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Argument may not be 0");
        }
    }

    protected static class IReadOnlyIntListFromList
    extends IReadOnlyIntList {
        List<Integer> list2;

        IReadOnlyIntListFromList(List<Integer> list2) {
            this.list2 = list2;
        }

        @Override
        public int size() {
            return this.list2.size();
        }

        @Override
        protected int doGet(int index) {
            return this.list2.get(index);
        }
    }

    protected static class IReadOnlyIntListFromCollection
    extends IReadOnlyIntList {
        int[] array;

        IReadOnlyIntListFromCollection(Collection<Integer> coll) {
            this.array = IReadOnlyIntListFromCollection.toArray(coll);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected int doGet(int index) {
            return this.array[index];
        }
    }

    protected static class IReadOnlyIntListFromMult
    extends IReadOnlyIntList {
        int len;
        int elem;

        IReadOnlyIntListFromMult(int len, int elem) {
            this.checkLength(len);
            this.len = len;
            this.elem = elem;
        }

        @Override
        public int size() {
            return this.len;
        }

        @Override
        protected int doGet(int index) {
            return this.elem;
        }
    }

    protected static class IReadOnlyIntListFromArray
    extends IReadOnlyIntList {
        int[] array;

        IReadOnlyIntListFromArray(int[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        protected int doGet(int index) {
            return this.array[index];
        }
    }

    protected static abstract class IReadOnlyIntList
    extends IIntList {
        protected IReadOnlyIntList() {
        }

        @Override
        public IIntList unmodifiableList() {
            this.error();
            return null;
        }

        @Override
        protected void doClone(IIntList that) {
            this.error();
        }

        @Override
        public int capacity() {
            this.error();
            return 0;
        }

        @Override
        protected int doSet(int index, int elem) {
            this.error();
            return 0;
        }

        @Override
        protected int doReSet(int index, int elem) {
            this.error();
            return 0;
        }

        @Override
        protected int getDefaultElem() {
            this.error();
            return 0;
        }

        @Override
        protected boolean doAdd(int index, int elem) {
            this.error();
            return false;
        }

        @Override
        protected int doRemove(int index) {
            this.error();
            return 0;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected IIntList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(IIntList that) {
            this.error();
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }

        @Override
        public int binarySearch(int index, int len, int key) {
            this.error();
            return 0;
        }

        private void error() {
            throw new UnsupportedOperationException("list is read-only");
        }
    }
}

