/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.capabilities;

import com.google.common.base.MoreObjects;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.capabilities.dimension.DimensionInfo;
import org.orecruncher.dsurround.capabilities.dimension.IDimensionInfo;
import org.orecruncher.lib.capability.CapabilityProviderSerializable;
import org.orecruncher.lib.capability.CapabilityUtils;
import org.orecruncher.lib.capability.SimpleStorage;

public class CapabilityDimensionInfo {
    @CapabilityInject(value=IDimensionInfo.class)
    public static final Capability<IDimensionInfo> DIMENSION_INFO = null;
    public static final ResourceLocation CAPABILITY_ID = new ResourceLocation("dsurround", "dimensioninfo");

    public static void register() {
        CapabilityManager.INSTANCE.register(IDimensionInfo.class, (Capability.IStorage)new SimpleStorage(), DimensionInfo::new);
    }

    public static IDimensionInfo getCapability(@Nonnull World world) {
        return (IDimensionInfo)CapabilityUtils.getCapability((ICapabilityProvider)world, DIMENSION_INFO, null);
    }

    @Nonnull
    public static ICapabilityProvider createProvider(IDimensionInfo data) {
        return new CapabilityProviderSerializable(DIMENSION_INFO, null, (Object)data);
    }

    @Mod.EventBusSubscriber(modid="dsurround")
    public static class EventHandler {
        @SubscribeEvent
        public static void attachCapabilities(@Nonnull AttachCapabilitiesEvent<World> event) {
            if (!ModBase.isInitialized()) {
                ModBase.log().info("Attempt to attach world capability before mod is inititalized - silly fake worlds.", new Object[0]);
                return;
            }
            World world = (World)event.getObject();
            if (world != null) {
                String side = ModBase.proxy().effectiveSide().toString();
                ModBase.log().info("Attaching capabilities to world [%s] (%s)", new Object[]{world.field_73011_w.func_186058_p().func_186065_b(), side});
                DimensionInfo info = new DimensionInfo(world);
                event.addCapability(CAPABILITY_ID, CapabilityDimensionInfo.createProvider(info));
                MoreObjects.ToStringHelper builder = MoreObjects.toStringHelper((Object)info);
                builder.add("id", info.getId());
                builder.add("name", (Object)info.getName());
                builder.add("seaLevel", info.getSeaLevel());
                builder.add("cloudHeight", info.getCloudHeight());
                builder.add("skyHeight", info.getSkyHeight());
                builder.add("haze", info.hasHaze());
                builder.add("aurora", info.hasAuroras());
                builder.add("weather", info.hasWeather());
                builder.add("fog", info.hasFog());
                ModBase.log().info(builder.toString(), new Object[0]);
            }
        }
    }
}

