/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.biome;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.dsurround.ModBase;
import org.orecruncher.dsurround.registry.IDataAccessor;
import org.orecruncher.dsurround.registry.RegistryManager;
import org.orecruncher.dsurround.registry.biome.BiomeInfo;
import org.orecruncher.lib.Color;
import org.orecruncher.lib.ReflectedField;
import org.orecruncher.lib.WorldUtils;

@SideOnly(value=Side.CLIENT)
public final class BiomeUtil {
    private static final Color NO_COLOR = new Color.ImmutableColor(1.0f, 1.0f, 1.0f);
    private static final ReflectedField.ObjectField<Biome, String> biomeName = new ReflectedField.ObjectField(Biome.class, "biomeName", "field_76791_y");
    private static final ReflectedField.FloatField<Object> bopBiomeFogDensity = new ReflectedField.FloatField("biomesoplenty.common.biome.BOPBiome", "fogDensity", null);
    private static final ReflectedField.IntegerField<Object> bopBiomeFogColor = new ReflectedField.IntegerField("biomesoplenty.common.biome.BOPBiome", "fogColor", null);
    private static final ReflectedField.ObjectField<BiomeDictionary.Type, Map<String, BiomeDictionary.Type>> biomeType = new ReflectedField.ObjectField(BiomeDictionary.Type.class, "byName", null);
    private static final Class<?> bopBiome = ReflectedField.resolveClass((String)"biomesoplenty.common.biome.BOPBiome");

    @Nonnull
    public static BiomeInfo getBiomeData(@Nonnull Biome biome) {
        IDataAccessor accessor = (IDataAccessor)biome;
        BiomeInfo result = null;
        if (biome != null && (result = (BiomeInfo)accessor.getData()) == null) {
            RegistryManager.BIOME.reload();
            result = (BiomeInfo)accessor.getData();
        }
        if (result == null) {
            ModBase.log().warn("Unable to find configuration for biome [%s] (hc=%d)", new Object[]{biome.getRegistryName(), System.identityHashCode(biome)});
            result = RegistryManager.BIOME.WTF_INFO;
            accessor.setData(result);
        }
        return result;
    }

    public static void setBiomeData(@Nonnull Biome biome, @Nullable BiomeInfo data) {
        ((IDataAccessor)biome).setData(data);
    }

    @Nonnull
    public static String getBiomeName(@Nonnull Biome biome) {
        String result = (String)biomeName.get((Object)biome);
        return StringUtils.isEmpty((CharSequence)result) ? "UNKNOWN" : result;
    }

    public static boolean isBoPBiome(@Nonnull Biome biome) {
        return bopBiome != null && bopBiome.isInstance(biome);
    }

    public static int getBoPBiomeFogColor(@Nonnull Biome biome) {
        return bopBiomeFogColor.isAvailable() ? bopBiomeFogColor.get((Object)biome) : 0;
    }

    public static float getBoPBiomeFogDensity(@Nonnull Biome biome) {
        return bopBiomeFogDensity.isAvailable() ? bopBiomeFogDensity.get((Object)biome) : 0.0f;
    }

    @Nonnull
    public static Set<BiomeDictionary.Type> getBiomeTypes() {
        if (biomeType.isAvailable()) {
            return new ReferenceOpenHashSet(((Map)biomeType.get(null)).values());
        }
        throw new IllegalStateException("Cannot locate BiomeDictionary.Type table!");
    }

    @Nonnull
    public static Color getBiomeWaterColor(@Nonnull World world, @Nonnull BlockPos pos) {
        return new Color(BiomeColorHelper.func_180288_c((IBlockAccess)world, (BlockPos)pos));
    }

    @Nullable
    public static Color getColorForLiquid(@Nonnull World world, @Nonnull BlockPos pos) {
        return BiomeUtil.getColorForLiquid(world, WorldUtils.getBlockState((World)world, (BlockPos)pos), pos);
    }

    @Nonnull
    public static Color getColorForLiquid(@Nonnull World world, @Nonnull IBlockState state, @Nonnull BlockPos pos) {
        Block liquid = state.func_177230_c();
        if (liquid == Blocks.field_150355_j) {
            return BiomeUtil.getBiomeWaterColor(world, pos);
        }
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)liquid);
        if (fluid != null) {
            return new Color(fluid.getColor());
        }
        return NO_COLOR;
    }

    @Nonnull
    public static Set<BiomeDictionary.Type> getBiomeTypes(@Nonnull Biome biome) {
        try {
            return new ReferenceOpenHashSet((Collection)BiomeDictionary.getTypes((Biome)biome));
        }
        catch (Throwable t) {
            String name = (String)biomeName.get((Object)biome);
            ModBase.log().warn("Unable to get biome type data for biome '%s'", new Object[]{name});
            return new ReferenceOpenHashSet();
        }
    }

    public static boolean areBiomesSimilar(@Nonnull Biome b1, @Nonnull Biome b2) {
        return BiomeDictionary.areSimilar((Biome)b1, (Biome)b2);
    }
}

