/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.ench.enchantment;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.RandomEnchants;
import com.tfar.randomenchants.init.ModEnchantment;
import com.tfar.randomenchants.util.EnchantmentUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentArrowInfinite;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomenchantments")
public class EnchantmentBackToTheChamber
extends Enchantment {
    public EnchantmentBackToTheChamber() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.BOW, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("back_to_the_chamber");
        this.func_77322_b("back_to_the_chamber");
    }

    public int func_77321_a(int level) {
        return 5 + 10 * (level - 1);
    }

    public int func_77317_b(int level) {
        return super.func_77321_a(level) + 25;
    }

    public int func_77325_b() {
        return 5;
    }

    public boolean func_92089_a(ItemStack stack) {
        return EnchantmentConfig.weapons.enableBackToTheChamber != EnchantmentConfig.EnumAccessLevel.DISABLED && super.func_92089_a(stack);
    }

    public boolean func_185261_e() {
        return EnchantmentConfig.weapons.enableBackToTheChamber == EnchantmentConfig.EnumAccessLevel.ANVIL;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return EnchantmentConfig.weapons.enableBackToTheChamber != EnchantmentConfig.EnumAccessLevel.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    protected boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != ModEnchantment.MULTISHOT && !(ench instanceof EnchantmentArrowInfinite);
    }

    public boolean isAllowedOnBooks() {
        return EnchantmentConfig.weapons.enableBackToTheChamber == EnchantmentConfig.EnumAccessLevel.NORMAL;
    }

    @SubscribeEvent
    public static void arrowHit(ProjectileImpactEvent event) {
        Entity arrow = event.getEntity();
        if (EnchantmentUtils.isArrowAndIsLivingBase(arrow, event.getRayTraceResult().field_72308_g)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)((EntityArrow)arrow).field_70250_c;
        int level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantment.BACK_TO_THE_CHAMBER, (EntityLivingBase)player);
        if (5.0 * Math.random() > (double)level) {
            return;
        }
        if (!player.field_70170_p.field_72995_K) {
            try {
                ItemStack arrowItem = (ItemStack)ObfuscationReflectionHelper.findMethod(EntityArrow.class, (String)"func_184550_j", ItemStack.class, (Class[])new Class[0]).invoke((Object)((EntityArrow)arrow), new Object[0]);
                boolean found = false;
                NonNullList inventory = player.field_71071_by.field_70462_a;
                for (ItemStack stack : inventory) {
                    if (stack.func_77973_b() != arrowItem.func_77973_b()) continue;
                    stack.func_190917_f(1);
                    found = true;
                    break;
                }
                if (!found) {
                    player.func_191521_c(arrowItem);
                }
            }
            catch (Exception e) {
                RandomEnchants.logger.error("Reflection error ", (Throwable)e);
            }
        }
    }
}

