/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.ench.enchantment;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.init.ModEnchantment;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomenchantments")
public class EnchantmentGrappling
extends Enchantment {
    public EnchantmentGrappling() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.FISHING_ROD, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("grappling");
        this.func_77322_b("grappling");
    }

    public int func_77321_a(int level) {
        return 30;
    }

    public int func_77317_b(int level) {
        return 100;
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_92089_a(@Nonnull ItemStack stack) {
        return EnchantmentConfig.tools.enableGrappling != EnchantmentConfig.EnumAccessLevel.DISABLED && super.func_92089_a(stack);
    }

    public boolean func_185261_e() {
        return EnchantmentConfig.tools.enableGrappling == EnchantmentConfig.EnumAccessLevel.ANVIL;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return EnchantmentConfig.tools.enableGrappling != EnchantmentConfig.EnumAccessLevel.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return EnchantmentConfig.tools.enableGrappling == EnchantmentConfig.EnumAccessLevel.NORMAL;
    }

    @SubscribeEvent
    public static void playerTick(PlayerInteractEvent e) {
        if (e instanceof PlayerInteractEvent.EntityInteract || e instanceof PlayerInteractEvent.EntityInteractSpecific) {
            return;
        }
        EntityPlayer player = e.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (e.getEntityPlayer().field_71104_cf != null) {
            EntityFishHook hook = player.field_71104_cf;
            Entity entity = hook.field_146043_c;
            if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantment.PULLING, (EntityLivingBase)player) == 0) {
                return;
            }
            if (entity != null) {
                Vec3d veloctiyVector = new Vec3d(player.field_70165_t - entity.field_70165_t, player.field_70163_u - entity.field_70163_u, player.field_70161_v - entity.field_70161_v);
                entity.func_70024_g(veloctiyVector.field_72450_a, veloctiyVector.field_72448_b, veloctiyVector.field_72449_c);
                entity.field_70133_I = true;
            } else {
                double speed = Math.sqrt(Math.pow(hook.field_70159_w, 2.0) + Math.pow(hook.field_70181_x, 2.0) + Math.pow(hook.field_70179_y, 2.0));
                if (hook.func_70090_H() || speed > 0.01) {
                    return;
                }
                Vec3d veloctiyVector = new Vec3d(hook.field_70165_t - player.field_70165_t, hook.field_70163_u - player.field_70163_u, hook.field_70161_v - player.field_70161_v);
                player.func_70024_g(veloctiyVector.field_72450_a, veloctiyVector.field_72448_b, veloctiyVector.field_72449_c);
                player.field_70133_I = true;
            }
        }
    }
}

