/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.ench.enchantment;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.init.ModEnchantment;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityFishHook;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomenchantments")
public class EnchantmentHooked
extends Enchantment {
    private static ArrayList<EntityEquipmentSlot> list = new ArrayList();

    public EnchantmentHooked() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.FISHING_ROD, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("hooked");
        this.func_77322_b("hooked");
    }

    public int func_77321_a(int level) {
        return 30;
    }

    public int func_77317_b(int level) {
        return 100;
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_92089_a(ItemStack stack) {
        return EnchantmentConfig.tools.enableHooked != EnchantmentConfig.EnumAccessLevel.DISABLED && super.func_92089_a(stack);
    }

    public boolean func_185261_e() {
        return EnchantmentConfig.tools.enableHooked == EnchantmentConfig.EnumAccessLevel.ANVIL;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return EnchantmentConfig.tools.enableHooked != EnchantmentConfig.EnumAccessLevel.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return EnchantmentConfig.tools.enableHooked == EnchantmentConfig.EnumAccessLevel.NORMAL;
    }

    @SubscribeEvent
    public static void playerTick(PlayerInteractEvent e) {
        if (e instanceof PlayerInteractEvent.EntityInteract || e instanceof PlayerInteractEvent.EntityInteractSpecific) {
            return;
        }
        EntityPlayer player = e.getEntityPlayer();
        if (e.getEntityPlayer().field_71104_cf == null || player.field_70170_p.field_72995_K) {
            return;
        }
        EntityFishHook hook = player.field_71104_cf;
        Entity entity = hook.field_146043_c;
        if (!(entity instanceof EntityLivingBase) || EnchantmentHelper.func_185284_a((Enchantment)ModEnchantment.HOOKED, (EntityLivingBase)player) == 0) {
            return;
        }
        EntityLivingBase victim = (EntityLivingBase)entity;
        ItemStack piece = EnchantmentHooked.removeArmor(victim);
        if (piece == null) {
            return;
        }
        BlockPos pos = victim.func_180425_c();
        EntityItem entityItem = new EntityItem(victim.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), piece);
        Vec3d veloctiyVector = new Vec3d(player.field_70165_t - victim.field_70165_t, player.field_70163_u - victim.field_70163_u, player.field_70161_v - victim.field_70161_v);
        EnchantmentHooked.spawnItemWithVelocity(veloctiyVector, entityItem);
    }

    public static ItemStack removeArmor(EntityLivingBase victim) {
        ItemStack stack = null;
        for (EntityEquipmentSlot slot : list) {
            if (victim.func_184582_a(slot).func_190926_b()) continue;
            stack = victim.func_184582_a(slot);
            victim.func_184201_a(slot, ItemStack.field_190927_a);
            break;
        }
        return stack;
    }

    public static void spawnItemWithVelocity(Vec3d vec, EntityItem entityItem) {
        entityItem.field_70159_w = vec.field_72450_a;
        entityItem.field_70181_x = vec.field_72448_b;
        entityItem.field_70179_y = vec.field_72449_c;
        entityItem.field_70170_p.func_72838_d((Entity)entityItem);
    }

    static {
        list.add(EntityEquipmentSlot.HEAD);
        list.add(EntityEquipmentSlot.CHEST);
        list.add(EntityEquipmentSlot.LEGS);
        list.add(EntityEquipmentSlot.FEET);
    }
}

