/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.ench.enchantment;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.init.ModEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomenchantments")
public class EnchantmentMomentum
extends Enchantment {
    public EnchantmentMomentum() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.DIGGER, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("momentum");
        this.func_77322_b("momentum");
    }

    public int func_77321_a(int level) {
        return 15;
    }

    public int func_77317_b(int level) {
        return 100;
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_92089_a(ItemStack stack) {
        return EnchantmentConfig.tools.enableMomentum != EnchantmentConfig.EnumAccessLevel.DISABLED && super.func_92089_a(stack);
    }

    public boolean func_185261_e() {
        return EnchantmentConfig.tools.enableMomentum == EnchantmentConfig.EnumAccessLevel.ANVIL;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return EnchantmentConfig.tools.enableMomentum != EnchantmentConfig.EnumAccessLevel.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return EnchantmentConfig.tools.enableMomentum == EnchantmentConfig.EnumAccessLevel.NORMAL;
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed e) {
        EntityPlayer p = e.getEntityPlayer();
        if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantment.MOMENTUM, (EntityLivingBase)p) > 0) {
            ItemStack stack = p.func_184614_ca();
            NBTTagCompound compound = stack.func_77978_p();
            int momentum = compound.func_74762_e("momentum");
            float oldSpeed = e.getOriginalSpeed();
            float newSpeed = oldSpeed + 0.05f * (float)momentum;
            e.setNewSpeed(newSpeed);
        }
    }

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent e) {
        String currentBlock;
        EntityPlayer p = e.getPlayer();
        if (EnchantmentHelper.func_185284_a((Enchantment)ModEnchantment.MOMENTUM, (EntityLivingBase)p) == 0) {
            return;
        }
        ItemStack stack = p.func_184614_ca();
        NBTTagCompound compound = stack.func_77978_p();
        int momentum = compound.func_74762_e("momentum");
        String cachedBlock = compound.func_74779_i("block");
        if (!cachedBlock.equals(currentBlock = e.getState().func_177230_c().toString())) {
            compound.func_74768_a("momentum", 0);
            compound.func_74778_a("block", currentBlock);
        } else {
            compound.func_74768_a("momentum", momentum + 1);
        }
    }
}

