/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.ench.enchantment;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.init.ModEnchantment;
import com.tfar.randomenchants.util.EnchantmentUtils;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber(modid="randomenchantments")
public class EnchantmentRicochet
extends Enchantment {
    public EnchantmentRicochet() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.BOW, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.setRegistryName("ricochet");
        this.func_77322_b("ricochet");
    }

    public int func_77321_a(int level) {
        return 25;
    }

    public int func_77317_b(int level) {
        return 100;
    }

    public int func_77325_b() {
        return 1;
    }

    public boolean func_92089_a(ItemStack stack) {
        return EnchantmentConfig.weapons.enableRicochet != EnchantmentConfig.EnumAccessLevel.DISABLED && super.func_92089_a(stack);
    }

    public boolean func_185261_e() {
        return EnchantmentConfig.weapons.enableRicochet == EnchantmentConfig.EnumAccessLevel.ANVIL;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return EnchantmentConfig.weapons.enableRicochet != EnchantmentConfig.EnumAccessLevel.DISABLED && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return EnchantmentConfig.weapons.enableRicochet == EnchantmentConfig.EnumAccessLevel.NORMAL;
    }

    @SubscribeEvent
    public static void arrowHit(ProjectileImpactEvent event) {
        if (event.getRayTraceResult().field_72308_g != null) {
            return;
        }
        Entity entity = event.getEntity();
        if (!(entity instanceof EntityArrow)) {
            return;
        }
        EntityArrow arrow = (EntityArrow)entity;
        Entity shooter = arrow.field_70250_c;
        if (!(shooter instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)shooter;
        int level = EnchantmentHelper.func_185284_a((Enchantment)ModEnchantment.RICOCHET, (EntityLivingBase)player);
        if (level <= 0) {
            return;
        }
        EnumFacing facing = event.getRayTraceResult().field_178784_b;
        switch (facing) {
            case UP: {
                EnchantmentUtils.serverSafeSetVelocity(entity.field_70159_w, -entity.field_70181_x, entity.field_70179_y, arrow);
                break;
            }
            case DOWN: {
                EnchantmentUtils.serverSafeSetVelocity(entity.field_70159_w, -entity.field_70181_x, entity.field_70179_y, arrow);
                break;
            }
            case EAST: {
                EnchantmentUtils.serverSafeSetVelocity(-entity.field_70159_w, entity.field_70181_x, entity.field_70179_y, arrow);
                break;
            }
            case WEST: {
                EnchantmentUtils.serverSafeSetVelocity(-entity.field_70159_w, entity.field_70181_x, entity.field_70179_y, arrow);
                break;
            }
            case NORTH: {
                EnchantmentUtils.serverSafeSetVelocity(entity.field_70159_w, entity.field_70181_x, -entity.field_70179_y, arrow);
                break;
            }
            case SOUTH: {
                EnchantmentUtils.serverSafeSetVelocity(entity.field_70159_w, entity.field_70181_x, -entity.field_70179_y, arrow);
                break;
            }
            default: {
                throw new IllegalStateException("INVALID ENUM DETECTED: " + facing);
            }
        }
        arrow.field_70133_I = true;
        event.setCanceled(true);
    }
}

