/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.util;

import com.tfar.randomenchants.EnchantmentConfig;
import com.tfar.randomenchants.ench.enchantment.EnchantmentGlobalTraveler;
import com.tfar.randomenchants.init.ModEnchantment;
import com.tfar.randomenchants.util.EnchantmentUtils;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onTooltip(ItemTooltipEvent e) {
        EntityPlayer p = e.getEntityPlayer();
        if (p == null) {
            return;
        }
        if (EnchantmentUtils.stackHasEnch(e.getItemStack(), ModEnchantment.STONEBOUND)) {
            ItemStack stack = p.func_184614_ca();
            if (e.getItemStack() != stack) {
                return;
            }
            ArrayList tooltip = (ArrayList)e.getToolTip();
            tooltip.add("Mining Bonus: " + TextFormatting.GREEN + "+" + (double)stack.func_77952_i() * 0.02);
            tooltip.add("Damage Penalty: " + TextFormatting.RED + "-" + (double)stack.func_77952_i() * 0.02);
        }
        if (e.getItemStack().func_77973_b() instanceof ItemEnchantedBook) {
            NBTTagList nbttaglist = ItemEnchantedBook.func_92110_g((ItemStack)e.getItemStack());
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                short j = nbttagcompound.func_74765_d("id");
                Enchantment enchantment = Enchantment.func_185262_c((int)j);
                if (ModEnchantment.enchants.get(enchantment) != EnchantmentConfig.EnumAccessLevel.DISABLED) continue;
                ArrayList tooltip = (ArrayList)e.getToolTip();
                tooltip.add(TextFormatting.DARK_RED + "THIS ENCHANTMENT IS DISABLED!");
            }
        }
    }

    @SubscribeEvent
    public static void tooltip(ItemTooltipEvent event) {
        NBTTagCompound nbt0 = EnchantmentUtils.getTagSafe(event.getItemStack());
        if (event.isCanceled() || event.getItemStack().func_190926_b() || !EnchantmentUtils.stackHasEnch(event.getItemStack(), ModEnchantment.GLOBAL_TRAVELLER)) {
            return;
        }
        event.getToolTip().add("Toggle: " + nbt0.func_74767_n("toggle"));
        if (nbt0.func_150297_b(EnchantmentGlobalTraveler.KEY, 10)) {
            NBTTagCompound nbt = nbt0.func_74775_l(EnchantmentGlobalTraveler.KEY);
            event.getToolTip().add(I18n.func_135052_a((String)"tooltip.globalmodifier.info", (Object[])new Object[]{nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"), EnchantmentUtils.getWorldNameFromid(nbt.func_74762_e("dim"))}));
        }
    }
}

