/*
 * Decompiled with CFR 0.152.
 */
package com.tfar.randomenchants.util;

import com.tfar.randomenchants.ench.enchantment.EnchantmentGlobalTraveler;
import com.tfar.randomenchants.init.ModEnchantment;
import com.tfar.randomenchants.util.EnchantmentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    public static Map<EntityArrow, Double> homingarrows = new HashMap<EntityArrow, Double>();
    public static List<EntityArrow> trueshotarrows = new ArrayList<EntityArrow>();

    public static double absValue(Vec3d vec) {
        return Math.sqrt(Math.pow(vec.field_72450_a, 2.0) + Math.pow(vec.field_72448_b, 2.0) + Math.pow(vec.field_72449_c, 2.0));
    }

    public Vec3d normalize(Vec3d vec) {
        double d0 = EventHandler.absValue(vec);
        return d0 < 1.0E-20 ? Vec3d.field_186680_a : new Vec3d(vec.field_72450_a / d0, vec.field_72448_b / d0, vec.field_72449_c / d0);
    }

    @SubscribeEvent
    public void arrowInBlock(ProjectileImpactEvent event) {
        if (!(event.getEntity() instanceof EntityArrow)) {
            return;
        }
        if (event.getRayTraceResult().field_72308_g != null) {
            return;
        }
        EntityArrow arrow = (EntityArrow)event.getEntity();
        if (arrow.field_70251_a == EntityArrow.PickupStatus.ALLOWED) {
            return;
        }
        if (arrow.getEntityData().func_74762_e("homing") != 1) {
            return;
        }
        arrow.func_70106_y();
    }

    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent e) {
        if (e.phase != TickEvent.Phase.END) {
            return;
        }
        ArrayList<EntityArrow> removeHoming = new ArrayList<EntityArrow>();
        block0: for (Map.Entry<EntityArrow, Double> entry : homingarrows.entrySet()) {
            double z;
            double y;
            int r;
            double x;
            World world;
            List targets;
            EntityArrow arrow = entry.getKey();
            if (arrow.field_70173_aa > 600) {
                arrow.func_70106_y();
                removeHoming.add(arrow);
            }
            if (arrow.field_70128_L || (targets = (world = arrow.field_70170_p).func_72872_a(EntityLivingBase.class, new AxisAlignedBB((x = arrow.field_70165_t) - (double)(r = 8), (y = arrow.field_70163_u) - (double)r, (z = arrow.field_70161_v) - (double)r, x + (double)r, y + (double)r, z + (double)r))).size() == 0) continue;
            for (Entity target : targets) {
                if (target instanceof EntityPlayer || target instanceof EntityEnderman || target instanceof EntityAnimal) continue;
                double speed = entry.getValue();
                AxisAlignedBB box = target.func_174813_aQ();
                double diff = box.field_72337_e - box.field_72338_b;
                Vec3d arrowDirection = new Vec3d(target.field_70165_t - arrow.field_70165_t, target.field_70163_u + diff / 2.0 - arrow.field_70163_u, target.field_70161_v - arrow.field_70161_v);
                arrowDirection = this.normalize(arrowDirection);
                EnchantmentUtils.serverSafeSetVelocity(speed * arrowDirection.field_72450_a, speed * arrowDirection.field_72448_b, speed * arrowDirection.field_72449_c, arrow);
                arrow.field_70133_I = true;
                continue block0;
            }
        }
        for (EntityArrow arrow : removeHoming) {
            homingarrows.remove(arrow);
        }
        ArrayList<EntityArrow> removeTrueShot = new ArrayList<EntityArrow>();
        for (EntityArrow arrow : trueshotarrows) {
            if (arrow.field_70173_aa > 600) {
                arrow.func_70106_y();
                removeTrueShot.add(arrow);
            }
            if (arrow.field_70128_L) continue;
            EnchantmentUtils.serverSafeSetVelocity(arrow.field_70159_w / 0.99, arrow.field_70181_x / 0.99, arrow.field_70179_y / 0.99, arrow);
            arrow.field_70133_I = true;
        }
        trueshotarrows.removeAll(removeTrueShot);
    }

    @SubscribeEvent
    public void toggle(PlayerInteractEvent.RightClickItem e) {
        if (e.getWorld().field_72995_K) {
            return;
        }
        ItemStack stack = e.getItemStack();
        if (EnchantmentUtils.stackHasEnch(stack, ModEnchantment.GLOBAL_TRAVELLER) && e.getEntityPlayer().func_70093_af()) {
            EventHandler.toggle(stack);
        }
    }

    public static void toggle(ItemStack stack) {
        NBTTagCompound nbt = EnchantmentUtils.getTagSafe(stack);
        if (nbt.func_74764_b(EnchantmentGlobalTraveler.KEY)) {
            boolean toggle = stack.func_77978_p().func_74767_n("toggle");
            stack.func_77978_p().func_74757_a("toggle", !toggle);
        }
    }
}

