/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments;

import com.wonderfulenchantments.ConfigHandler;
import com.wonderfulenchantments.curses.FatigueCurse;
import com.wonderfulenchantments.curses.SlownessCurse;
import com.wonderfulenchantments.enchantments.DodgeEnchantment;
import com.wonderfulenchantments.enchantments.EnlightenmentEnchantment;
import com.wonderfulenchantments.enchantments.FanaticEnchantment;
import com.wonderfulenchantments.enchantments.HumanSlayerEnchantment;
import com.wonderfulenchantments.enchantments.ImmortalityEnchantment;
import com.wonderfulenchantments.enchantments.PhoenixDiveEnchantment;
import com.wonderfulenchantments.enchantments.PufferfishVengeanceEnchantment;
import com.wonderfulenchantments.enchantments.SmelterEnchantment;
import com.wonderfulenchantments.enchantments.VitalityEnchantment;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;

public class WonderfulEnchantmentHelper {
    public static final int disableEnchantmentValue = 9001;

    public static <InstanceType> int calculateEnchantmentSumIfIsInstanceOf(Enchantment enchantment, EntityLivingBase entityLivingBase, EntityEquipmentSlot[] slotTypes, Class<InstanceType> type) {
        int sum = 0;
        for (EntityEquipmentSlot slotType : slotTypes) {
            ItemStack itemStack = entityLivingBase.func_184582_a(slotType);
            if (!type.isInstance(itemStack.func_77973_b())) continue;
            sum += EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)itemStack);
        }
        return sum;
    }

    public static int calculateEnchantmentSum(Enchantment enchantment, EntityLivingBase entityLivingBase, EntityEquipmentSlot[] slotTypes) {
        int sum = 0;
        for (EntityEquipmentSlot slotType : slotTypes) {
            sum += EnchantmentHelper.func_77506_a((Enchantment)enchantment, (ItemStack)entityLivingBase.func_184582_a(slotType));
        }
        return sum;
    }

    public static int increaseLevelIfEnchantmentIsDisabled(Enchantment enchantment) {
        if (enchantment instanceof FanaticEnchantment) {
            return ConfigHandler.enchantments.FISHING_FANATIC ? 0 : 9001;
        }
        if (enchantment instanceof HumanSlayerEnchantment) {
            return ConfigHandler.enchantments.HUMAN_SLAYER ? 0 : 9001;
        }
        if (enchantment instanceof DodgeEnchantment) {
            return ConfigHandler.enchantments.DODGE ? 0 : 9001;
        }
        if (enchantment instanceof EnlightenmentEnchantment) {
            return ConfigHandler.enchantments.ENLIGHTENMENT ? 0 : 9001;
        }
        if (enchantment instanceof VitalityEnchantment) {
            return ConfigHandler.enchantments.VITALITY ? 0 : 9001;
        }
        if (enchantment instanceof PhoenixDiveEnchantment) {
            return ConfigHandler.enchantments.PHOENIX_DIVE ? 0 : 9001;
        }
        if (enchantment instanceof PufferfishVengeanceEnchantment) {
            return ConfigHandler.enchantments.PUFFERFISH_VENGEANCE ? 0 : 9001;
        }
        if (enchantment instanceof ImmortalityEnchantment) {
            return ConfigHandler.enchantments.IMMORTALITY ? 0 : 9001;
        }
        if (enchantment instanceof SmelterEnchantment) {
            return ConfigHandler.enchantments.SMELTER ? 0 : 9001;
        }
        if (enchantment instanceof SlownessCurse) {
            return ConfigHandler.curses.SLOWNESS ? 0 : 9001;
        }
        if (enchantment instanceof FatigueCurse) {
            return ConfigHandler.curses.FATIGUE ? 0 : 9001;
        }
        return 0;
    }
}

