/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.AttributeHelper;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.WonderfulEnchantmentHelper;
import com.wonderfulenchantments.WonderfulEnchantments;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class DodgeEnchantment
extends Enchantment {
    protected static final AttributeHelper attributeHelper = new AttributeHelper("ad3e064e-e9f6-4747-a86b-46dc4e2a1444", "KnockBackImmunityTime", SharedMonsterAttributes.field_111266_c, 0);
    protected static HashMap<Integer, Integer> immunitiesLeft = new HashMap();

    public DodgeEnchantment(String name) {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.ARMOR_LEGS, new EntityEquipmentSlot[]{EntityEquipmentSlot.LEGS});
        this.func_77322_b(name);
        this.setRegistryName("wonderful_enchantments", name);
        RegistryHandler.ENCHANTMENTS.add(this);
    }

    public int func_77325_b() {
        return 2;
    }

    public int func_77321_a(int level) {
        return 14 * level + WonderfulEnchantmentHelper.increaseLevelIfEnchantmentIsDisabled(this);
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 20;
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingDamageEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        ItemStack pants = entityLivingBase.func_184582_a(EntityEquipmentSlot.LEGS);
        int enchantmentLevel = EnchantmentHelper.func_185284_a((Enchantment)RegistryHandler.DODGE, (EntityLivingBase)entityLivingBase);
        if (enchantmentLevel > 0) {
            if (!(WonderfulEnchantments.RANDOM.nextDouble() < (double)enchantmentLevel * 0.125)) {
                return;
            }
            DodgeEnchantment.spawnParticlesAndPlaySounds(entityLivingBase);
            pants.func_77972_a((int)event.getAmount(), entityLivingBase);
            DodgeEnchantment.setImmunity(entityLivingBase, 50 * enchantmentLevel);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void updateEntitiesKnockBackImmunity(TickEvent.WorldTickEvent event) {
        for (Map.Entry<Integer, Integer> pair : immunitiesLeft.entrySet()) {
            Entity entity = event.world.func_73045_a(pair.getKey().intValue());
            if (entity instanceof EntityLivingBase) {
                DodgeEnchantment.updateImmunity((EntityLivingBase)entity);
            }
            pair.setValue(Math.max(pair.getValue() - 1, 0));
        }
        immunitiesLeft.values().removeIf(value -> value == 0);
    }

    protected static void setImmunity(EntityLivingBase entityLivingBase, @Nonnegative int ticks) {
        immunitiesLeft.put(entityLivingBase.func_145782_y(), ticks);
        DodgeEnchantment.updateImmunity(entityLivingBase);
    }

    protected static void updateImmunity(EntityLivingBase entityLivingBase) {
        double immunity = immunitiesLeft.get(entityLivingBase.func_145782_y()) > 0 ? 1.0 : 0.0;
        attributeHelper.setValue(immunity).apply(entityLivingBase);
    }

    protected static void spawnParticlesAndPlaySounds(EntityLivingBase entityLivingBase) {
        WorldServer world = (WorldServer)entityLivingBase.func_130014_f_();
        for (double d = 0.0; d < 3.0; d += 1.0) {
            world.func_175739_a(EnumParticleTypes.SMOKE_NORMAL, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + (double)entityLivingBase.field_70131_O * (0.25 * (d + 1.0)), entityLivingBase.field_70161_v, 32, 0.125, 0.0, 0.125, 0.075, new int[0]);
            world.func_175739_a(EnumParticleTypes.SMOKE_LARGE, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + (double)entityLivingBase.field_70131_O * (0.25 * (d + 1.0)), entityLivingBase.field_70161_v, 16, 0.125, 0.0, 0.125, 0.025, new int[0]);
        }
        world.func_184148_a(null, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, SoundEvents.field_187541_bC, SoundCategory.AMBIENT, 1.0f, 1.0f);
    }
}

