/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.WonderfulEnchantmentHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class HumanSlayerEnchantment
extends EnchantmentDamage {
    public HumanSlayerEnchantment(String name) {
        super(Enchantment.Rarity.UNCOMMON, 3, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b(name);
        this.setRegistryName("wonderful_enchantments", name);
        RegistryHandler.ENCHANTMENTS.add((Enchantment)this);
    }

    public int func_77321_a(int enchantmentLevel) {
        return 5 + (enchantmentLevel - 1) * 8 + WonderfulEnchantmentHelper.increaseLevelIfEnchantmentIsDisabled((Enchantment)this);
    }

    public int func_77317_b(int enchantmentLevel) {
        return this.func_77321_a(enchantmentLevel) + 20;
    }

    public float func_152376_a(int level, EnumCreatureAttribute creatureType) {
        return 0.0f;
    }

    public String func_77320_a() {
        return new TextComponentTranslation("enchantment.human_slayer", new Object[0]).func_150261_e();
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        Entity entitySource = event.getSource().func_76364_f();
        if (entitySource instanceof EntityLivingBase) {
            EntityLivingBase target = event.getEntityLiving();
            EntityLivingBase attacker = (EntityLivingBase)entitySource;
            float extraDamage = (float)Math.floor(2.5 * (double)EnchantmentHelper.func_185284_a((Enchantment)RegistryHandler.HUMAN_SLAYER, (EntityLivingBase)attacker));
            if (HumanSlayerEnchantment.isHuman((Entity)target) && extraDamage > 0.0f) {
                ((WorldServer)attacker.func_130014_f_()).func_175739_a(EnumParticleTypes.CRIT_MAGIC, target.field_70165_t, target.field_70163_u + (double)target.field_70131_O * 0.625, target.field_70161_v, 24, 0.125, 0.25, 0.125, 0.5, new int[0]);
                event.setAmount(extraDamage + event.getAmount());
            }
        }
    }

    private static boolean isHuman(Entity entity) {
        return entity instanceof EntityVillager || entity instanceof EntityPlayer || entity instanceof EntityWitch;
    }
}

