/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.EquipmentSlotTypes;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.WonderfulEnchantmentHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ImmortalityEnchantment
extends Enchantment {
    protected static final int damageOnUse = 9001;

    public ImmortalityEnchantment(String name) {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.BREAKABLE, EquipmentSlotTypes.BOTH_HANDS);
        this.func_77322_b(name);
        this.setRegistryName("wonderful_enchantments", name);
        RegistryHandler.ENCHANTMENTS.add(this);
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int level) {
        return 20 + WonderfulEnchantmentHelper.increaseLevelIfEnchantmentIsDisabled(this);
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 30;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemShield && super.canApplyAtEnchantingTable(stack);
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        EntityLivingBase target = event.getEntityLiving();
        if (target.func_110143_aJ() - event.getAmount() <= 0.0f) {
            if (ImmortalityEnchantment.tryCheatDeath(target, target.func_184614_ca())) {
                event.setCanceled(true);
            } else if (ImmortalityEnchantment.tryCheatDeath(target, target.func_184592_cb())) {
                event.setCanceled(true);
            }
        }
    }

    protected static boolean tryCheatDeath(EntityLivingBase target, ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemShield && EnchantmentHelper.func_77506_a((Enchantment)RegistryHandler.IMMORTALITY, (ItemStack)itemStack) > 0) {
            target.func_70606_j(target.func_110138_aP());
            ImmortalityEnchantment.spawnParticlesAndPlaySounds(target);
            itemStack.func_77972_a(9001, target);
            return true;
        }
        return false;
    }

    protected static void spawnParticlesAndPlaySounds(EntityLivingBase entityLivingBase) {
        WorldServer world = (WorldServer)entityLivingBase.func_130014_f_();
        world.func_175739_a(EnumParticleTypes.TOTEM, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + (double)entityLivingBase.field_70131_O * 0.75, entityLivingBase.field_70161_v, 64, 0.25, 0.5, 0.25, 0.5, new int[0]);
        world.func_184148_a(null, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, SoundEvents.field_191263_gW, SoundCategory.AMBIENT, 1.0f, 1.0f);
    }
}

