/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.WonderfulEnchantmentHelper;
import com.wonderfulenchantments.WonderfulEnchantments;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

@Mod.EventBusSubscriber
public class PhoenixDiveEnchantment
extends Enchantment {
    protected static List<Vec3d> positionsToGenerateParticles = new ArrayList<Vec3d>();
    protected static HashMap<Integer, Integer> particleTimers = new HashMap();

    public PhoenixDiveEnchantment(String name) {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.ARMOR_FEET, new EntityEquipmentSlot[]{EntityEquipmentSlot.FEET});
        this.func_77322_b(name);
        this.setRegistryName("wonderful_enchantments", name);
        RegistryHandler.ENCHANTMENTS.add(this);
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int level) {
        return 10 * (level + 1) + WonderfulEnchantmentHelper.increaseLevelIfEnchantmentIsDisabled(this);
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 30;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return !(enchantment instanceof EnchantmentFrostWalker) && super.func_77326_a(enchantment);
    }

    @SubscribeEvent
    public static void onFall(LivingFallEvent event) {
        double distance = event.getDistance();
        if (distance > 3.0) {
            EntityLivingBase attacker = event.getEntityLiving();
            World world = attacker.func_130014_f_();
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)RegistryHandler.PHOENIX_DIVE, (ItemStack)attacker.func_184582_a(EntityEquipmentSlot.FEET));
            if (enchantmentLevel > 0) {
                double range = 5.0;
                List entities = world.func_72839_b((Entity)attacker, attacker.func_174813_aQ().func_72317_d(-range, (double)(-attacker.field_70131_O) * 0.5, -range).func_72321_a(range * 2.0, 0.0, range * 2.0));
                for (Entity entity : entities) {
                    if (!(entity instanceof EntityLiving)) continue;
                    EntityLiving target = (EntityLiving)entity;
                    target.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)attacker), 0.0f);
                    target.func_70097_a(DamageSource.field_76370_b, (float)Math.sqrt((double)enchantmentLevel * distance));
                    target.func_70015_d(20 * (2 * enchantmentLevel));
                }
                positionsToGenerateParticles.add(attacker.func_174791_d());
            }
        }
    }

    @SubscribeEvent
    public static void onUpdate(TickEvent.WorldTickEvent event) {
        if (positionsToGenerateParticles.size() > 0) {
            WorldServer world = (WorldServer)event.world;
            for (Vec3d position : positionsToGenerateParticles) {
                for (double d = 0.0; d < 3.0; d += 1.0) {
                    world.func_175739_a(EnumParticleTypes.FLAME, position.field_72450_a, position.field_72448_b, position.field_72449_c, (int)Math.pow(3.0, d + 1.0), 0.0625, 0.125, 0.0625, 0.1875 * (d + 1.0) * 0.025, new int[0]);
                }
                world.func_184148_a(null, position.field_72450_a, position.field_72448_b, position.field_72449_c, SoundEvents.field_187616_bj, SoundCategory.AMBIENT, 0.25f, 1.0f);
            }
            positionsToGenerateParticles.clear();
        }
        for (Map.Entry<Integer, Integer> pair : particleTimers.entrySet()) {
            Entity entity = event.world.func_73045_a(pair.getKey().intValue());
            int ticks = pair.getValue() + 1;
            if (entity != null && ticks > 3) {
                ticks -= 3;
                PhoenixDiveEnchantment.spawnFootParticle(entity);
            }
            pair.setValue(Math.max(ticks, 0));
        }
        for (Map.Entry<Integer, Integer> pair : particleTimers.entrySet()) {
            if (event.world.func_73045_a(pair.getKey().intValue()) != null) continue;
            particleTimers.values().remove(pair.getKey());
        }
    }

    @SubscribeEvent
    public static void onJump(LivingEvent.LivingJumpEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            ItemStack boots = entity.func_184582_a(EntityEquipmentSlot.FEET);
            int enchantmentLevel = EnchantmentHelper.func_77506_a((Enchantment)RegistryHandler.PHOENIX_DIVE, (ItemStack)boots);
            if (player.func_70093_af() && enchantmentLevel > 0) {
                double angleInRadians = Math.toRadians((double)player.field_70177_z + 90.0);
                double factor = (double)(enchantmentLevel + 1) * 0.33334;
                player.func_70016_h(player.field_70159_w + factor * Math.cos(angleInRadians), player.field_70181_x * (1.0 + (double)(enchantmentLevel + 1) * 0.25), player.field_70179_y + factor * Math.sin(angleInRadians));
                boots.func_77972_a(3, (EntityLivingBase)player);
            }
        }
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        Integer entityID = entityLivingBase.func_145782_y();
        if (EnchantmentHelper.func_185284_a((Enchantment)RegistryHandler.PHOENIX_DIVE, (EntityLivingBase)entityLivingBase) > 0) {
            particleTimers.put(entityID, 0);
        } else {
            particleTimers.remove(entityID);
        }
    }

    protected static void spawnFootParticle(Entity entity) {
        if (entity instanceof EntityLivingBase) {
            World world = entity.func_130014_f_();
            double leftLegRotation = WonderfulEnchantments.RANDOM.nextBoolean() ? 180.0 : 0.0;
            double angleInRadians = Math.toRadians((double)entity.field_70177_z + 90.0 + leftLegRotation);
            if (world instanceof WorldServer) {
                ((WorldServer)world).func_175739_a(EnumParticleTypes.FLAME, entity.field_70165_t + 0.1875 * Math.sin(-angleInRadians), entity.field_70163_u, entity.field_70161_v + 0.1875 * Math.cos(-angleInRadians), 1, 0.0, 0.125 * Math.cos(angleInRadians), 0.0, 0.0, new int[0]);
            }
        }
    }
}

