/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.WonderfulEnchantmentHelper;
import com.wonderfulenchantments.WonderfulEnchantments;
import java.util.ArrayList;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentUntouching;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class SmelterEnchantment
extends Enchantment {
    public SmelterEnchantment(String name) {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.DIGGER, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b(name);
        this.setRegistryName("wonderful_enchantments", name);
        RegistryHandler.ENCHANTMENTS.add(this);
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int level) {
        return 8 * level + WonderfulEnchantmentHelper.increaseLevelIfEnchantmentIsDisabled(this);
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 16;
    }

    public boolean func_77326_a(Enchantment enchantment) {
        return !(enchantment instanceof EnchantmentUntouching) && super.func_77326_a(enchantment);
    }

    @SubscribeEvent
    public static void onBlockDestroy(BlockEvent.HarvestDropsEvent event) {
        if (!(event.getWorld() instanceof WorldServer) || event.getHarvester() == null) {
            return;
        }
        int smelterLevel = EnchantmentHelper.func_77506_a((Enchantment)RegistryHandler.SMELTER, (ItemStack)event.getHarvester().func_184607_cu());
        WorldServer world = (WorldServer)event.getWorld();
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (ItemStack itemStack : event.getDrops()) {
            if (WonderfulEnchantments.RANDOM.nextDouble() <= SmelterEnchantment.getSmeltChance(smelterLevel)) {
                ItemStack recipeOutput = FurnaceRecipes.func_77602_a().func_151395_a(itemStack);
                if (!recipeOutput.func_82833_r().matches("Air")) {
                    int experience;
                    output.add(recipeOutput);
                    BlockPos position = event.getPos();
                    int n = experience = 0.1f > WonderfulEnchantments.RANDOM.nextFloat() ? 1 : 0;
                    if (experience > 0) {
                        world.func_72838_d((Entity)new EntityXPOrb((World)world, (double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, experience));
                    }
                    world.func_175739_a(EnumParticleTypes.FLAME, (double)position.func_177958_n() + 0.5, (double)position.func_177956_o() + 0.5, (double)position.func_177952_p() + 0.5, 1 + WonderfulEnchantments.RANDOM.nextInt(3), 0.125, 0.125, 0.125, 0.03125, new int[0]);
                    continue;
                }
                output.add(itemStack);
                continue;
            }
            output.add(itemStack);
        }
        event.getDrops().clear();
        for (ItemStack itemStack : output) {
            event.getDrops().add(itemStack);
        }
    }

    protected static double getSmeltChance(int smelterLevel) {
        switch (smelterLevel) {
            case 1: {
                return 0.25;
            }
            case 2: {
                return 0.5;
            }
            case 3: {
                return 1.0;
            }
        }
        return 0.0;
    }
}

