/*
 * Decompiled with CFR 0.152.
 */
package com.wonderfulenchantments.enchantments;

import com.wonderfulenchantments.AttributeHelper;
import com.wonderfulenchantments.EquipmentSlotTypes;
import com.wonderfulenchantments.RegistryHandler;
import com.wonderfulenchantments.WonderfulEnchantmentHelper;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.item.ItemShield;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class VitalityEnchantment
extends Enchantment {
    protected static final AttributeHelper attributeHelper = new AttributeHelper("575cb29a-1ee4-11eb-adc1-0242ac120002", "VitalityBonus", SharedMonsterAttributes.field_111267_a, 0);
    protected static final double healthPerLevel = 2.0;

    public VitalityEnchantment(String name) {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.BREAKABLE, EquipmentSlotTypes.BOTH_HANDS);
        this.func_77322_b(name);
        this.setRegistryName("wonderful_enchantments", name);
        RegistryHandler.ENCHANTMENTS.add(this);
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int level) {
        return 5 + 8 * level + WonderfulEnchantmentHelper.increaseLevelIfEnchantmentIsDisabled(this);
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 10;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemShield && super.canApplyAtEnchantingTable(stack);
    }

    @SubscribeEvent
    public static void onEquipmentChange(LivingEquipmentChangeEvent event) {
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        attributeHelper.setValue(VitalityEnchantment.getHealthBonus(entityLivingBase)).apply(entityLivingBase);
    }

    protected static double getHealthBonus(EntityLivingBase entityLivingBase) {
        int sum = WonderfulEnchantmentHelper.calculateEnchantmentSumIfIsInstanceOf(RegistryHandler.VITALITY, entityLivingBase, EquipmentSlotTypes.BOTH_HANDS, ItemShield.class);
        return (double)sum * 2.0;
    }
}

