/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.TinkerAPIException;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.TinkerTexture;

public abstract class AbstractColoredTexture
extends TinkerTexture {
    private ResourceLocation backupTextureLocation;

    protected AbstractColoredTexture(ResourceLocation baseTextureLocation, String spriteName) {
        super(spriteName);
        this.backupTextureLocation = baseTextureLocation;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of((Object)this.backupTextureLocation);
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        this.field_110976_a = Lists.newArrayList();
        this.field_110973_g = 0;
        this.field_110983_h = 0;
        TextureAtlasSprite baseTexture = textureGetter.apply(this.backupTextureLocation);
        if (baseTexture == null || baseTexture.func_110970_k() <= 0) {
            this.field_130223_c = 1;
            this.field_130224_d = 1;
            return false;
        }
        this.func_94217_a(baseTexture);
        int[][] original = baseTexture.func_147965_a(0);
        int[][] data = new int[original.length][];
        data[0] = Arrays.copyOf(original[0], original[0].length);
        this.processData(data[0]);
        if (this.field_110976_a.isEmpty()) {
            this.field_110976_a.add(data);
        }
        return false;
    }

    protected void processData(int[] data) {
        try {
            this.preProcess(data);
            for (int pxCoord = 0; pxCoord < data.length; ++pxCoord) {
                data[pxCoord] = this.colorPixel(data[pxCoord], pxCoord);
            }
            this.postProcess(data);
        }
        catch (Exception e) {
            throw new TinkerAPIException("Error occured while processing: " + this.func_94215_i(), e);
        }
    }

    protected void preProcess(int[] data) {
    }

    protected void postProcess(int[] data) {
    }

    protected abstract int colorPixel(int var1, int var2);

    public static int getPerceptualBrightness(int col) {
        double r = (double)RenderUtil.red(col) / 255.0;
        double g = (double)RenderUtil.green(col) / 255.0;
        double b = (double)RenderUtil.blue(col) / 255.0;
        return AbstractColoredTexture.getPerceptualBrightness(r, g, b);
    }

    public static int getPerceptualBrightness(double r, double g, double b) {
        double brightness = Math.sqrt(0.241 * r * r + 0.691 * g * g + 0.068 * b * b);
        return (int)(brightness * 255.0);
    }

    protected static int mult(int c1, int c2) {
        return (int)((float)c1 * ((float)c2 / 255.0f));
    }

    protected int getX(int pxCoord) {
        return pxCoord % this.field_130223_c;
    }

    protected int getY(int pxCoord) {
        return pxCoord / this.field_130223_c;
    }

    protected int coord(int x, int y) {
        return y * this.field_130223_c + x;
    }
}

