/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.library.client.texture;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;

public class TextureColoredTexture
extends AbstractColoredTexture {
    protected final ResourceLocation addTextureLocation;
    protected TextureAtlasSprite addTexture;
    protected int[] textureData;
    protected int addTextureWidth;
    protected int addTextureHeight;
    protected float scale;
    protected int offsetX = 0;
    protected int offsetY = 0;
    public boolean stencil = false;

    public TextureColoredTexture(ResourceLocation addTextureLocation, ResourceLocation baseTexture, String spriteName) {
        super(baseTexture, spriteName);
        this.addTextureLocation = addTextureLocation;
    }

    @Override
    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.builder().addAll(super.getDependencies()).add((Object)this.addTextureLocation).build();
    }

    @Override
    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        this.addTexture = textureGetter.apply(this.addTextureLocation);
        super.load(manager, location, textureGetter);
        return false;
    }

    @Override
    protected void preProcess(int[] data) {
        this.textureData = this.addTexture.func_147965_a(0)[0];
        this.addTextureWidth = this.addTexture.func_94211_a();
        this.addTextureHeight = this.addTexture.func_94216_b();
        this.scale = (float)this.addTextureHeight / (float)this.field_130223_c;
    }

    @Override
    protected void postProcess(int[] data) {
        this.textureData = null;
    }

    @Override
    protected int colorPixel(int pixel, int pxCoord) {
        int a = RenderUtil.alpha(pixel);
        if (a == 0) {
            return pixel;
        }
        int texCoord = pxCoord;
        if (this.field_130223_c > this.addTextureWidth) {
            int texX = pxCoord % this.field_130223_c % this.addTextureWidth;
            int texY = pxCoord / this.field_130224_d % this.addTextureHeight;
            texCoord = texY * this.addTextureWidth + texX;
        }
        int c = this.textureData[texCoord];
        int r = RenderUtil.red(c);
        int b = RenderUtil.blue(c);
        int g = RenderUtil.green(c);
        if (!this.stencil) {
            r = TextureColoredTexture.mult(TextureColoredTexture.mult(r, RenderUtil.red(pixel)), RenderUtil.red(pixel));
            g = TextureColoredTexture.mult(TextureColoredTexture.mult(g, RenderUtil.green(pixel)), RenderUtil.green(pixel));
            b = TextureColoredTexture.mult(TextureColoredTexture.mult(b, RenderUtil.blue(pixel)), RenderUtil.blue(pixel));
        }
        return RenderUtil.compose(r, g, b, a);
    }

    public void setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
    }

    protected int coord2(int x, int y) {
        return y * this.addTextureWidth + x;
    }
}

