/*
 * Decompiled with CFR 0.152.
 */
package xyz.vsngamer.elevator.init;

import java.util.EnumMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.vsngamer.elevator.blocks.BlockElevator;
import xyz.vsngamer.elevator.init.ModConfig;
import xyz.vsngamer.elevator.network.NetworkHandler;
import xyz.vsngamer.elevator.network.SyncConfig;

@Mod.EventBusSubscriber(modid="elevatorid")
public class Registry {
    private static EnumMap<EnumDyeColor, BlockElevator> ELEVATOR_BLOCKS = new EnumMap(EnumDyeColor.class);
    public static EnumMap<EnumDyeColor, ItemBlock> ELEVATOR_ITEMBLOCKS = new EnumMap(EnumDyeColor.class);

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> e) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            BlockElevator block = new BlockElevator(color);
            e.getRegistry().register((IForgeRegistryEntry)block);
            ELEVATOR_BLOCKS.put(color, block);
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> e) {
        for (EnumDyeColor color : EnumDyeColor.values()) {
            ItemBlock itemBlock = new ItemBlock((Block)ELEVATOR_BLOCKS.get(color));
            itemBlock.setRegistryName("elevator_" + color.func_176610_l());
            e.getRegistry().register((IForgeRegistryEntry)itemBlock);
            ELEVATOR_ITEMBLOCKS.put(color, itemBlock);
            OreDictionary.registerOre((String)"blockElevator", (Item)itemBlock);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent e) {
        for (ItemBlock itemBlock : ELEVATOR_ITEMBLOCKS.values()) {
            ModelLoader.setCustomModelResourceLocation((Item)itemBlock, (int)0, (ModelResourceLocation)new ModelResourceLocation(itemBlock.getRegistryName(), "inventory"));
        }
    }

    @SubscribeEvent
    public static void configChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("elevatorid")) {
            ConfigManager.sync((String)"elevatorid", (Config.Type)Config.Type.INSTANCE);
            if (Minecraft.func_71410_x().func_71387_A()) {
                ModConfig.setClientConfig(ModConfig.serverConfig.sameColor, ModConfig.serverConfig.range, ModConfig.serverConfig.skipUnreachable);
            }
        }
    }

    @SubscribeEvent
    public static void syncServerConfig(PlayerEvent.PlayerLoggedInEvent e) {
        EntityPlayerMP player = (EntityPlayerMP)e.player;
        NetworkHandler.networkWrapper.sendTo((IMessage)new SyncConfig(ModConfig.serverConfig.sameColor, ModConfig.serverConfig.range, ModConfig.serverConfig.skipUnreachable), player);
    }
}

