/*
 * Decompiled with CFR 0.152.
 */
package com.tmtravlr.potioncore.network;

import com.tmtravlr.potioncore.PotionCoreAttributes;
import com.tmtravlr.potioncore.network.CToSMessage;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketHandlerServer
implements IMessageHandler<CToSMessage, IMessage> {
    public static final int CLIMB_FALL = 1;
    public static final int USE_ENTITY = 2;
    public static final int ATTACK_ENTITY = 3;
    public static final int INTERACT_ENTITY = 4;
    public static final int INTERACT_AT_ENTITY = 5;

    public IMessage onMessage(CToSMessage packet, MessageContext context) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        PacketBuffer buff = new PacketBuffer(Unpooled.wrappedBuffer((byte[])packet.getData()));
        int type = buff.readInt();
        switch (type) {
            case 1: {
                server.func_152344_a(() -> {
                    EntityPlayerMP player = server.func_184103_al().func_177451_a(new UUID(buff.readLong(), buff.readLong()));
                    if (player != null) {
                        player.field_70143_R = 0.0f;
                    }
                });
                break;
            }
            case 2: {
                server.func_152344_a(() -> {
                    EntityPlayerMP player = server.func_184103_al().func_177451_a(new UUID(buff.readLong(), buff.readLong()));
                    if (player != null) {
                        PacketHandlerServer.useEntity(player, buff);
                    }
                });
                break;
            }
        }
        return null;
    }

    private static void useEntity(EntityPlayerMP player, PacketBuffer buff) {
        WorldServer worldServer = player.field_70170_p.func_73046_m().func_71218_a(player.field_71093_bK);
        player.func_143004_u();
        int targetId = buff.readInt();
        Entity entity = worldServer.func_73045_a(targetId);
        if (entity == null) {
            return;
        }
        int type = buff.readInt();
        if ((double)player.func_70032_d(entity) <= PotionCoreAttributes.getPlayerReachDistance((EntityPlayer)player)) {
            switch (type) {
                case 4: {
                    EnumHand enumhand = (EnumHand)buff.func_179257_a(EnumHand.class);
                    player.func_190775_a(entity, enumhand);
                    break;
                }
                case 5: {
                    EnumHand enumhand = (EnumHand)buff.func_179257_a(EnumHand.class);
                    ItemStack itemstack1 = player.func_184586_b(enumhand);
                    Vec3d posVec = new Vec3d(buff.readDouble(), buff.readDouble(), buff.readDouble());
                    if (ForgeHooks.onInteractEntityAt((EntityPlayer)player, (Entity)entity, (Vec3d)posVec, (EnumHand)enumhand) != null) break;
                    entity.func_184199_a((EntityPlayer)player, posVec, enumhand);
                    break;
                }
                case 3: {
                    if (entity instanceof EntityItem || entity instanceof EntityXPOrb || entity instanceof EntityArrow || entity == player) {
                        player.field_71135_a.func_194028_b((ITextComponent)new TextComponentTranslation("multiplayer.disconnect.invalid_entity_attacked", new Object[0]));
                        FMLLog.warning((String)("Player " + player.func_70005_c_() + " tried to attack an invalid entity"), (Object[])new Object[0]);
                        break;
                    }
                    player.func_71059_n(entity);
                }
            }
        }
    }
}

