/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.xptome;

import bl4ckscor3.mod.xptome.Configuration;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import openmods.utils.EnchantmentUtils;

public class ItemXPTome
extends Item {
    public static final String NAME = "xp_tome";

    public ItemXPTome() {
        this.func_77637_a(CreativeTabs.field_78026_f);
        this.func_77625_d(1);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        int storedXP = this.getStoredXP(stack);
        if (stack.func_190916_E() > 1) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (player.func_70093_af() && storedXP < Configuration.maxXP) {
            int xpToStore = 0;
            if (Configuration.storeUntilPreviousLevel) {
                int xpForCurrentLevel = EnchantmentUtils.getExperienceForLevel(player.field_71068_ca);
                xpToStore = EnchantmentUtils.getPlayerXP(player) - xpForCurrentLevel;
                if (xpToStore == 0 && player.field_71068_ca > 0) {
                    xpToStore = xpForCurrentLevel - EnchantmentUtils.getExperienceForLevel(player.field_71068_ca - 1);
                }
            } else {
                xpToStore = EnchantmentUtils.getPlayerXP(player);
            }
            if (xpToStore == 0) {
                return new ActionResult(EnumActionResult.PASS, (Object)stack);
            }
            int actuallyStored = this.addXP(stack, xpToStore);
            if (actuallyStored > 0) {
                EnchantmentUtils.addPlayerXP(player, -actuallyStored);
            }
            if (!world.field_72995_K) {
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.35f + 0.9f);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!player.func_70093_af() && storedXP > 0) {
            if (Configuration.retriveUntilNextLevel) {
                int xpForPlayer = EnchantmentUtils.getExperienceForLevel(player.field_71068_ca + 1) - EnchantmentUtils.getPlayerXP(player);
                int xpToRetrieve = (int)Math.floor((double)xpForPlayer / Configuration.retrievalPercentage);
                int actuallyRemoved = this.removeXP(stack, xpToRetrieve);
                if (actuallyRemoved < xpForPlayer) {
                    xpForPlayer = (int)Math.floor((double)actuallyRemoved * Configuration.retrievalPercentage);
                }
                EnchantmentUtils.addPlayerXP(player, xpForPlayer);
            } else {
                EnchantmentUtils.addPlayerXP(player, (int)Math.ceil((double)storedXP * Configuration.retrievalPercentage));
                this.setStoredXP(stack, 0);
            }
            if (!world.field_72995_K) {
                float pitchMultiplier = player.field_71068_ca > 30 ? 1.0f : (float)player.field_71068_ca / 30.0f;
                world.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, pitchMultiplier * 0.75f, 1.0f);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return Math.max(0.0, 1.0 - (double)this.getStoredXP(stack) / (double)Configuration.maxXP);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getStoredXP(stack) > 0;
    }

    public boolean func_77645_m() {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<String> tooltip, ITooltipFlag flag) {
        tooltip.add(I18n.func_135052_a((String)"xpbook.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"xpbook.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"xpbook.tooltip.3", (Object[])new Object[]{this.getStoredXP(stack), Configuration.maxXP}));
    }

    public int addXP(ItemStack stack, int amount) {
        int maxStorage;
        if (amount <= 0) {
            return 0;
        }
        int stored = this.getStoredXP(stack);
        if (stored >= (maxStorage = Configuration.maxXP)) {
            return 0;
        }
        if (stored + amount <= maxStorage) {
            this.setStoredXP(stack, stored + amount);
            return amount;
        }
        this.setStoredXP(stack, maxStorage);
        return maxStorage - stored;
    }

    public int removeXP(ItemStack stack, int amount) {
        if (amount <= 0) {
            return 0;
        }
        int stored = this.getStoredXP(stack);
        if (stored <= 0) {
            return 0;
        }
        if (stored >= amount) {
            this.setStoredXP(stack, stored - amount);
            return amount;
        }
        this.setStoredXP(stack, 0);
        return stored;
    }

    public void setStoredXP(ItemStack stack, int amount) {
        this.getOrCreateTag(stack).func_74768_a("xp", amount);
    }

    public int getStoredXP(ItemStack stack) {
        return this.getOrCreateTag(stack).func_74762_e("xp");
    }

    private NBTTagCompound getOrCreateTag(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }
}

